/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.universa.ErrorRecord;
import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.StateRecord;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ItemResult {
    public static final ItemResult DISCARDED = new ItemResult(ItemState.DISCARDED, false, null, null);
    public static final ItemResult UNDEFINED = new ItemResult(ItemState.UNDEFINED, false, null, null);
    public final @NonNull ItemState state;
    public final boolean haveCopy;
    public final @NonNull ZonedDateTime createdAt;
    public final @NonNull ZonedDateTime expiresAt;
    public List<ErrorRecord> errors;
    public HashId lockedById = null;
    public final transient Binder meta = new Binder();

    public ItemResult(StateRecord record, boolean haveCopy) {
        this.state = record.getState();
        this.haveCopy = haveCopy;
        this.createdAt = record.getCreatedAt();
        this.expiresAt = record.getExpiresAt();
    }

    public ItemResult(StateRecord record) {
        this(record, false);
    }

    public ItemResult(Binder fields) {
        this.state = ItemState.valueOf(fields.getStringOrThrow("state"));
        this.haveCopy = fields.getBooleanOrThrow("haveCopy");
        this.createdAt = fields.getZonedDateTime("createdAt", null);
        this.expiresAt = fields.getZonedDateTime("expiresAt", null);
        this.errors = new ArrayList<ErrorRecord>();
        fields.getList("errors", Collections.EMPTY_LIST).forEach(x -> this.errors.add(x instanceof Binder ? new ErrorRecord((Binder)x) : (ErrorRecord)x));
        this.lockedById = (HashId)fields.get("lockedById");
    }

    public ItemResult(ItemState state, boolean haveCopy, @NonNull ZonedDateTime createdAt, @NonNull ZonedDateTime expiresAt) {
        this.state = state;
        this.haveCopy = haveCopy;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
    }

    public ItemResult(Boss.Reader br) throws IOException {
        this.state = ItemState.values()[br.readInt()];
        this.createdAt = ZonedDateTime.ofInstant(Instant.ofEpochSecond(br.readLong()), ZoneId.systemDefault());
        this.expiresAt = ZonedDateTime.ofInstant(Instant.ofEpochSecond(br.readLong()), ZoneId.systemDefault());
        this.haveCopy = (Boolean)br.read();
    }

    public Binder toBinder() {
        return Binder.fromKeysValues("state", this.state.name(), "haveCopy", this.haveCopy, "createdAt", this.createdAt, "expiresAt", this.expiresAt, "errors", DefaultBiMapper.serialize(this.errors), "lockedById", this.lockedById);
    }

    public String toString() {
        String s = "";
        if (this.errors != null && !this.errors.isEmpty()) {
            s = " errors: " + this.errors.stream().map(e -> e.toString()).collect(Collectors.joining(","));
        }
        return "ItemResult<" + (Object)((Object)this.state) + " " + this.createdAt + " (" + (this.haveCopy ? "copy" : "") + ")" + s + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemResult) {
            ItemResult result2 = (ItemResult)obj;
            if (result2.state == this.state && result2.haveCopy == this.haveCopy && this.createdAt.truncatedTo(ChronoUnit.SECONDS).equals(result2.createdAt.truncatedTo(ChronoUnit.SECONDS))) {
                return this.expiresAt.truncatedTo(ChronoUnit.SECONDS).equals(result2.expiresAt.truncatedTo(ChronoUnit.SECONDS));
            }
        }
        return false;
    }

    public void writeTo(Boss.Writer bw) throws IOException {
        bw.writeObject(this.state.ordinal());
        if (this.createdAt != null) {
            bw.writeObject(this.createdAt.toEpochSecond());
        } else {
            bw.writeObject(0);
        }
        if (this.expiresAt != null) {
            bw.writeObject(this.expiresAt.toEpochSecond());
        } else {
            bw.writeObject(0);
        }
        bw.writeObject(this.haveCopy);
    }

    static {
        DefaultBiMapper.registerAdapter(ItemResult.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return ((ItemResult)object).toBinder();
            }

            public ItemResult deserialize(Binder binder, BiDeserializer deserializer) {
                return new ItemResult(binder);
            }

            @Override
            public String typeName() {
                return "ItemResult";
            }
        });
    }
}

