/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.crypto.PrivateKey;
import com.icodici.db.Db;
import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Callable;

public interface Ledger {
    public StateRecord getRecord(HashId var1);

    public StateRecord createOutputLockRecord(long var1, HashId var3);

    public StateRecord getLockOwnerOf(StateRecord var1);

    public StateRecord findOrCreate(HashId var1);

    default public boolean isApproved(HashId id) {
        StateRecord r = this.getRecord(id);
        return r != null && r.getState().isApproved();
    }

    default public boolean isConsensusFound(HashId id) {
        StateRecord r = this.getRecord(id);
        return r != null && r.getState().isConsensusFound();
    }

    public <T> T transaction(Callable<T> var1);

    public void destroy(StateRecord var1);

    public void save(StateRecord var1);

    public void reload(StateRecord var1) throws StateRecord.NotFoundException;

    default public void close() {
    }

    default public long countRecords() {
        return -1L;
    }

    default public StateRecord getLockOwnerOf(HashId itemId) {
        return this.getLockOwnerOf(this.getRecord(itemId));
    }

    public Map<ItemState, Integer> getLedgerSize(Instant var1);

    public void saveConfig(NodeInfo var1, NetConfig var2, PrivateKey var3);

    public Object[] loadConfig();

    public void addNode(NodeInfo var1);

    public void removeNode(NodeInfo var1);

    public Map<HashId, StateRecord> findUnfinished();

    public Approvable getItem(StateRecord var1);

    public void putItem(StateRecord var1, Approvable var2, Instant var3);

    public void cleanup();

    public static class Failure
    extends RuntimeException {
        public Failure() {
        }

        public Failure(String message) {
            super(message);
        }

        public Failure(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Rollback
    extends Db.RollbackException {
    }
}

