/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.crypto.PrivateKey;
import com.icodici.db.Db;
import com.icodici.db.DbPool;
import com.icodici.db.PooledDb;
import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.Ledger;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

public class PostgresLedger
implements Ledger {
    private static final int MAX_CONNECTIONS = 64;
    private final DbPool dbPool;
    private boolean sqlite = false;
    private Map<HashId, WeakReference<StateRecord>> cachedRecords = new WeakHashMap<HashId, WeakReference<StateRecord>>();
    private Map<Long, WeakReference<StateRecord>> cachedRecordsById = new WeakHashMap<Long, WeakReference<StateRecord>>();
    private boolean useCache = true;

    public PostgresLedger(String connectionString, Properties properties) throws SQLException {
        this.dbPool = new DbPool(connectionString, properties, 64);
        this.init(this.dbPool);
    }

    public PostgresLedger(String connectionString) throws SQLException {
        Properties properties = new Properties();
        this.dbPool = new DbPool(connectionString, properties, 64);
        this.init(this.dbPool);
    }

    private void init(DbPool dbPool) throws SQLException {
        try {
            dbPool.execute(db -> db.setupDatabase("/migrations/postgres/migrate_"));
        }
        catch (Exception e) {
            throw new SQLException("Failed to migrate", e);
        }
    }

    public final <T> T inPool(DbPool.DbConsumer<T> consumer) throws Exception {
        return this.dbPool.execute(consumer);
    }

    @Override
    public StateRecord getRecord(HashId itemId) {
        StateRecord sr = this.protect(() -> {
            StateRecord cached = this.getFromCache(itemId);
            if (cached != null) {
                return cached;
            }
            try (ResultSet rs = this.inPool(db -> db.queryRow("SELECT * FROM ledger WHERE hash = ? limit 1", new Object[]{itemId.getDigest()}));){
                if (rs == null) return null;
                StateRecord record = new StateRecord(this, rs);
                this.putToCache(record);
                StateRecord stateRecord = record;
                return stateRecord;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        });
        if (sr != null && sr.isExpired()) {
            sr.destroy();
            return null;
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateRecord getFromCache(HashId itemId) {
        if (this.useCache) {
            Map<HashId, WeakReference<StateRecord>> map = this.cachedRecords;
            synchronized (map) {
                WeakReference<StateRecord> ref = this.cachedRecords.get(itemId);
                if (ref == null) {
                    return null;
                }
                StateRecord r = (StateRecord)ref.get();
                if (r == null) {
                    this.cachedRecords.remove(itemId);
                    return null;
                }
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateRecord getFromCacheById(long recordId) {
        if (this.useCache) {
            Map<Long, WeakReference<StateRecord>> map = this.cachedRecordsById;
            synchronized (map) {
                WeakReference<StateRecord> ref = this.cachedRecordsById.get(recordId);
                if (ref == null) {
                    return null;
                }
                StateRecord r = (StateRecord)ref.get();
                if (r == null) {
                    this.cachedRecordsById.remove(recordId);
                    return null;
                }
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToCache(StateRecord r) {
        if (this.useCache) {
            Map<Comparable<HashId>, WeakReference<StateRecord>> map = this.cachedRecords;
            synchronized (map) {
                this.cachedRecords.put(r.getId(), new WeakReference<StateRecord>(r));
            }
            map = this.cachedRecordsById;
            synchronized (map) {
                this.cachedRecordsById.put(r.getRecordId(), new WeakReference<StateRecord>(r));
            }
        }
    }

    @Override
    public StateRecord createOutputLockRecord(long creatorRecordId, HashId newItemHashId) {
        StateRecord r = new StateRecord(this);
        r.setState(ItemState.LOCKED_FOR_CREATION);
        r.setLockedByRecordId(creatorRecordId);
        r.setId(newItemHashId);
        try {
            r.save();
            return r;
        }
        catch (Ledger.Failure e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public StateRecord getLockOwnerOf(StateRecord rc) {
        StateRecord cached = this.getFromCacheById(rc.getLockedByRecordId());
        if (cached != null) {
            return cached;
        }
        StateRecord sr = this.protect(() -> this.dbPool.execute(db -> {
            try (ResultSet rs = db.queryRow("SELECT * FROM ledger WHERE id = ? limit 1", rc.getLockedByRecordId());){
                if (rs == null) {
                    StateRecord stateRecord = null;
                    return stateRecord;
                }
                StateRecord r = new StateRecord(this, rs);
                this.putToCache(r);
                StateRecord stateRecord = r;
                return stateRecord;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }));
        if (sr != null && sr.isExpired()) {
            sr.destroy();
            return null;
        }
        return sr;
    }

    @Override
    public StateRecord findOrCreate(HashId itemId) {
        return this.protect(() -> {
            StateRecord record = this.getFromCache(itemId);
            if (record == null) {
                try (ResultSet rs = this.inPool(db -> db.queryRow("select * from sr_find_or_create(?)", new Object[]{itemId.getDigest()}));){
                    record = new StateRecord(this, rs);
                    this.putToCache(record);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            return record;
        });
    }

    @Override
    public Map<HashId, StateRecord> findUnfinished() {
        return this.protect(() -> {
            HashMap<HashId, StateRecord> map = new HashMap<HashId, StateRecord>();
            try (ResultSet rs = this.inPool(db -> db.queryRow("select * from sr_find_unfinished()", new Object[0]));){
                if (rs != null) {
                    do {
                        StateRecord record;
                        if ((record = new StateRecord(this, rs)).isExpired()) {
                            record.destroy();
                            continue;
                        }
                        map.put(record.getId(), record);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            return map;
        });
    }

    @Override
    public Approvable getItem(StateRecord record) {
        return this.protect(() -> {
            try (ResultSet rs = this.inPool(db -> db.queryRow("select * from items where id = ?", record.getRecordId()));){
                if (rs == null) {
                    Contract contract = null;
                    return contract;
                }
                Contract contract = Contract.fromPackedTransaction(rs.getBytes("packed"));
                return contract;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        });
    }

    @Override
    public void putItem(StateRecord record, Approvable item, Instant keepTill) {
        if (item instanceof Contract) {
            try (PooledDb db = this.dbPool.db();){
                try (PreparedStatement statement = db.statement("insert into items(id,packed,keepTill) values(?,?,?);", new Object[0]);){
                    statement.setLong(1, record.getRecordId());
                    statement.setBytes(2, ((Contract)item).getPackedTransaction());
                    statement.setLong(3, keepTill.getEpochSecond());
                    db.updateWithStatement(statement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new Ledger.Failure("item save failed:" + se);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private <T> T protect(Callable<T> block) {
        try {
            return block.call();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Ledger.Failure("Ledger operation failed: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void close() {
        try {
            this.dbPool.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long countRecords() {
        try {
            return this.dbPool.execute(db -> (long)((Long)db.queryOne("SELECT COUNT(*) FROM ledger", new Object[0])));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public Map<ItemState, Integer> getLedgerSize(Instant createdAfter) {
        return this.protect(() -> {
            try (ResultSet rs = this.inPool(db -> db.queryRow("select count(id), state from ledger where created_at >= ? group by state", createdAfter != null ? createdAfter.getEpochSecond() : 0L));){
                HashMap<ItemState, Integer> result = new HashMap<ItemState, Integer>();
                if (rs != null) {
                    do {
                        int count = rs.getInt(1);
                        ItemState state = ItemState.values()[rs.getInt(2)];
                        result.put(state, count);
                    } while (rs.next());
                }
                HashMap<ItemState, Integer> hashMap = result;
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        });
    }

    @Override
    public <T> T transaction(Callable<T> callable) {
        return (T)this.protect(() -> {
            try (PooledDb db = this.dbPool.db();){
                Object object = ((Db)db).transaction(() -> callable.call());
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        });
    }

    public void testClearLedger() {
        try {
            this.dbPool.execute(db -> {
                db.update("truncate ledger;", new Object[0]);
                return null;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy(StateRecord record) {
        long recordId = record.getRecordId();
        if (recordId == 0L) {
            throw new IllegalStateException("can't destroy record without recordId");
        }
        this.protect(() -> {
            this.inPool(d -> {
                d.update("DELETE FROM items WHERE id = ?", recordId);
                d.update("DELETE FROM ledger WHERE id = ?", recordId);
                return null;
            });
            Map<Comparable<HashId>, WeakReference<StateRecord>> map = this.cachedRecords;
            synchronized (map) {
                this.cachedRecords.remove(record.getId());
            }
            map = this.cachedRecordsById;
            synchronized (map) {
                this.cachedRecordsById.remove(record.getRecordId());
            }
            return null;
        });
    }

    @Override
    public void save(StateRecord stateRecord) {
        block47: {
            if (stateRecord.getLedger() == null) {
                stateRecord.setLedger(this);
            } else if (stateRecord.getLedger() != this) {
                throw new IllegalStateException("can't save with a different ledger (make a copy!)");
            }
            try (PooledDb db = this.dbPool.db();){
                if (stateRecord.getRecordId() == 0L) {
                    try (PreparedStatement statement = db.statementReturningKeys("insert into ledger(hash,state,created_at, expires_at, locked_by_id) values(?,?,?,?,?);", new Object[0]);){
                        statement.setBytes(1, stateRecord.getId().getDigest());
                        statement.setInt(2, stateRecord.getState().ordinal());
                        statement.setLong(3, StateRecord.unixTime(stateRecord.getCreatedAt()));
                        statement.setLong(4, StateRecord.unixTime(stateRecord.getExpiresAt()));
                        statement.setLong(5, stateRecord.getLockedByRecordId());
                        db.updateWithStatement(statement);
                        try (ResultSet keys = statement.getGeneratedKeys();){
                            if (!keys.next()) {
                                throw new RuntimeException("generated keys are not supported");
                            }
                            long id = keys.getLong(1);
                            stateRecord.setRecordId(id);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    this.putToCache(stateRecord);
                    break block47;
                }
                db.update("update ledger set state=?, expires_at=?, locked_by_id=? where id=?", stateRecord.getState().ordinal(), StateRecord.unixTime(stateRecord.getExpiresAt()), stateRecord.getLockedByRecordId(), stateRecord.getRecordId());
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new Ledger.Failure("StateRecord save failed:" + se);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void reload(StateRecord stateRecord) throws StateRecord.NotFoundException {
        try {
            try (PooledDb db = this.dbPool.db();
                 ResultSet rs = db.queryRow("SELECT * FROM ledger WHERE hash = ? limit 1", new Object[]{stateRecord.getId().getDigest()});){
                if (rs == null) {
                    throw new StateRecord.NotFoundException("record not found");
                }
                stateRecord.initFrom(rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to reload RecordSet", e);
        }
    }

    public void enableCache(boolean enable) {
        if (enable) {
            this.useCache = true;
        } else {
            this.useCache = false;
            this.cachedRecords.clear();
            this.cachedRecordsById.clear();
        }
    }

    public Db getDb() throws SQLException {
        return this.dbPool.db();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveConfig(NodeInfo myInfo, NetConfig netConfig, PrivateKey nodeKey) {
        try (PooledDb db = this.dbPool.db();){
            try (PreparedStatement statement = db.statement("delete from config;", new Object[0]);){
                db.updateWithStatement(statement);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            for (NodeInfo nodeInfo : netConfig.toList()) {
                String sqlText = nodeInfo.getNumber() == myInfo.getNumber() ? "insert into config(http_client_port,http_server_port,udp_server_port, node_number, node_name, public_host,host,public_key,private_key) values(?,?,?,?,?,?,?,?,?);" : "insert into config(http_client_port,http_server_port,udp_server_port, node_number, node_name, public_host,host,public_key) values(?,?,?,?,?,?,?,?);";
                try {
                    PreparedStatement statement = db.statementReturningKeys(sqlText, new Object[0]);
                    Throwable throwable = null;
                    try {
                        statement.setInt(1, nodeInfo.getClientAddress().getPort());
                        statement.setInt(2, nodeInfo.getServerAddress().getPort());
                        statement.setInt(3, nodeInfo.getNodeAddress().getPort());
                        statement.setInt(4, nodeInfo.getNumber());
                        statement.setString(5, nodeInfo.getName());
                        statement.setString(6, nodeInfo.getPublicHost());
                        statement.setString(7, nodeInfo.getClientAddress().getHostName());
                        statement.setBytes(8, nodeInfo.getPublicKey().pack());
                        if (statement.getParameterMetaData().getParameterCount() > 8) {
                            statement.setBytes(9, nodeKey.pack());
                        }
                        db.updateWithStatement(statement);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                    return;
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new Ledger.Failure("config save failed:" + se);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object[] loadConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addNode(NodeInfo nodeInfo) {
        try (PooledDb db = this.dbPool.db();){
            String sqlText = "insert into config(http_client_port,http_server_port,udp_server_port, node_number, node_name, public_host,host,public_key) values(?,?,?,?,?,?,?,?);";
            try (PreparedStatement statement = db.statementReturningKeys(sqlText, new Object[0]);){
                statement.setInt(1, nodeInfo.getClientAddress().getPort());
                statement.setInt(2, nodeInfo.getServerAddress().getPort());
                statement.setInt(3, nodeInfo.getNodeAddress().getPort());
                statement.setInt(4, nodeInfo.getNumber());
                statement.setString(5, nodeInfo.getName());
                statement.setString(6, nodeInfo.getPublicHost());
                statement.setString(7, nodeInfo.getClientAddress().getHostName());
                statement.setBytes(8, nodeInfo.getPublicKey().pack());
                db.updateWithStatement(statement);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new Ledger.Failure("add node failed:" + se);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeNode(NodeInfo nodeInfo) {
        try (PooledDb db = this.dbPool.db();){
            String sqlText = "delete from config where node_number = ?;";
            try (PreparedStatement statement = db.statementReturningKeys(sqlText, nodeInfo.getNumber());){
                db.updateWithStatement(statement);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new Ledger.Failure("remove node failed:" + se);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
        try (PooledDb db = this.dbPool.db();){
            long now = Instant.now().getEpochSecond();
            String sqlText = "delete from items where id in (select id from ledger where expires_at < ?);";
            db.update(sqlText, now);
            sqlText = "delete from ledger where expires_at < ?;";
            db.update(sqlText, now);
            sqlText = "delete from items where keepTill < ?;";
            db.update(sqlText, now);
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new Ledger.Failure("cleanup failed:" + se);
        }
    }
}

