/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.universa.node.AbstractRateCounter;
import java.io.Serializable;
import java.time.Duration;

public class RateCounter
extends AbstractRateCounter {
    private int limit;
    private Duration period;
    private TimeSlot currentTimeSlot;

    public RateCounter(int limit, Duration period) {
        this.reset(limit, period);
    }

    @Override
    public void reset(int limit, Duration period) {
        this.limit = limit;
        this.period = period;
    }

    @Override
    public Duration getDuration() {
        return this.period;
    }

    @Override
    public int getPulseLimit() {
        return this.limit;
    }

    @Override
    public int pulsesLeft() {
        if (this.currentTimeSlot != null && this.currentTimeSlot.isActive()) {
            return this.currentTimeSlot.limit - this.currentTimeSlot.currentCount;
        }
        return this.limit;
    }

    public long millisecondsLeft() {
        if (this.currentTimeSlot != null && this.currentTimeSlot.isActive()) {
            return this.currentTimeSlot.millisecondsLeft();
        }
        return 0L;
    }

    @Override
    public boolean countPulse() {
        if (this.currentTimeSlot == null || !this.currentTimeSlot.isActive()) {
            this.currentTimeSlot = new TimeSlot(this.limit, this.period);
        }
        return this.currentTimeSlot.countPulse();
    }

    public class TimeSlot
    implements Serializable {
        private int limit;
        private int currentCount;
        private long startTime;
        private Duration period;

        public TimeSlot(int limit, Duration period) {
            System.out.println("creates new time slot ");
            this.startTime = System.currentTimeMillis();
            this.limit = limit;
            this.period = period;
        }

        public boolean countPulse() {
            ++this.currentCount;
            return this.currentCount <= this.limit;
        }

        public boolean isActive() {
            return System.currentTimeMillis() - this.startTime <= this.period.toMillis();
        }

        public long millisecondsLeft() {
            if (this.isActive()) {
                return this.startTime + this.period.toMillis() - System.currentTimeMillis();
            }
            return 0L;
        }
    }
}

