/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.crypto.PrivateKey;
import com.icodici.db.Db;
import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.Ledger;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteOpenMode;

public class SqliteLedger
implements Ledger {
    private final Db db;
    private Object writeLock = new Object();
    private Map<HashId, WeakReference<StateRecord>> cachedRecords = new WeakHashMap<HashId, WeakReference<StateRecord>>();
    private boolean useCache = true;

    public SqliteLedger(String connectionString) throws SQLException {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.setJournalMode(SQLiteConfig.JournalMode.WAL);
        config.setOpenMode(SQLiteOpenMode.FULLMUTEX);
        Properties properties = config.toProperties();
        this.db = new Db(connectionString, properties);
        this.db.setupDatabase("/migrations/sqlite/migrate_");
    }

    @Override
    public StateRecord getRecord(HashId itemId) {
        StateRecord sr = this.protect(() -> {
            StateRecord cached = this.getFromCache(itemId);
            if (cached != null) {
                return cached;
            }
            try (ResultSet rs = this.db.queryRow("SELECT * FROM ledger WHERE hash = ? limit 1", new Object[]{itemId.getDigest()});){
                if (rs != null) {
                    StateRecord record = new StateRecord(this, rs);
                    this.putToCache(record);
                    StateRecord stateRecord = record;
                    return stateRecord;
                }
            }
            return null;
        });
        if (sr != null && sr.isExpired()) {
            sr.destroy();
            return null;
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateRecord getFromCache(HashId itemId) {
        if (this.useCache) {
            Map<HashId, WeakReference<StateRecord>> map = this.cachedRecords;
            synchronized (map) {
                WeakReference<StateRecord> ref = this.cachedRecords.get(itemId);
                if (ref == null) {
                    return null;
                }
                StateRecord r = (StateRecord)ref.get();
                if (r == null) {
                    this.cachedRecords.remove(itemId);
                    return null;
                }
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToCache(StateRecord r) {
        if (this.useCache) {
            Map<HashId, WeakReference<StateRecord>> map = this.cachedRecords;
            synchronized (map) {
                this.cachedRecords.put(r.getId(), new WeakReference<StateRecord>(r));
            }
        }
    }

    @Override
    public StateRecord createOutputLockRecord(long creatorRecordId, HashId newItemHashId) {
        StateRecord r = new StateRecord(this);
        r.setState(ItemState.LOCKED_FOR_CREATION);
        r.setLockedByRecordId(creatorRecordId);
        r.setId(newItemHashId);
        try {
            r.save();
            return r;
        }
        catch (Ledger.Failure e) {
            return null;
        }
    }

    @Override
    public StateRecord getLockOwnerOf(StateRecord rc) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public StateRecord findOrCreate(HashId itemId) {
        return this.protect(() -> {
            Object object = this.writeLock;
            synchronized (object) {
                StateRecord r = this.getRecord(itemId);
                if (r == null) {
                    r = new StateRecord(this);
                    r.setId(itemId);
                    r.setState(ItemState.PENDING);
                    r.save();
                }
                if (r == null) {
                    throw new RuntimeException("failure creating new stateReocrd");
                }
                return r;
            }
        });
    }

    private <T> T protect(Callable<T> block) {
        try {
            return block.call();
        }
        catch (Exception ex) {
            throw new Ledger.Failure("Ledger operation failed: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void close() {
        try {
            this.db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<ItemState, Integer> getLedgerSize(Instant createdAfter) {
        return null;
    }

    @Override
    public void saveConfig(NodeInfo myInfo, NetConfig netConfig, PrivateKey nodeKey) {
    }

    @Override
    public Object[] loadConfig() {
        return new Object[0];
    }

    @Override
    public void addNode(NodeInfo nodeInfo) {
    }

    @Override
    public void removeNode(NodeInfo nodeInfo) {
    }

    @Override
    public Map<HashId, StateRecord> findUnfinished() {
        return null;
    }

    @Override
    public Approvable getItem(StateRecord record) {
        return null;
    }

    @Override
    public void putItem(StateRecord record, Approvable item, Instant keepTill) {
    }

    @Override
    public <T> T transaction(Callable<T> callable) {
        return (T)this.protect(() -> this.db.transaction(() -> callable.call()));
    }

    @Override
    public void destroy(StateRecord record) {
        long recordId = record.getRecordId();
        if (recordId == 0L) {
            throw new IllegalStateException("can't destroy record without recordId");
        }
        this.protect(() -> {
            Map<HashId, WeakReference<StateRecord>> map = this.writeLock;
            synchronized (map) {
                this.db.update("DELETE FROM ledger WHERE id = ?", recordId);
            }
            map = this.cachedRecords;
            synchronized (map) {
                this.cachedRecords.remove(record.getId());
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(StateRecord stateRecord) {
        if (stateRecord.getLedger() == null) {
            stateRecord.setLedger(this);
        } else if (stateRecord.getLedger() != this) {
            throw new IllegalStateException("can't save with  adifferent ledger (make a copy!)");
        }
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (stateRecord.getRecordId() == 0L) {
                    try (PreparedStatement statement = this.db.statement("insert into ledger(hash,state,created_at, expires_at, locked_by_id) values(?,?,?,?,?);", new Object[0]);){
                        statement.setBytes(1, stateRecord.getId().getDigest());
                        statement.setInt(2, stateRecord.getState().ordinal());
                        statement.setLong(3, StateRecord.unixTime(stateRecord.getCreatedAt()));
                        statement.setLong(4, StateRecord.unixTime(stateRecord.getExpiresAt()));
                        statement.setLong(5, stateRecord.getLockedByRecordId());
                        statement.executeUpdate();
                        try (ResultSet keys = statement.getGeneratedKeys();){
                            if (!keys.next()) {
                                throw new RuntimeException("generated keys are not supported");
                            }
                            long id = keys.getLong(1);
                            stateRecord.setRecordId(id);
                        }
                    }
                    this.putToCache(stateRecord);
                } else {
                    this.db.update("update ledger set state=?, expires_at=?, locked_by_id=? where id=?", stateRecord.getState().ordinal(), StateRecord.unixTime(stateRecord.getExpiresAt()), stateRecord.getLockedByRecordId(), stateRecord.getRecordId());
                }
            }
        }
        catch (SQLException se) {
            throw new Ledger.Failure("StateRecord save failed:" + se);
        }
    }

    @Override
    public void reload(StateRecord stateRecord) throws StateRecord.NotFoundException {
        try (ResultSet rs = this.db.queryRow("SELECT * FROM ledger WHERE hash = ? limit 1", new Object[]{stateRecord.getId().getDigest()});){
            if (rs == null) {
                throw new StateRecord.NotFoundException("record not found");
            }
            stateRecord.initFrom(rs);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reload RecordSet", e);
        }
    }

    public void enableCache(boolean enable) {
        if (enable) {
            this.useCache = true;
        } else {
            this.useCache = false;
            this.cachedRecords.clear();
        }
    }

    public Db getDb() {
        return this.db;
    }

    @Override
    public void cleanup() {
    }
}

