/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node;

import com.icodici.universa.HashId;
import com.icodici.universa.HashIdentifiable;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.Ledger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.sergeych.tools.Do;
import net.sergeych.utils.LogPrinter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StateRecord
implements HashIdentifiable {
    private static LogPrinter log = new LogPrinter("StateRecord");
    private Ledger ledger;
    private boolean dirty;
    private long recordId;
    private long lockedByRecordId;
    private volatile ItemState state = ItemState.UNDEFINED;
    private HashId id;
    private @NonNull ZonedDateTime expiresAt = ZonedDateTime.now().plusSeconds(300L);
    private @NonNull ZonedDateTime createdAt = ZonedDateTime.now();

    public StateRecord(Ledger ledger, ResultSet rs) throws SQLException, IOException {
        this.ledger = ledger;
        this.initFrom(rs);
    }

    public void initFrom(ResultSet rs) throws SQLException {
        if (rs == null || rs.isClosed()) {
            throw new SQLException("resultset or connection is closed");
        }
        this.recordId = rs.getLong("id");
        try {
            this.id = HashId.withDigest(Do.read(rs.getBinaryStream("hash")));
        }
        catch (IOException e) {
            throw new SQLException("failed to read hash from the recordset");
        }
        this.state = ItemState.values()[rs.getInt("state")];
        this.createdAt = StateRecord.getTime(rs.getLong("created_at"));
        this.expiresAt = StateRecord.getTime(rs.getLong("expires_at"));
        if (this.expiresAt == null) {
            this.expiresAt = this.createdAt.plusMonths(3L);
        }
        this.lockedByRecordId = rs.getInt("locked_by_id");
    }

    public StateRecord(Ledger ledger) {
        this.ledger = ledger;
        this.createdAt = ZonedDateTime.now();
    }

    public static ZonedDateTime getTime(long unixTime) {
        if (unixTime == 0L) {
            return null;
        }
        return Instant.ofEpochSecond(unixTime).atZone(ZoneId.systemDefault());
    }

    public static long unixTime(ZonedDateTime time) {
        return time == null ? 0L : time.toEpochSecond();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public StateRecord(HashId id) {
        this.id = id;
    }

    public ItemState getState() {
        return this.state;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    public final StateRecord setState(ItemState newState) {
        if (this.state != newState) {
            this.state = newState;
            this.setDirty();
        }
        return this;
    }

    @Override
    public final HashId getId() {
        return this.id;
    }

    public ZonedDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void destroy() {
        this.checkLedgerExists();
        this.ledger.destroy(this);
    }

    public void save() {
        if (this.dirty && this.ledger != null) {
            this.dirty = false;
            this.ledger.save(this);
        }
    }

    public final boolean isPositive() {
        return this.state == ItemState.PENDING_POSITIVE;
    }

    public final boolean isApproved() {
        return this.state.isApproved();
    }

    public final boolean isPending() {
        return this.state.isPending();
    }

    public final boolean isNegative() {
        return this.state == ItemState.PENDING_NEGATIVE;
    }

    public final boolean isDeclined() {
        return this.state == ItemState.DECLINED;
    }

    public final boolean isArchived() {
        return this.state == ItemState.REVOKED;
    }

    public final boolean isLocked() {
        return this.state == ItemState.LOCKED;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }

    public void setRecordId(long recordId) {
        this.checkLedgerExists();
        if (this.recordId != 0L && this.recordId != recordId) {
            throw new IllegalStateException("can't change already assigned recordId");
        }
        this.recordId = recordId;
    }

    private void checkLedgerExists() {
        if (this.ledger == null) {
            throw new IllegalStateException("connect to ledger to set recordId");
        }
    }

    public long getLockedByRecordId() {
        return this.lockedByRecordId;
    }

    public void setLockedByRecordId(long lockedByRecordId) {
        if (lockedByRecordId != this.lockedByRecordId) {
            this.lockedByRecordId = lockedByRecordId;
            this.dirty = true;
        }
    }

    public void setId(HashId id) {
        if (this.id == null || !this.id.equals(id)) {
            if (this.id != null) {
                throw new IllegalStateException("can't change id of StateRecord");
            }
            this.id = id;
            this.dirty = true;
        }
    }

    public StateRecord lockToRevoke(HashId idToRevoke) {
        this.checkLedgerExists();
        if (this.state != ItemState.PENDING) {
            throw new IllegalStateException("only pending records are allowed to lock others");
        }
        StateRecord lockedRecord = this.ledger.getRecord(idToRevoke);
        if (lockedRecord == null) {
            return null;
        }
        switch (lockedRecord.getState()) {
            case LOCKED: {
                if (this.checkLockedRecord(lockedRecord)) break;
                return null;
            }
            case APPROVED: {
                break;
            }
            default: {
                return null;
            }
        }
        lockedRecord.setLockedByRecordId(this.recordId);
        lockedRecord.setState(ItemState.LOCKED);
        lockedRecord.save();
        return lockedRecord;
    }

    private boolean checkLockedRecord(StateRecord lockedRecord) {
        if (lockedRecord.getLockedByRecordId() == this.recordId) {
            return true;
        }
        StateRecord currentOwner = this.ledger.getLockOwnerOf(lockedRecord);
        if (currentOwner == null) {
            return true;
        }
        if (currentOwner.state.isPending()) {
            return false;
        }
        return currentOwner.state == ItemState.DECLINED || currentOwner.state == ItemState.DISCARDED;
    }

    public StateRecord unlock() {
        switch (this.state) {
            case LOCKED: {
                this.setState(ItemState.APPROVED);
                this.setLockedByRecordId(0L);
                break;
            }
            case LOCKED_FOR_CREATION: {
                this.destroy();
                break;
            }
        }
        return this;
    }

    public void revoke() {
        if (this.state != ItemState.LOCKED) {
            throw new IllegalStateException("can't archive record that is not in the locked state");
        }
        this.setState(ItemState.REVOKED);
        this.save();
    }

    public void approve() {
        this.checkLedgerExists();
        if (!this.state.isPending()) {
            throw new IllegalStateException("attempt to approve record that is not pending: " + (Object)((Object)this.state));
        }
        this.setState(ItemState.APPROVED);
        this.save();
    }

    public StateRecord createOutputLockRecord(HashId id) {
        this.checkLedgerExists();
        this.checkHaveRecordId();
        if (this.state != ItemState.PENDING) {
            throw new IllegalStateException("wrong state to createOutputLockRecord: " + (Object)((Object)this.state));
        }
        StateRecord newRecord = this.ledger.getRecord(id);
        if (newRecord != null) {
            if (newRecord.state != ItemState.LOCKED_FOR_CREATION) {
                return null;
            }
            return newRecord.lockedByRecordId == this.recordId ? newRecord : null;
        }
        newRecord = this.ledger.createOutputLockRecord(this.recordId, id);
        return newRecord;
    }

    private void checkHaveRecordId() {
        if (this.recordId == 0L) {
            throw new IllegalStateException("the record must be created");
        }
    }

    public StateRecord setExpiresAt(@NonNull ZonedDateTime expiresAt) {
        if (!this.expiresAt.equals(expiresAt)) {
            this.expiresAt = expiresAt;
            this.dirty = true;
        }
        return this;
    }

    public boolean isExpired() {
        return this.expiresAt.isBefore(ZonedDateTime.now());
    }

    public StateRecord setCreatedAt(@NonNull ZonedDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public StateRecord reload() throws NotFoundException {
        this.checkLedgerExists();
        if (this.recordId == 0L) {
            throw new IllegalStateException("can't reload record without recordId (new?)");
        }
        this.ledger.reload(this);
        return this;
    }

    public String toString() {
        return "State<" + this.getId() + "/" + this.getRecordId() + ":" + (Object)((Object)this.getState()) + ":" + this.getCreatedAt() + "/" + this.getExpiresAt() + ">";
    }

    public static class NotFoundException
    extends IOException {
        public NotFoundException() {
        }

        public NotFoundException(String message) {
            super(message);
        }
    }
}

