/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node.network.microhttpd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nanohttpd.protocols.http.tempfiles.ITempFile;

public class InMemoryTempFile
implements ITempFile,
AutoCloseable {
    private static final ConcurrentHashMap<String, InMemoryTempFile> files = new ConcurrentHashMap();
    private final ByteArrayOutputStream fstream = new ByteArrayOutputStream(1024);
    private final String fileName = UUID.randomUUID().toString() + ".tempfile";

    public InMemoryTempFile() {
        files.put(this.fileName, this);
    }

    public void delete() throws Exception {
        files.remove(this.fileName);
        this.fstream.reset();
        this.fstream.close();
    }

    public String getName() {
        return this.fileName;
    }

    public OutputStream open() throws Exception {
        return this.fstream;
    }

    @Override
    public void close() throws Exception {
        this.delete();
    }

    public ByteArrayOutputStream getOutputByteStream() {
        return this.fstream;
    }

    public ByteArrayInputStream getInputByteStream() {
        return new ByteArrayInputStream(this.fstream.toByteArray());
    }

    public static @Nullable InMemoryTempFile getFileByName(@NonNull String name) {
        assert (name != null);
        return files.get(name);
    }
}

