/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node.network.microhttpd;

import com.icodici.universa.node.network.microhttpd.InMemoryTempFile;
import java.util.ArrayList;
import java.util.List;
import net.sergeych.utils.LogPrinter;
import org.nanohttpd.protocols.http.tempfiles.ITempFile;
import org.nanohttpd.protocols.http.tempfiles.ITempFileManager;
import org.nanohttpd.util.IFactory;

class InMemoryTempFileManager
implements ITempFileManager {
    private static LogPrinter log = new LogPrinter("MHTP");
    private final List<ITempFile> tempFiles = new ArrayList<ITempFile>();

    public void clear() {
        for (ITempFile file : new ArrayList<ITempFile>(this.tempFiles)) {
            try {
                file.delete();
            }
            catch (Exception e) {
                log.wtf("Cannot remove file " + file.getName(), e);
            }
        }
        this.tempFiles.clear();
    }

    public ITempFile createTempFile(String filename_hint) throws Exception {
        InMemoryTempFile tempFile = new InMemoryTempFile();
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    static class InMemoryTempFileManagerFactory
    implements IFactory<ITempFileManager> {
        InMemoryTempFileManagerFactory() {
        }

        public ITempFileManager create() {
            return new InMemoryTempFileManager();
        }
    }
}

