/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node.network.microhttpd;

import com.icodici.universa.node.network.BasicHTTPService;
import com.icodici.universa.node.network.microhttpd.InMemoryTempFile;
import com.icodici.universa.node.network.microhttpd.MicroHTTPD;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.sergeych.tools.Binder;
import net.sergeych.utils.LogPrinter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nanohttpd.protocols.http.HTTPSession;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;

public class MicroHTTPDService
implements BasicHTTPService {
    private static LogPrinter log = new LogPrinter("MHTP");
    private static final long HARD_UPLOAD_LIMIT = 0x200000L;
    private @Nullable MicroHTTPD microHTTPD = null;
    private final List<PathHandlerEntry> pathHandlers = new CopyOnWriteArrayList<PathHandlerEntry>();
    private final Map<String, PathHandlerEntry> pathStarts = new LinkedHashMap<String, PathHandlerEntry>();
    private @Nullable BasicHTTPService.Handler notFoundHandler = null;
    private Object notFoundHandlerLock = new Object();
    private static final IStatus GOOD = Status.OK;
    private static final IStatus BAD = Status.BAD_REQUEST;

    @Override
    public void start(int port, int maxResponseThreads) throws IOException {
        assert (this.microHTTPD == null) : "Trying to start already started service";
        this.microHTTPD = new MicroHTTPD(port, maxResponseThreads);
        this.microHTTPD.addHTTPInterceptor(session -> {
            try {
                @Nullable BasicHTTPService.Handler requestHandler = this.findRequestHandler((IHTTPSession)session);
                @Nullable String errorMessage = null;
                MicroHTTPDServiceRequest requestToHandle = new MicroHTTPDServiceRequest((IHTTPSession)session);
                MicroHTTPDServiceResponse responsePlaceholder = new MicroHTTPDServiceResponse();
                if (requestHandler == null) {
                    errorMessage = "Unsupported URL: " + session.getUri();
                } else {
                    long bodySize = ((HTTPSession)session).getBodySize();
                    if (bodySize > 0x200000L) {
                        errorMessage = String.format("Body too large: %s, while maximum allowed is %s", bodySize, 0x200000L);
                    }
                    HashMap filesNamesMap = new HashMap();
                    try {
                        session.parseBody(filesNamesMap);
                    }
                    catch (IOException | NanoHTTPD.ResponseException e) {
                        log.wtf("Cannot parse body", e);
                        errorMessage = "Cannot parse body";
                    }
                    HashMap<String, InMemoryTempFile> filesMap = new HashMap<String, InMemoryTempFile>();
                    filesNamesMap.entrySet().forEach(filesMapEntry -> {
                        @Nullable InMemoryTempFile tempFile = InMemoryTempFile.getFileByName((String)filesMapEntry.getValue());
                        if (tempFile != null) {
                            filesMap.put((String)filesMapEntry.getKey(), tempFile);
                        }
                    });
                    requestToHandle.setFiles(filesMap);
                }
                if (errorMessage != null) {
                    responsePlaceholder.setError(errorMessage);
                }
                if (requestHandler != null) {
                    try {
                        requestHandler.handle(requestToHandle, responsePlaceholder);
                    }
                    catch (Throwable e) {
                        log.wtf("On handling request, got problem", e);
                    }
                } else {
                    @Nullable BasicHTTPService.Handler notFoundHandlerToUse = this.notFoundHandler;
                    if (notFoundHandlerToUse != null) {
                        try {
                            notFoundHandlerToUse.handle(requestToHandle, responsePlaceholder);
                        }
                        catch (Throwable e) {
                            log.wtf("On handling request with no specific handler, got problem", e);
                        }
                    } else {
                        responsePlaceholder.setResponseCode(404);
                    }
                }
                byte[] body2 = responsePlaceholder.body;
                Response response = Response.newFixedLengthResponse((IStatus)Status.lookup((int)responsePlaceholder.responseCode), (String)"application/octet-stream", (byte[])body2);
                for (Map.Entry entry : responsePlaceholder.getHeaders().entrySet()) {
                    try {
                        response.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                    catch (ClassCastException e) {
                        log.wtf("Failed to add header " + (String)entry.getKey(), e);
                    }
                }
                return response;
            }
            catch (Throwable e) {
                log.wtf("Problem in interceptor", e);
                return null;
            }
        });
        this.microHTTPD.start();
    }

    private @Nullable BasicHTTPService.Handler findRequestHandler(@NonNull IHTTPSession session) {
        assert (session != null);
        String uri = session.getUri();
        for (PathHandlerEntry entry : this.pathHandlers) {
            if (!uri.startsWith(entry.prefix)) continue;
            return entry.handler;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        assert (this.microHTTPD != null);
        this.microHTTPD.closeAllConnections();
        this.microHTTPD = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BasicHTTPService.Handler on(String pathStart, BasicHTTPService.Handler handler) {
        PathHandlerEntry oldHandlerEntry;
        assert (pathStart != null);
        assert (handler != null);
        PathHandlerEntry newHandlerEntry = new PathHandlerEntry(pathStart, handler);
        Map<String, PathHandlerEntry> map = this.pathStarts;
        synchronized (map) {
            oldHandlerEntry = this.pathStarts.get(pathStart);
            this.pathHandlers.remove(oldHandlerEntry);
            this.pathStarts.put(pathStart, newHandlerEntry);
            this.pathHandlers.add(newHandlerEntry);
        }
        return oldHandlerEntry == null ? null : oldHandlerEntry.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BasicHTTPService.Handler onNotFound(BasicHTTPService.Handler handler) {
        BasicHTTPService.Handler previousHandler;
        assert (handler != null);
        Object object = this.notFoundHandlerLock;
        synchronized (object) {
            previousHandler = this.notFoundHandler;
            this.notFoundHandler = handler;
        }
        return previousHandler;
    }

    static class MicroHTTPDServiceResponse
    implements BasicHTTPService.Response {
        @NonNull byte[] body = new byte[0];
        @Nullable String error = null;
        int responseCode = 200;
        private final Binder headers = new Binder();

        MicroHTTPDServiceResponse() {
        }

        @Override
        public Binder getHeaders() {
            return this.headers;
        }

        @Override
        public void setBody(String bodyAsString) {
            byte[] bytes;
            assert (bodyAsString != null);
            try {
                bytes = bodyAsString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.wtf("Cannot get bytes of string: " + bodyAsString, e);
                bytes = new byte[]{};
            }
            this.setBody(bytes);
        }

        @Override
        public void setBody(byte[] bodyAsBytes) {
            assert (bodyAsBytes != null);
            this.body = bodyAsBytes;
        }

        @Override
        public void setResponseCode(int code) {
            this.responseCode = code;
        }

        void setError(String error) {
            this.error = error;
        }

        public @Nullable String getError() {
            return this.error;
        }
    }

    static class MicroHTTPDServiceRequest
    implements BasicHTTPService.Request {
        private final @NonNull IHTTPSession session;
        private @NonNull Map<String, InMemoryTempFile> filesMap = new HashMap<String, InMemoryTempFile>();

        MicroHTTPDServiceRequest(@NonNull IHTTPSession session) {
            assert (session != null);
            this.session = session;
        }

        @Override
        public String getPath() {
            return this.session.getUri();
        }

        @Override
        public String getDomain() {
            return this.session.getRemoteHostName();
        }

        @Override
        public Binder getParams() {
            Binder result = new Binder();
            HashMap<String, InMemoryTempFile> filesMap = new HashMap<String, InMemoryTempFile>(this.filesMap);
            this.session.getParameters().forEach((key, values) -> {
                if (values.size() > 1) {
                    InMemoryTempFile tmpFile = (InMemoryTempFile)filesMap.remove(key);
                    if (tmpFile == null) {
                        result.put(key, values);
                    } else {
                        result.put(key, values.stream().map(v -> new MicroHTTPDServiceFileUpload((String)v, tmpFile)).collect(Collectors.toList()));
                    }
                } else if (values.size() == 1) {
                    @Nullable InMemoryTempFile tmpFile = (InMemoryTempFile)filesMap.remove(key);
                    if (tmpFile == null) {
                        result.put(key, values.get(0));
                    } else {
                        result.put(key, new MicroHTTPDServiceFileUpload((String)values.get(0), tmpFile));
                    }
                } else {
                    result.put(key, null);
                }
            });
            return result;
        }

        @Override
        public Binder getHeaders() {
            return new Binder(this.session.getHeaders());
        }

        @Override
        public String getMethod() {
            return this.session.getMethod().toString();
        }

        void setFiles(Map<String, InMemoryTempFile> filesMap) {
            assert (filesMap != null);
            this.filesMap = filesMap;
        }
    }

    static class MicroHTTPDServiceFileUpload
    implements BasicHTTPService.FileUpload {
        private final String fileName;
        private final @NonNull InMemoryTempFile tempFile;

        MicroHTTPDServiceFileUpload(@NonNull String fileName, @NonNull InMemoryTempFile tempFile) {
            assert (fileName != null);
            assert (tempFile != null);
            this.fileName = fileName;
            this.tempFile = tempFile;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte[] getBytes() {
            return this.tempFile.getOutputByteStream().toByteArray();
        }
    }

    static class PathHandlerEntry {
        final @NonNull String prefix;
        final @NonNull BasicHTTPService.Handler handler;

        PathHandlerEntry(@NonNull String prefix, @NonNull BasicHTTPService.Handler handler) {
            assert (prefix != null);
            assert (handler != null);
            this.prefix = prefix;
            this.handler = handler;
        }
    }
}

