/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node.network.microhttpd;

import com.icodici.universa.node.network.microhttpd.InMemoryTempFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.nanohttpd.protocols.http.ClientHandler;
import org.nanohttpd.protocols.http.HTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.tempfiles.ITempFileManager;

public class MicroHTTPSession
extends HTTPSession {
    private static int DEFAULT_REQUEST_BUFFER_LEN = 4096;

    public MicroHTTPSession(NanoHTTPD httpd, ITempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
        super(httpd, tempFileManager, inputStream, outputStream);
    }

    public MicroHTTPSession(NanoHTTPD httpd, ITempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
        super(httpd, tempFileManager, inputStream, outputStream, inetAddress);
    }

    protected Integer getMemoryStoreLimit() {
        return null;
    }

    protected int getRequestBufferLen() {
        return DEFAULT_REQUEST_BUFFER_LEN;
    }

    protected String saveTmpFile(ByteBuffer b, int offset, int len, String filename_hint) {
        String path = "";
        if (len > 0) {
            try {
                InMemoryTempFile tempFile = (InMemoryTempFile)this.tempFileManager.createTempFile(filename_hint);
                ByteBuffer src = b.duplicate();
                src.position(offset).limit(offset + len);
                tempFile.getOutputByteStream().write(src.array(), offset, len);
                path = tempFile.getName();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return path;
    }

    static class MicroClientHandler
    extends ClientHandler {
        public MicroClientHandler(NanoHTTPD httpd, InputStream inputStream, Socket acceptSocket) {
            super(httpd, inputStream, acceptSocket);
        }

        protected HTTPSession createHTTPSession(NanoHTTPD httpd, ITempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
            return new MicroHTTPSession(httpd, tempFileManager, inputStream, outputStream, inetAddress);
        }
    }
}

