/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node.network.microhttpd;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sergeych.utils.LogPrinter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nanohttpd.protocols.http.ClientHandler;
import org.nanohttpd.protocols.http.threading.IAsyncRunner;

public class PooledAsyncRunner
implements IAsyncRunner {
    private static LogPrinter log = new LogPrinter("MHTP");
    private final ExecutorService executor;
    private ConcurrentMap<ClientHandler, Future> executedFutures = new ConcurrentHashMap<ClientHandler, Future>();

    PooledAsyncRunner(@Nullable Integer threadLimit) {
        this.executor = threadLimit == null ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(threadLimit);
    }

    PooledAsyncRunner(@Nullable Integer threadLimit, String poolName) {
        this.executor = threadLimit == null ? Executors.newCachedThreadPool() : new ThreadPoolExecutor((int)threadLimit, (int)threadLimit, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new CustomThreadFactory());
    }

    public void closeAll() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.wtf("Cannot close PooledAsyncRunner", e);
        }
    }

    public void closed(ClientHandler clientHandler) {
        assert (clientHandler != null);
        Future future = (Future)this.executedFutures.remove(clientHandler);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void exec(ClientHandler clientHandler) {
        assert (clientHandler != null);
        Future<?> future = this.executor.submit((Runnable)clientHandler);
        this.executedFutures.put(clientHandler, future);
    }

    public static class CustomThreadFactory
    implements ThreadFactory {
        private static int factoriesCount = 0;
        private int factoryNumber = ++factoriesCount;
        private int threadNumber = 1;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("microhttpd-worker-" + this.factoryNumber + "-" + this.threadNumber);
            ++this.threadNumber;
            return thread;
        }
    }
}

