/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.PublicKey;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sergeych.utils.Bytes;

public class Config {
    private ConsensusConfigUpdater consensusConfigUpdater;
    Boolean _allowFreeRegistrations = null;
    private Duration maxItemCreationAge = Duration.ofDays(5L);
    private Duration revokedItemExpiration = this.maxItemCreationAge.plusDays(10L);
    private TemporalAmount maxDownloadOnApproveTime = Duration.ofMinutes(5L);
    private Duration declinedItemExpiration = Duration.ofDays(10L);
    private Duration maxCacheAge = Duration.ofMinutes(20L);
    private Duration maxDiskCacheAge = Duration.ofMinutes(40L);
    private Duration statsIntervalSmall = Duration.ofSeconds(30L);
    private Duration statsIntervalBig = Duration.ofSeconds(3600L);
    private Duration maxGetItemTime = Duration.ofSeconds(30L);
    private int getItemRetryCount = 10;
    private int negativeConsensus;
    private int positiveConsensus;
    private int resyncBreakConsensus;
    private Duration maxElectionsTime = Duration.ofMinutes(15L);
    private List<Integer> pollTimeMillis = Arrays.asList(1000, 1000, 1000, 2000, 4000, 8000, 16000, 32000, 60000);
    private List<Integer> consensusReceivedCheckTime = Arrays.asList(1000, 1000, 1000, 2000, 4000, 8000, 16000, 32000, 60000);
    private Duration maxConsensusReceivedCheckTime = Duration.ofMinutes(15L);
    private List<Integer> resyncTime = Arrays.asList(1000, 1000, 1000, 2000, 4000, 8000, 16000, 32000, 60000);
    private Duration checkItemTime = Duration.ofMillis(200L);
    private Duration maxResyncTime = Duration.ofMinutes(5L);
    private Bytes transactionUnitsIssuerKeyData = Bytes.fromHex("1E 08 1C 01 00 01 C4 00 01 C5 24 96 7D 75 B6 D3 01 AC 46 7F 64 85 56 43 B6 F7 02 B5 4A 8F FE C7 0D DE 85 4F 53 7A F4 D7 9D 85 BB AD A9 7F 1F 4C 8D CD 5C 99 09 D1 61 29 1E 67 35 80 E7 44 58 41 35 37 16 55 C2 E6 22 0D EF 0F 8B 9B A4 C6 3D 0C 56 7B EB 98 18 C8 0A 2C 26 C0 9B 23 17 3D 6B A9 BF 37 81 E5 21 0C B7 29 50 E6 69 75 DA 2C 05 42 46 A6 A8 E8 85 13 62 96 31 8C FF 50 68 56 F3 BF C4 2C F7 24 9A 9A 1A 9D 95 1A F0 E1 82 00 25 1F 14 60 0B 01 95 74 1B EA D0 FF CC 62 5B 78 64 18 79 8E 14 FD 24 7A 36 5A 09 91 8F 3B F5 C6 55 AC BE DA AD 15 D9 CC 3A 08 76 AB F8 3F 45 F4 5A 26 5D 80 38 6C 02 27 95 8D F3 38 B1 DD 1B C7 5D 51 3C E1 1D 05 8E 2A 6C E8 17 D7 88 5B AE D4 F6 B7 7D A8 84 74 E1 4F 65 B3 DC 06 2D 07 21 AA 51 BF 93 11 C7 7D 1E 09 B3 CE A6 C1 83 60 50 A5 B8 F5 F4 11 A6 98 A0 F9 2B 2B 8D");
    private List<PublicKey> keysWhiteList = new ArrayList<PublicKey>();
    private Bytes networkConfigIssuerKeyData = Bytes.fromHex("1E 08 1C 01 00 01 C4 00 01 83 D8 9D 79 7E 80 DD 69 3D 0A EC 27 66 B6 A4 5D DB E1 60 38 88 88 ED 07 03 E6 16 98 B0 2B 71 9B E1 85 A1 8C AF 0D 62 D6 60 3A 4B D2 FA 34 F0 2E 85 87 19 CE 6F 0C C6 DC 2B D5 11 12 C8 9A A6 F8 71 70 53 EE 3D B3 4C 97 1E 10 89 B1 77 2F 2B 6D D8 C7 B3 44 A4 8A E9 1A 42 AD F4 E0 82 74 11 A1 42 49 6C D1 87 35 94 10 66 19 80 AB 4A 13 27 B4 F0 BD C5 8F 43 25 9E 2C 6C CB 81 3C 85 10 CE 99 D6 2D 88 11 01 B6 5B F8 AB 99 15 70 08 AF B8 51 3B 4A CD 4D 9E A1 13 9C E9 EA 83 F0 95 02 E1 F6 10 72 E8 2B 2F 64 3F FB DC 27 F6 5A D2 83 BA 71 C3 D6 A2 AE 41 4F CA AA BB AA 54 C3 2F D9 F7 7A 64 AA 3A F7 67 AC 5A CA AA 20 08 90 CE D8 35 FA C0 2B 02 17 F4 0A BF 25 85 17 F9 DC 6E 6B 9D D8 A2 43 1E D1 0E CD 4F F4 FA 75 C1 62 BD 7B DD D4 2F 52 85 E0 FA 55 C7 B7 BB 4B 39 EB 08 74 C4 77");
    private Bytes networkAdminKeyData = Bytes.fromHex("1E 08 1C 01 00 01 C4 00 01 83 D8 9D 79 7E 80 DD 69 3D 0A EC 27 66 B6 A4 5D DB E1 60 38 88 88 ED 07 03 E6 16 98 B0 2B 71 9B E1 85 A1 8C AF 0D 62 D6 60 3A 4B D2 FA 34 F0 2E 85 87 19 CE 6F 0C C6 DC 2B D5 11 12 C8 9A A6 F8 71 70 53 EE 3D B3 4C 97 1E 10 89 B1 77 2F 2B 6D D8 C7 B3 44 A4 8A E9 1A 42 AD F4 E0 82 74 11 A1 42 49 6C D1 87 35 94 10 66 19 80 AB 4A 13 27 B4 F0 BD C5 8F 43 25 9E 2C 6C CB 81 3C 85 10 CE 99 D6 2D 88 11 01 B6 5B F8 AB 99 15 70 08 AF B8 51 3B 4A CD 4D 9E A1 13 9C E9 EA 83 F0 95 02 E1 F6 10 72 E8 2B 2F 64 3F FB DC 27 F6 5A D2 83 BA 71 C3 D6 A2 AE 41 4F CA AA BB AA 54 C3 2F D9 F7 7A 64 AA 3A F7 67 AC 5A CA AA 20 08 90 CE D8 35 FA C0 2B 02 17 F4 0A BF 25 85 17 F9 DC 6E 6B 9D D8 A2 43 1E D1 0E CD 4F F4 FA 75 C1 62 BD 7B DD D4 2F 52 85 E0 FA 55 C7 B7 BB 4B 39 EB 08 74 C4 77");
    public static String tuTemplatePath = "./src/test_contracts/TUTemplate.yml";
    public static String testTUTemplatePath = "./src/test_contracts/TestTUTemplate.yml";
    public static String tuKeyPath = "./src/test_contracts/keys/tu_key.private.unikey";
    public static int maxExpirationMonthsInTestMode = 12;
    public static int maxCostTUInTestMode = 3;
    public static int quantiser_quantaPerUTN = 200;
    private String tuIssuerName = "Universa Reserve System";
    private int knownSubContractsToResync = 1;

    public Config() {
        this.keysWhiteList.add(this.getTransactionUnitsIssuerKey());
        this.keysWhiteList.add(this.getNetworkAdminKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config copy() {
        Config config = new Config();
        config.consensusConfigUpdater = this.consensusConfigUpdater;
        config.maxItemCreationAge = this.maxItemCreationAge;
        config.revokedItemExpiration = this.revokedItemExpiration;
        config.maxDownloadOnApproveTime = this.maxDownloadOnApproveTime;
        config.declinedItemExpiration = this.declinedItemExpiration;
        config.maxCacheAge = this.maxCacheAge;
        config.maxGetItemTime = this.maxGetItemTime;
        Config config2 = this;
        synchronized (config2) {
            config.negativeConsensus = this.negativeConsensus;
            config.positiveConsensus = this.positiveConsensus;
            config.resyncBreakConsensus = this.resyncBreakConsensus;
        }
        config.maxElectionsTime = this.maxElectionsTime;
        config.pollTimeMillis = new ArrayList<Integer>(this.pollTimeMillis);
        config.consensusReceivedCheckTime = new ArrayList<Integer>(this.consensusReceivedCheckTime);
        config.maxConsensusReceivedCheckTime = this.maxConsensusReceivedCheckTime;
        config.resyncTime = new ArrayList<Integer>(this.resyncTime);
        config.checkItemTime = this.checkItemTime;
        config.maxResyncTime = this.maxResyncTime;
        config.transactionUnitsIssuerKeyData = this.transactionUnitsIssuerKeyData;
        config.networkConfigIssuerKeyData = this.networkConfigIssuerKeyData;
        config.keysWhiteList = this.keysWhiteList;
        return config;
    }

    public void setConsensusConfigUpdater(ConsensusConfigUpdater consensusConfigUpdater) {
        this.consensusConfigUpdater = consensusConfigUpdater;
    }

    public Duration getMaxDiskCacheAge() {
        return this.maxDiskCacheAge;
    }

    public Duration getStatsIntervalSmall() {
        return this.statsIntervalSmall;
    }

    public void setStatsIntervalSmall(Duration statsIntervalSmall) {
        this.statsIntervalSmall = statsIntervalSmall;
    }

    public Duration getStatsIntervalBig() {
        return this.statsIntervalBig;
    }

    public void setStatsIntervalBig(Duration statsIntervalBig) {
        this.statsIntervalBig = statsIntervalBig;
    }

    public boolean allowFreeRegistrations() {
        if (this._allowFreeRegistrations == null) {
            System.out.println("will check free registration");
            this._allowFreeRegistrations = "3.4.2-private-alpha".contains("private");
            System.out.println("allow = " + this._allowFreeRegistrations);
        }
        return this._allowFreeRegistrations;
    }

    public static <T> Class<T> forceInit(Class<T> klass) {
        try {
            Class.forName(klass.getName(), true, klass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return klass;
    }

    public Duration getDeclinedItemExpiration() {
        return this.declinedItemExpiration;
    }

    public void setDeclinedItemExpiration(Duration declinedItemExpiration) {
        this.declinedItemExpiration = declinedItemExpiration;
    }

    public void setTransactionUnitsIssuerKeyData(Bytes transactionUnitsIssuerKeyData) {
        this.transactionUnitsIssuerKeyData = transactionUnitsIssuerKeyData;
    }

    public List<PublicKey> getKeysWhiteList() {
        return this.keysWhiteList;
    }

    public int getPositiveConsensus() {
        return this.positiveConsensus;
    }

    public void setPositiveConsensus(int positiveConsensus) {
        this.positiveConsensus = positiveConsensus;
    }

    public int getResyncBreakConsensus() {
        return this.resyncBreakConsensus;
    }

    public void setResyncBreakConsensus(int resyncBreakConsensus) {
        this.resyncBreakConsensus = resyncBreakConsensus;
    }

    public Duration getMaxItemCreationAge() {
        return this.maxItemCreationAge;
    }

    public Duration getRevokedItemExpiration() {
        return this.revokedItemExpiration;
    }

    public Duration getMaxElectionsTime() {
        return this.maxElectionsTime;
    }

    public Duration getMaxConsensusReceivedCheckTime() {
        return this.maxConsensusReceivedCheckTime;
    }

    public Duration getMaxResyncTime() {
        return this.maxResyncTime;
    }

    public void setMaxResyncTime(Duration time) {
        this.maxResyncTime = time;
    }

    public void setMaxElectionsTime(Duration maxElectionsTime) {
        this.maxElectionsTime = maxElectionsTime;
    }

    public Duration getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public void setMaxCacheAge(Duration maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    public Duration getMaxGetItemTime() {
        return this.maxGetItemTime;
    }

    public int getGetItemRetryCount() {
        return this.getItemRetryCount;
    }

    public void setMaxGetItemTime(Duration maxGetItemTime) {
        this.maxGetItemTime = maxGetItemTime;
    }

    public int getNegativeConsensus() {
        return this.negativeConsensus;
    }

    public void setNegativeConsensus(int negativeConsensus) {
        this.negativeConsensus = negativeConsensus;
    }

    public List<Integer> getPollTime() {
        return this.pollTimeMillis;
    }

    public void setPollTime(List<Integer> pollTimeMillis) {
        this.pollTimeMillis = new ArrayList<Integer>(pollTimeMillis);
    }

    public List<Integer> getConsensusReceivedCheckTime() {
        return this.consensusReceivedCheckTime;
    }

    public void setConsensusReceivedCheckTime(List<Integer> consensusReceivedCheckTime) {
        this.consensusReceivedCheckTime = new ArrayList<Integer>(consensusReceivedCheckTime);
    }

    public List<Integer> getResyncTime() {
        return this.resyncTime;
    }

    public Duration getCheckItemTime() {
        return this.checkItemTime;
    }

    public void setResyncTime(List<Integer> resyncTime) {
        this.resyncTime = new ArrayList<Integer>(resyncTime);
    }

    public TemporalAmount getMaxDownloadOnApproveTime() {
        return this.maxDownloadOnApproveTime;
    }

    public void setMaxDownloadOnApproveTime(TemporalAmount maxDownloadOnApproveTime) {
        this.maxDownloadOnApproveTime = maxDownloadOnApproveTime;
    }

    public int getResyncThreshold() {
        int n = this.getNegativeConsensus() * 2;
        if (n > this.getPositiveConsensus()) {
            n = this.getNegativeConsensus();
        }
        return n;
    }

    public int getKnownSubContractsToResync() {
        return this.knownSubContractsToResync;
    }

    public PublicKey getTransactionUnitsIssuerKey() {
        try {
            return new PublicKey(this.transactionUnitsIssuerKeyData.getData());
        }
        catch (EncryptionError e) {
            return null;
        }
    }

    public PublicKey getNetworkConfigIssuerKey() {
        try {
            return new PublicKey(this.networkConfigIssuerKeyData.getData());
        }
        catch (EncryptionError e) {
            return null;
        }
    }

    public PublicKey getNetworkAdminKey() {
        try {
            return new PublicKey(this.networkAdminKeyData.getData());
        }
        catch (EncryptionError e) {
            return null;
        }
    }

    public String getTUIssuerName() {
        return this.tuIssuerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConsensusConfig(int nodesCount) {
        Config config = this;
        synchronized (config) {
            if (this.consensusConfigUpdater != null) {
                this.consensusConfigUpdater.updateConsensusConfig(this, nodesCount);
                return true;
            }
            return false;
        }
    }

    public static interface ConsensusConfigUpdater {
        public void updateConsensusConfig(Config var1, int var2);
    }
}

