/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import net.sergeych.utils.Base64;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ItemCache {
    private final Thread cleaner;
    private final Duration maxAge;
    private ConcurrentHashMap<HashId, Record> records = new ConcurrentHashMap();

    public ItemCache(Duration maxAge) {
        this.maxAge = maxAge;
        this.cleaner = new Thread(() -> {
            try {
                Thread.sleep(5000L);
                this.cleanUp();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.cleaner.setName("item-cache-cleaner");
        this.cleaner.setDaemon(true);
        this.cleaner.setPriority(1);
        this.cleaner.start();
    }

    final void cleanUp() {
        Instant now = Instant.now();
        this.records.values().forEach(r -> ((Record)r).checkExpiration(now));
    }

    public void shutdown() {
        this.cleaner.interrupt();
    }

    public @Nullable Approvable get(HashId itemId) {
        Record i = this.records.get(itemId);
        if (i != null && i.item == null) {
            throw new RuntimeException("cache: record with empty item");
        }
        return i != null ? i.item : null;
    }

    public void put(Approvable item) {
        new Record(item);
    }

    public void idsCheck(HashId itemId) {
        for (HashId x : this.records.keySet()) {
            System.out.println(" checking " + itemId + " eq " + x + ": " + itemId.equals(x) + " / " + x.equals(itemId));
            System.out.println(" codes: " + itemId.hashCode() + " / " + x.hashCode());
            System.out.println(" digest check: " + Base64.encodeString(itemId.getDigest()));
            System.out.println(" digest data : " + Base64.encodeString(x.getDigest()));
        }
    }

    public int size() {
        return this.records.size();
    }

    private class Record {
        private Instant expiresAt;
        private Approvable item;

        private Record(Approvable item) {
            this.expiresAt = Instant.now().plus(ItemCache.this.maxAge);
            this.item = item;
            ItemCache.this.records.put(item.getId(), this);
        }

        private void checkExpiration(Instant now) {
            if (this.expiresAt.isBefore(now)) {
                ItemCache.this.records.remove(this.item.getId());
            }
        }
    }
}

