/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.Approvable;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.HashId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ItemInformer {
    private ConcurrentHashMap<HashId, Record> records = new ConcurrentHashMap();

    public void inform(Approvable item) {
        this.getRecord((HashId)item.getId()).errorRecords.addAll(item.getErrors());
    }

    final void cleanUp() {
        Instant now = Instant.now();
        this.records.values().forEach(r -> ((Record)r).checkExpiration(now));
    }

    public void inform(HashId itemId, ErrorRecord error) {
        this.getRecord(itemId).addError(error);
    }

    public synchronized Record getRecord(HashId itemId) {
        Record r = this.records.get(itemId);
        if (r == null) {
            r = new Record(itemId);
            this.records.put(itemId, r);
        }
        return r;
    }

    public Record takeFor(HashId id) {
        return this.records.remove(id);
    }

    public class Record {
        private final HashId hashId;
        private Instant expiresAt;
        public final List<ErrorRecord> errorRecords = new ArrayList<ErrorRecord>();
        public final List<String> messages = new ArrayList<String>();

        private void checkExpiration(Instant now) {
            if (this.expiresAt.isBefore(now)) {
                ItemInformer.this.records.remove(this);
            }
        }

        private Record(HashId id) {
            this.hashId = id;
            this.resetExpiration();
        }

        private final void resetExpiration() {
            this.expiresAt = Instant.now().plusSeconds(300L);
        }

        private synchronized void addError(ErrorRecord er) {
            this.resetExpiration();
            this.errorRecords.add(er);
        }

        private synchronized void addMessage(ErrorRecord er) {
            this.resetExpiration();
            this.errorRecords.add(er);
        }
    }
}

