/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.Notification;
import java.io.IOException;
import net.sergeych.boss.Boss;

public class ItemNotification
extends Notification {
    private static final int CODE_ITEM_NOTIFICATION = 0;
    private HashId itemId;
    private ItemResult itemResult;
    private boolean requestResult;

    public HashId getItemId() {
        return this.itemId;
    }

    public ItemResult getItemResult() {
        return this.itemResult;
    }

    public boolean answerIsRequested() {
        return this.requestResult;
    }

    public ItemNotification(NodeInfo from, HashId itemId, ItemResult itemResult, boolean requestResult) {
        super(from);
        this.itemId = itemId;
        this.itemResult = itemResult;
        this.requestResult = requestResult;
    }

    @Override
    protected void writeTo(Boss.Writer bw) throws IOException {
        bw.writeObject(this.itemId.getDigest());
        this.itemResult.writeTo(bw);
        bw.writeObject(this.requestResult);
    }

    @Override
    protected void readFrom(Boss.Reader br) throws IOException {
        this.itemId = HashId.withDigest(br.readBinary());
        this.itemResult = new ItemResult(br);
        this.requestResult = (Boolean)br.read();
    }

    protected ItemNotification(NodeInfo from) throws IOException {
        super(from);
    }

    protected ItemNotification() {
    }

    @Override
    protected int getTypeCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemNotification that = (ItemNotification)o;
        NodeInfo from = this.getFrom();
        if (this.requestResult != that.requestResult) {
            return false;
        }
        if (!from.equals(that.getFrom())) {
            return false;
        }
        if (!this.itemId.equals(that.itemId)) {
            return false;
        }
        return this.itemResult.equals(that.itemResult);
    }

    public int hashCode() {
        NodeInfo from = this.getFrom();
        int result = from.hashCode();
        result = 31 * result + this.itemId.hashCode();
        result = 31 * result + this.itemResult.hashCode();
        result = 31 * result + (this.requestResult ? 1 : 0);
        return result;
    }

    public String toString() {
        return "[ItemNotification from " + this.getFrom() + " for item: " + this.getItemId() + ", item result: " + this.itemResult + ", is answer requested: " + this.answerIsRequested() + "]";
    }

    public static void init() {
        ItemNotification.registerClass(0, ItemNotification.class);
    }
}

