/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.ItemNotification;
import com.icodici.universa.node2.NodeInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.boss.Boss;

public class ItemResyncNotification
extends ItemNotification {
    private static final int CODE_ITEM_RESYNC_NOTIFICATION = 1;
    private HashMap<HashId, ItemState> itemsToResync;

    public ItemResyncNotification(NodeInfo from, HashId itemId, HashMap<HashId, ItemState> itemsToResync, boolean requestResult) {
        super(from, itemId, new ItemResult(new StateRecord(itemId)), requestResult);
        this.itemsToResync = itemsToResync;
    }

    protected ItemResyncNotification() {
        this.itemsToResync = new HashMap();
    }

    @Override
    protected void writeTo(Boss.Writer bw) throws IOException {
        super.writeTo(bw);
        HashMap<String, Integer> packingMap = new HashMap<String, Integer>();
        for (HashId hid : this.itemsToResync.keySet()) {
            packingMap.put(hid.toBase64String(), this.itemsToResync.get(hid).ordinal());
        }
        bw.writeObject(packingMap);
    }

    @Override
    protected void readFrom(Boss.Reader br) throws IOException {
        super.readFrom(br);
        Map<String, Object> packingMap = br.readMap();
        for (String s : packingMap.keySet()) {
            HashId hid = HashId.withDigest(s);
            ItemState state = ItemState.values()[(Integer)packingMap.get(s)];
            this.itemsToResync.put(hid, state);
        }
    }

    @Override
    protected int getTypeCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[ItemResyncNotification from: " + this.getFrom() + " for item: " + this.getItemId() + ", items to resync: " + this.itemsToResync + ", is answer requested: " + this.answerIsRequested() + "]";
    }

    public HashMap<HashId, ItemState> getItemsToResync() {
        return this.itemsToResync;
    }

    public static void init() {
        ItemResyncNotification.registerClass(1, ItemResyncNotification.class);
    }
}

