/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.node.PostgresLedger;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.ItemCache;
import com.icodici.universa.node2.ItemNotification;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.Node;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.ParcelCache;
import com.icodici.universa.node2.network.ClientHTTPServer;
import com.icodici.universa.node2.network.NetworkV2;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.sergeych.tools.AsyncEvent;
import net.sergeych.tools.Binder;
import net.sergeych.tools.BufferedLogger;
import net.sergeych.tools.Do;
import net.sergeych.tools.Reporter;
import org.yaml.snakeyaml.Yaml;

public class Main {
    public static final String NODE_VERSION = "3.4.2-private-alpha";
    private PostgresLedger ledger;
    private OptionParser parser;
    private OptionSet options;
    public final Reporter reporter = new Reporter();
    private String NAME_STRING = "Universa node server v3.4.2-private-alpha\n";
    private AsyncEvent eventReady = new AsyncEvent();
    public final BufferedLogger logger = new BufferedLogger(4096);
    private String configRoot;
    public NetConfig netConfig;
    public NetworkV2 network;
    public final Config config = new Config();
    private PrivateKey nodeKey;
    public NodeInfo myInfo;
    private ClientHTTPServer clientHTTPServer;
    public Node node;
    public ItemCache cache = new ItemCache(Duration.ofMinutes(30L));
    public ParcelCache parcelCache = new ParcelCache(Duration.ofMinutes(30L));

    public static void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        Config.forceInit(Contract.class);
        Config.forceInit(ItemNotification.class);
        this.parser = new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("?", "h", "help"), "show help").forHelp();
                this.acceptsAll(Arrays.asList("config-to-db"), "converts file config to db").forHelp();
                this.acceptsAll(Arrays.asList("c", "config"), "configuration file for the network").withRequiredArg().ofType(String.class).describedAs("config_file");
                this.acceptsAll(Arrays.asList("d", "database"), "database connection url").withRequiredArg().ofType(String.class).describedAs("db_url");
                this.accepts("test", "intended to be used in integration tests");
                this.accepts("nolog", "do not buffer log messages (good fot testing)");
                this.accepts("verbose", "sets verbose level to nothing, base or detail").withRequiredArg().ofType(String.class).describedAs("level");
                this.accepts("restart-socket", "restarts UDPAdapter: shutdown it and create new");
                this.accepts("shutdown", "delicate shutdown with rollback current processing contracts");
            }
        };
        try {
            this.options = this.parser.parse(args);
            if (this.options.has("nolog")) {
                this.logger.interceptStdOut();
            } else {
                this.logger.printTo(System.out, false);
            }
            if (this.options.has("?")) {
                this.usage(null);
            }
            this.log(this.NAME_STRING);
            if (this.options.has("config")) {
                this.loadNodeConfig();
                this.loadNetConfig();
                this.ledger.saveConfig(this.myInfo, this.netConfig, this.nodeKey);
            } else if (this.options.has("database")) {
                this.ledger = new PostgresLedger((String)this.options.valueOf("database"));
                this.log("ledger constructed");
                Object[] result = this.ledger.loadConfig();
                this.myInfo = (NodeInfo)result[0];
                this.netConfig = (NetConfig)result[1];
                this.nodeKey = (PrivateKey)result[2];
                this.log("key loaded: " + this.nodeKey.info());
                this.log("node local URL: " + this.myInfo.publicUrlString());
                this.log("node info: " + this.myInfo.toBinder());
            } else if (this.options.has("verbose")) {
                String lvl = (String)this.options.valueOf("verbose");
                int lvlId = 0;
                if ("nothing".equals(lvl)) {
                    lvlId = 0;
                } else if ("base".equals(lvl)) {
                    lvlId = 1;
                } else if ("detail".equals(lvl)) {
                    lvlId = 2;
                }
                this.setVerboseLevel(lvlId);
            } else if (this.options.has("udp-verbose")) {
                String lvl = (String)this.options.valueOf("udp-verbose");
                int lvlId = 0;
                if ("nothing".equals(lvl)) {
                    lvlId = 0;
                } else if ("base".equals(lvl)) {
                    lvlId = 1;
                } else if ("detail".equals(lvl)) {
                    lvlId = 2;
                }
                this.setUDPVerboseLevel(lvlId);
            } else if (this.options.has("restart-socket")) {
                this.restartUDPAdapter();
            } else if (this.options.has("shutdown")) {
                this.shutdown();
            } else {
                System.err.println("Neither config no database option passed, leaving");
                return;
            }
            this.log("--------------- step 3 --------------------");
            this.log("Starting the client HTTP server...");
            this.startClientHttpServer();
            this.log("--------------- step 4 --------------------");
            this.log("Starting the Universa node service...");
            this.startNode();
            this.log("all initialization is done -----------------------------------");
            this.startAndWaitEnd();
        }
        catch (OptionException e) {
            this.usage("Unrecognized parameter: " + e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.log("interrupted exception, leaving");
            System.err.println("interrupted exception, leaving");
        }
        catch (Exception e) {
            this.log("exception " + e);
            this.logger.e("exception " + e);
            e.printStackTrace();
            this.usage(e.getMessage());
        }
    }

    private void loadNetConfig() throws IOException {
        this.netConfig = new NetConfig(this.configRoot + "/config/nodes");
        this.log("Network configuration is loaded from " + this.configRoot + ", " + this.netConfig.size() + " nodes.");
    }

    private void startNode() throws SQLException, IOException {
        this.config.setConsensusConfigUpdater((config, n) -> {
            int resyncBreak;
            int positive;
            int negative = (int)Math.ceil((double)n * 0.11);
            if (negative < 1) {
                negative = 1;
            }
            if (negative + (positive = (int)Math.floor((double)n * 0.9)) == n) {
                ++negative;
            }
            if ((resyncBreak = (int)Math.ceil((double)n * 0.2)) < 1) {
                resyncBreak = 1;
            }
            if (resyncBreak + positive == n) {
                ++resyncBreak;
            }
            this.log(this.myInfo.getNumber() + ": Network consensus is set to (negative/positive/resyncBreak): " + negative + " / " + positive + " / " + resyncBreak);
            config.setPositiveConsensus(positive);
            config.setNegativeConsensus(negative);
            config.setResyncBreakConsensus(resyncBreak);
        });
        this.network = new NetworkV2(this.netConfig, this.myInfo, this.nodeKey);
        this.node = new Node(this.config, this.myInfo, this.ledger, this.network);
        this.cache = this.node.getCache();
        this.parcelCache = this.node.getParcelCache();
        StateRecord r = this.ledger.getRecord(HashId.withDigest("bS/c4YMidaVuzTBhHLkGPFAvPbZQHybzQnXAoBwaZYM8eLYb7mAkVYEpuqKRXYc7anqX47BeNdvFN1n7KluH9A=="));
        if (r != null) {
            r.destroy();
        }
        this.clientHTTPServer.setConfig(this.config);
        this.clientHTTPServer.setNode(this.node);
        this.clientHTTPServer.setCache(this.cache);
        this.clientHTTPServer.setParcelCache(this.parcelCache);
        this.clientHTTPServer.setLocalCors(this.myInfo.getPublicHost().equals("localhost"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndWaitEnd() throws InterruptedException {
        this.eventReady.fire(null);
        if (!this.options.has("test")) {
            OptionParser optionParser = this.parser;
            synchronized (optionParser) {
                this.parser.wait();
            }
        }
    }

    public void waitReady() throws InterruptedException {
        this.eventReady.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.log("shutting down");
            this.network.shutdown();
            this.clientHTTPServer.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        OptionParser optionParser = this.parser;
        synchronized (optionParser) {
            this.parser.notifyAll();
        }
        try {
            this.logger.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVerboseLevel(int level) {
        this.network.setVerboseLevel(level);
        this.node.setVerboseLevel(level);
    }

    public void setUDPVerboseLevel(int level) {
        this.network.setUDPVerboseLevel(level);
    }

    public void restartUDPAdapter() {
        try {
            this.network.restartUDPAdapter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PublicKey getNodePublicKey() {
        return this.nodeKey.getPublicKey();
    }

    private void loadNodeConfig() throws IOException, SQLException {
        Yaml yaml = new Yaml();
        this.configRoot = (String)this.options.valueOf("config");
        this.nodeKey = null;
        Binder settings = Binder.of(yaml.load(new FileInputStream(this.configRoot + "/config/config.yaml")));
        this.log("node settings: " + settings);
        String nodeKeyFileName = this.configRoot + "/tmp/" + settings.getStringOrThrow("node_name") + ".private.unikey";
        this.log(nodeKeyFileName);
        this.nodeKey = new PrivateKey(Do.read(nodeKeyFileName));
        this.myInfo = new NodeInfo(this.nodeKey.getPublicKey(), settings.getIntOrThrow("node_number"), settings.getStringOrThrow("node_name"), (String)settings.getListOrThrow("ip").get(0), settings.getStringOrThrow("public_host"), settings.getIntOrThrow("udp_server_port"), settings.getIntOrThrow("http_client_port"), settings.getIntOrThrow("http_server_port"));
        this.ledger = new PostgresLedger(settings.getStringOrThrow("database"));
        this.log("ledger constructed");
        this.log("key loaded: " + this.nodeKey.info());
        this.log("node local URL: " + this.myInfo.publicUrlString());
        this.log("node info: " + this.myInfo.toBinder());
    }

    private void startClientHttpServer() throws Exception {
        this.log("prepare to start client HTTP server on " + this.myInfo.getClientAddress().getPort());
        this.clientHTTPServer = new ClientHTTPServer(this.nodeKey, this.myInfo.getClientAddress().getPort(), this.logger);
        this.clientHTTPServer.setCache(this.cache);
        this.clientHTTPServer.setParcelCache(this.parcelCache);
        this.clientHTTPServer.setNetConfig(this.netConfig);
    }

    private void log(String msg) {
        this.logger.log(msg);
    }

    private void usage(String text) {
        this.log("usafe called");
        boolean error = false;
        PrintStream out = System.out;
        if (text != null) {
            out = System.err;
            error = true;
        }
        out.println("\n" + this.NAME_STRING);
        if (text != null) {
            out.println("ERROR: " + text + "\n");
        }
        try {
            this.parser.printHelpOn(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.options != null && !this.options.has("test")) {
            System.exit(100);
        }
    }
}

