/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.node2.NodeInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class NetConfig {
    private final Map<Integer, NodeInfo> byNumber = new HashMap<Integer, NodeInfo>();
    private final Map<String, NodeInfo> byName = new HashMap<String, NodeInfo>();

    public NetConfig() {
    }

    public NetConfig(Collection<NodeInfo> nodes) {
        nodes.forEach(n -> this.addNode((NodeInfo)n));
    }

    public NetConfig(String v2Path) throws IOException {
        Files.newDirectoryStream(Paths.get(v2Path, new String[0]), path -> path.toString().endsWith(".yaml")).forEach(fileName -> this.addNode(NodeInfo.loadYaml(fileName)));
    }

    public void addNode(NodeInfo n) {
        if (n != null) {
            this.byNumber.put(n.getNumber(), n);
            this.byName.put(n.getName(), n);
        }
    }

    public NodeInfo getInfo(String nodeName) {
        return this.byName.get(nodeName);
    }

    public NodeInfo getInfo(int nodeId) {
        return this.byNumber.get(nodeId);
    }

    public void forEachNode(Consumer<NodeInfo> consumer) {
        this.byNumber.forEach((i, n) -> consumer.accept((NodeInfo)n));
    }

    public int size() {
        return this.byNumber.size();
    }

    public List<NodeInfo> toList() {
        return new ArrayList<NodeInfo>(this.byName.values());
    }

    public void removeNode(NodeInfo nodeInfo) {
        this.byNumber.remove(nodeInfo.getNumber());
        this.byName.remove(nodeInfo.getName());
    }
}

