/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.crypto.PublicKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.contract.permissions.ChangeOwnerPermission;
import com.icodici.universa.contract.permissions.ModifyDataPermission;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.ListRole;
import com.icodici.universa.contract.roles.RoleLink;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.Ledger;
import com.icodici.universa.node.StateRecord;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.ItemCache;
import com.icodici.universa.node2.ItemInformer;
import com.icodici.universa.node2.ItemLock;
import com.icodici.universa.node2.ItemNotification;
import com.icodici.universa.node2.ItemResyncNotification;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.Notification;
import com.icodici.universa.node2.ParcelCache;
import com.icodici.universa.node2.ParcelLock;
import com.icodici.universa.node2.ParcelNotification;
import com.icodici.universa.node2.Quantiser;
import com.icodici.universa.node2.network.Network;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.AsyncEvent;
import net.sergeych.tools.Average;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.tools.RunnableWithDynamicPeriod;
import net.sergeych.utils.LogPrinter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Node {
    private static final int MAX_SANITATING_RECORDS = 64;
    private Instant nodeStartTime;
    private Map<ItemState, Integer> ledgerSize;
    private Instant lastStatsBuildTime;
    private LinkedList<Map<ItemState, Integer>> ledgerStatsHistory = new LinkedList();
    private LinkedList<Instant> ledgerHistoryTimestamps = new LinkedList();
    private Integer smallIntervalApproved;
    private Integer bigIntervalApproved;
    private Integer uptimeApproved;
    private ScheduledFuture<?> sanitator;
    private Map<HashId, StateRecord> recordsToSanitate;
    private static LogPrinter log = new LogPrinter("NODE");
    private final Config config;
    private final NodeInfo myInfo;
    private final Ledger ledger;
    private final Object ledgerRollbackLock = new Object();
    private final Network network;
    private final ItemCache cache;
    private final ParcelCache parcelCache;
    private final ItemInformer informer = new ItemInformer();
    protected int verboseLevel = 0;
    protected String label = null;
    protected boolean isShuttingDown = false;
    protected AsyncEvent sanitationFinished = new AsyncEvent();
    private final ItemLock itemLock = new ItemLock();
    private final ParcelLock parcelLock = new ParcelLock();
    private ConcurrentHashMap<HashId, ItemProcessor> processors = new ConcurrentHashMap();
    private ConcurrentHashMap<HashId, ParcelProcessor> parcelProcessors = new ConcurrentHashMap();
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(128, new ThreadFactory(){
        private final ThreadGroup threadGroup = new ThreadGroup("node-workers");

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.threadGroup, r);
            thread.setName("node-" + Node.this.myInfo.getNumber() + "-worker");
            return thread;
        }
    });
    private ScheduledExecutorService lowPrioExecutorService = new ScheduledThreadPoolExecutor(16, new ThreadFactory(){
        private final ThreadGroup threadGroup = new ThreadGroup("low-prio-node-workers");

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.threadGroup, r);
            thread.setName("low-prio-node-" + Node.this.myInfo.getNumber() + "-worker");
            thread.setPriority(3);
            return thread;
        }
    });
    ArrayList<HashId> sanitatingIds = new ArrayList();
    private SimpleDateFormat dataFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public boolean isSanitating() {
        return !this.recordsToSanitate.isEmpty();
    }

    public Map<HashId, StateRecord> getRecordsToSanitate() {
        return this.recordsToSanitate;
    }

    public Node(Config config, NodeInfo myInfo, Ledger ledger, Network network) {
        this.config = config;
        this.myInfo = myInfo;
        this.ledger = ledger;
        this.network = network;
        this.cache = new ItemCache(config.getMaxCacheAge());
        this.parcelCache = new ParcelCache(config.getMaxCacheAge());
        config.updateConsensusConfig(network.getNodesCount());
        this.label = "Node(" + myInfo.getNumber() + ") ";
        network.subscribe(myInfo, notification -> this.onNotification((Notification)notification));
        this.recordsToSanitate = ledger.findUnfinished();
        System.out.println(this.label + " " + this.recordsToSanitate.size());
        if (!this.recordsToSanitate.isEmpty()) {
            this.pulseStartSanitation();
        } else {
            this.dbSanitationFinished();
        }
        this.pulseStartCleanup();
    }

    private void pulseStartCleanup() {
        this.lowPrioExecutorService.scheduleAtFixedRate(() -> this.ledger.cleanup(), 1L, this.config.getMaxDiskCacheAge().getSeconds(), TimeUnit.SECONDS);
    }

    private void dbSanitationFinished() {
        this.sanitationFinished.fire();
        this.lastStatsBuildTime = this.nodeStartTime = Instant.now();
        this.ledgerSize = this.ledger.getLedgerSize(null);
        this.executorService.scheduleAtFixedRate(() -> this.collectStats(), this.config.getStatsIntervalSmall().getSeconds(), this.config.getStatsIntervalSmall().getSeconds(), TimeUnit.SECONDS);
        this.bigIntervalApproved = 0;
        this.smallIntervalApproved = 0;
        this.uptimeApproved = 0;
    }

    private void collectStats() {
        Instant now = Instant.now();
        Map<ItemState, Integer> lastIntervalStats = this.ledger.getLedgerSize(this.lastStatsBuildTime);
        this.ledgerStatsHistory.addLast(lastIntervalStats);
        this.ledgerHistoryTimestamps.addLast(this.lastStatsBuildTime);
        this.smallIntervalApproved = lastIntervalStats.getOrDefault((Object)ItemState.APPROVED, 0) + lastIntervalStats.getOrDefault((Object)ItemState.REVOKED, 0);
        this.bigIntervalApproved = this.bigIntervalApproved + this.smallIntervalApproved;
        this.uptimeApproved = this.uptimeApproved + this.smallIntervalApproved;
        lastIntervalStats.keySet().forEach(is -> this.ledgerSize.put((ItemState)((Object)is), this.ledgerSize.getOrDefault(is, 0) + (Integer)lastIntervalStats.get(is)));
        while (this.ledgerHistoryTimestamps.getFirst().plus(this.config.getStatsIntervalBig()).isBefore(now)) {
            this.ledgerHistoryTimestamps.removeFirst();
            this.bigIntervalApproved = this.bigIntervalApproved - this.ledgerStatsHistory.removeFirst().get((Object)ItemState.APPROVED);
        }
        this.lastStatsBuildTime = now;
    }

    private void pulseStartSanitation() {
        this.sanitator = this.lowPrioExecutorService.scheduleAtFixedRate(() -> this.startSanitation(), 2000L, 500L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSanitation() {
        if (this.recordsToSanitate.isEmpty()) {
            this.sanitator.cancel(false);
            this.dbSanitationFinished();
            return;
        }
        for (int i = 0; i < this.sanitatingIds.size(); ++i) {
            if (this.recordsToSanitate.containsKey(this.sanitatingIds.get(i))) continue;
            this.sanitatingIds.remove(i);
            --i;
        }
        if (this.sanitatingIds.size() < 64) {
            Map<HashId, StateRecord> map = this.recordsToSanitate;
            synchronized (map) {
                for (StateRecord r : this.recordsToSanitate.values()) {
                    if (r.getState() == ItemState.LOCKED || r.getState() == ItemState.LOCKED_FOR_CREATION || this.sanitatingIds.contains(r.getId())) continue;
                    this.sanitateRecord(r);
                    this.sanitatingIds.add(r.getId());
                    if (this.sanitatingIds.size() != 64) continue;
                    break;
                }
            }
            if (this.sanitatingIds.size() == 0 && this.recordsToSanitate.size() > 0) {
                map = this.recordsToSanitate;
                synchronized (map) {
                    for (StateRecord r : this.recordsToSanitate.values()) {
                        r.setState(ItemState.PENDING);
                        try {
                            this.itemLock.synchronize(r.getId(), lock -> {
                                r.save();
                                return null;
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private void sanitateRecord(StateRecord r) {
        try {
            if (this.isShuttingDown) {
                return;
            }
            this.resync(r.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public @NonNull ItemResult registerItem(Approvable item) {
        this.report(this.getLabel(), () -> this.concatReportMessage("register item: ", item.getId()), 1);
        if (item.isInWhiteList(this.config.getKeysWhiteList()) || this.config.allowFreeRegistrations()) {
            Object x = this.checkItemInternal(item.getId(), null, item, true, true);
            ItemResult ir = x instanceof ItemResult ? (ItemResult)x : ((ItemProcessor)x).getResult();
            this.report(this.getLabel(), () -> this.concatReportMessage(new Object[]{"item processor for: ", item.getId(), " was created, state is ", ir.state}), 1);
            return ir;
        }
        this.report(this.getLabel(), () -> this.concatReportMessage("item: ", item.getId(), " not belongs to whitelist"), 1);
        return ItemResult.UNDEFINED;
    }

    public boolean registerParcel(Parcel parcel) {
        this.report(this.getLabel(), () -> this.concatReportMessage("register parcel: ", parcel.getId()), 1);
        try {
            Object x = this.checkParcelInternal(parcel.getId(), parcel, true);
            if (x instanceof ParcelProcessor) {
                this.report(this.getLabel(), () -> this.concatReportMessage(new Object[]{"parcel processor created for parcel: ", parcel.getId(), ", state is ", ((ParcelProcessor)x).processingState}), 1);
                return true;
            }
            this.report(this.getLabel(), () -> this.concatReportMessage("parcel processor hasn't created: ", parcel.getId()), 1);
            return false;
        }
        catch (Exception e) {
            this.report(this.getLabel(), () -> this.concatReportMessage("register parcel: ", parcel.getId(), "failed", e.getMessage()), 1);
            throw new RuntimeException("failed to process parcel", e);
        }
    }

    public @NonNull ItemResult checkItem(HashId itemId) {
        this.report(this.getLabel(), () -> this.concatReportMessage("check item processor state for item: ", itemId), 1);
        Object x = this.checkItemInternal(itemId);
        ItemResult ir = x instanceof ItemResult ? (ItemResult)x : ((ItemProcessor)x).getResult();
        this.report(this.getLabel(), () -> this.concatReportMessage(new Object[]{"item state for: ", itemId, "is ", ir.state}), 1);
        ItemInformer.Record record = this.informer.takeFor(itemId);
        if (record != null) {
            ir.errors = record.errorRecords;
        }
        return ir;
    }

    public @NonNull ParcelProcessingState checkParcelProcessingState(HashId parcelId) {
        this.report(this.getLabel(), () -> this.concatReportMessage("check parcel processor state for parcel: ", parcelId), 1);
        Object x = this.checkParcelInternal(parcelId);
        if (x instanceof ParcelProcessor) {
            this.report(this.getLabel(), () -> this.concatReportMessage(new Object[]{"parcel processor for parcel: ", parcelId, " state is ", ((ParcelProcessor)x).processingState}), 1);
            return ((ParcelProcessor)x).processingState;
        }
        this.report(this.getLabel(), () -> this.concatReportMessage("parcel processor for parcel: ", parcelId, " was not found"), 1);
        return ParcelProcessingState.NOT_EXIST;
    }

    @Deprecated
    public @NonNull Binder extendedCheckItem(HashId itemId) {
        ItemResult ir = this.checkItem(itemId);
        Binder result = Binder.of("itemResult", ir, new Object[0]);
        if (ir != null && ir.state == ItemState.LOCKED) {
            ir.lockedById = this.ledger.getLockOwnerOf(itemId).getId();
        }
        return result;
    }

    public void resync(HashId id) throws Exception {
        Object x = this.checkItemInternal(id, null, null, true, true, true);
        if (x instanceof ItemProcessor) {
            ((ItemProcessor)x).pulseResync(true);
        } else {
            log.e("ItemProcessor hasn't found or created for " + id.toBase64String(), new Object[0]);
        }
    }

    public ItemResult waitItem(HashId itemId, long millisToWait) throws TimeoutException, InterruptedException {
        Object x = null;
        x = this.checkItemInternal(itemId);
        if (x instanceof ItemProcessor) {
            if (!((ItemProcessor)x).isDone()) {
                ((ItemProcessor)x).doneEvent.await(millisToWait);
            }
            return ((ItemProcessor)x).getResult();
        }
        return (ItemResult)x;
    }

    public void waitParcel(HashId parcelId, long millisToWait) throws TimeoutException, InterruptedException {
        Object x = null;
        x = this.checkParcelInternal(parcelId);
        if (x instanceof ParcelProcessor && !((ParcelProcessor)x).isDone()) {
            ((ParcelProcessor)x).doneEvent.await(millisToWait);
        }
    }

    private final void onNotification(Notification notification) {
        if (notification instanceof ItemResyncNotification) {
            this.obtainResyncNotification((ItemResyncNotification)notification);
        } else if (notification instanceof ParcelNotification) {
            this.obtainParcelCommonNotification((ParcelNotification)notification);
        } else if (notification instanceof ItemNotification) {
            this.obtainCommonNotification((ItemNotification)notification);
        }
    }

    private final void obtainResyncNotification(ItemResyncNotification notification) {
        ItemProcessor ip;
        HashMap<HashId, ItemState> itemsToResync = notification.getItemsToResync();
        HashMap<HashId, ItemState> answersForItems = new HashMap<HashId, ItemState>();
        NodeInfo from = notification.getFrom();
        Object itemObject = this.checkItemInternal(notification.getItemId());
        if (notification.answerIsRequested()) {
            for (HashId hid : itemsToResync.keySet()) {
                Object subitemObject = this.checkItemInternal(hid);
                ItemResult subItemResult = subitemObject instanceof ItemResult ? (ItemResult)subitemObject : (subitemObject instanceof ItemProcessor ? ((ItemProcessor)subitemObject).getResult() : null);
                ItemState subItemState = subItemResult != null ? (subItemResult.state.isConsensusFound() ? subItemResult.state : ItemState.UNDEFINED) : ItemState.UNDEFINED;
                answersForItems.put(hid, subItemState);
            }
            this.network.deliver(from, new ItemResyncNotification(this.myInfo, notification.getItemId(), answersForItems, false));
        }
        if (itemObject instanceof ItemProcessor && (ip = (ItemProcessor)itemObject).processingState.isResyncing()) {
            ip.lock(() -> {
                for (HashId hid : itemsToResync.keySet()) {
                    ip.resyncVote(hid, from, (ItemState)((Object)((Object)itemsToResync.get(hid))));
                }
                return null;
            });
        }
    }

    private final void obtainCommonNotification(ItemNotification notification) {
        Object x = this.checkItemInternal(notification.getItemId(), null, null, true, true);
        NodeInfo from = notification.getFrom();
        ParcelNotification.ParcelNotificationType notType = notification instanceof ParcelNotification ? ((ParcelNotification)notification).getType() : ParcelNotification.ParcelNotificationType.PAYMENT;
        if (x instanceof ItemResult) {
            ItemResult r = (ItemResult)x;
            if (notification.answerIsRequested()) {
                this.network.deliver(from, new ParcelNotification(this.myInfo, notification.getItemId(), null, r, false, notType));
            }
        } else if (x instanceof ItemProcessor) {
            ItemProcessor ip = (ItemProcessor)x;
            ItemResult result = notification.getItemResult();
            ip.lock(() -> {
                if (result.haveCopy) {
                    ip.addToSources(from);
                }
                if (result.state != ItemState.PENDING) {
                    ip.vote(from, result.state);
                } else {
                    log.e("pending vote on item " + notification.getItemId() + " from " + from, new Object[0]);
                }
                if (notification.answerIsRequested() && ip.record.getState() != ItemState.PENDING) {
                    this.network.deliver(from, new ParcelNotification(this.myInfo, notification.getItemId(), null, ip.getResult(), ip.needsVoteFrom(from), notType));
                }
                return null;
            });
        }
    }

    private final void obtainParcelCommonNotification(ParcelNotification notification) {
        if (notification.getParcelId() == null) {
            this.obtainCommonNotification(notification);
        } else {
            Object item_x = this.checkItemInternal(notification.getItemId());
            if (item_x instanceof ItemResult && ((ItemResult)item_x).state.isConsensusFound()) {
                NodeInfo from = notification.getFrom();
                ItemResult r = (ItemResult)item_x;
                if (notification.answerIsRequested()) {
                    this.network.deliver(from, new ParcelNotification(this.myInfo, notification.getItemId(), notification.getParcelId(), r, false, notification.getType()));
                }
            } else {
                Object x = this.checkParcelInternal(notification.getParcelId(), null, true);
                NodeInfo from = notification.getFrom();
                if (x instanceof ParcelProcessor) {
                    ParcelProcessor pp = (ParcelProcessor)x;
                    ItemResult resultVote = notification.getItemResult();
                    pp.lock(() -> {
                        if (resultVote.haveCopy) {
                            pp.addToSources(from);
                        }
                        if (resultVote.state != ItemState.PENDING) {
                            pp.vote(from, resultVote.state, notification.getType().isTU());
                        } else {
                            log.e("pending vote on parcel " + notification.getParcelId() + " and item " + notification.getItemId() + " from " + from, new Object[0]);
                        }
                        if (notification.answerIsRequested()) {
                            if (notification.getType().isTU()) {
                                if (pp.getPaymentState() != ItemState.PENDING) {
                                    this.network.deliver(from, new ParcelNotification(this.myInfo, notification.getItemId(), notification.getParcelId(), pp.getPaymentResult(), pp.needsPaymentVoteFrom(from), notification.getType()));
                                }
                            } else if (pp.getPayloadState() != ItemState.PENDING) {
                                this.network.deliver(from, new ParcelNotification(this.myInfo, notification.getItemId(), notification.getParcelId(), pp.getPayloadResult(), pp.needsPayloadVoteFrom(from), notification.getType()));
                            }
                        }
                        return null;
                    });
                }
            }
        }
    }

    private Object checkItemInternal(@NonNull HashId itemId) {
        return this.checkItemInternal(itemId, null, null, false, false);
    }

    private Object checkItemInternal(@NonNull HashId itemId, HashId parcelId, Approvable item, boolean autoStart, boolean forceChecking) {
        return this.checkItemInternal(itemId, parcelId, item, autoStart, forceChecking, false);
    }

    private Object checkItemInternal(@NonNull HashId itemId, HashId parcelId, Approvable item, boolean autoStart, boolean forceChecking, boolean ommitItemResult) {
        try {
            this.report(this.getLabel(), () -> this.concatReportMessage("checkItemInternal: ", itemId), 1);
            return this.itemLock.synchronize(itemId, lock -> {
                Object r;
                ItemProcessor ip = this.processors.get(itemId);
                if (ip != null) {
                    this.report(this.getLabel(), () -> this.concatReportMessage(new Object[]{"checkItemInternal: ", itemId, "found item processor in state: ", ip.processingState}), 1);
                    return ip;
                }
                if (!ommitItemResult) {
                    r = this.ledger.getRecord(itemId);
                    if (r != null && !((StateRecord)r).isPending()) {
                        this.report(this.getLabel(), () -> this.lambda$null$23(itemId, (StateRecord)r), 1);
                        return new ItemResult((StateRecord)r, this.cache.get(itemId) != null);
                    }
                    if (item != null && item.getCreatedAt().isBefore(ZonedDateTime.now().minus(this.config.getMaxItemCreationAge()))) {
                        item.addError(Errors.EXPIRED, "created_at", "too old");
                        this.report(this.getLabel(), () -> this.concatReportMessage("checkItemInternal: ", itemId, "too old: "), 1);
                        return ItemResult.DISCARDED;
                    }
                }
                if (autoStart) {
                    if (item != null) {
                        r = this.cache;
                        synchronized (r) {
                            this.cache.put(item);
                        }
                    }
                    this.report(this.getLabel(), () -> this.concatReportMessage("checkItemInternal: ", itemId, "nothing found, will create item processor"), 1);
                    ItemProcessor processor = new ItemProcessor(itemId, parcelId, item, lock, forceChecking);
                    this.processors.put(itemId, processor);
                    return processor;
                }
                return ItemResult.UNDEFINED;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("failed to checkItem", e);
        }
    }

    protected Object checkParcelInternal(@NonNull HashId parcelId) {
        return this.checkParcelInternal(parcelId, null, false);
    }

    protected Object checkParcelInternal(@NonNull HashId parcelId, Parcel parcel, boolean autoStart) {
        try {
            return this.parcelLock.synchronize(parcelId, lock -> {
                ParcelProcessor processor = this.parcelProcessors.get(parcelId);
                if (processor != null) {
                    return processor;
                }
                if (autoStart) {
                    if (parcel != null) {
                        ParcelCache parcelCache = this.parcelCache;
                        synchronized (parcelCache) {
                            this.parcelCache.put(parcel);
                        }
                    }
                    processor = new ParcelProcessor(parcelId, parcel, lock);
                    this.parcelProcessors.put(parcelId, processor);
                    return processor;
                }
                return ItemResult.UNDEFINED;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("failed to checkItem", e);
        }
    }

    public String toString() {
        return "[" + this.dataFormat.format(new Date()) + "] Node(" + this.myInfo.getNumber() + ") ";
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Approvable getItem(HashId itemId) {
        ItemCache itemCache = this.cache;
        synchronized (itemCache) {
            @Nullable Approvable i = this.cache.get(itemId);
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parcel getParcel(HashId parcelId) {
        ParcelCache parcelCache = this.parcelCache;
        synchronized (parcelCache) {
            @Nullable Parcel i = this.parcelCache.get(parcelId);
            return i;
        }
    }

    public int countElections() {
        return this.processors.size();
    }

    public ItemCache getCache() {
        return this.cache;
    }

    public ParcelCache getParcelCache() {
        return this.parcelCache;
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public void shutdown() {
        this.isShuttingDown = true;
        System.out.println(this.toString() + "please wait, shutting down has started, num alive item processors: " + this.processors.size());
        for (ItemProcessor ip : this.processors.values()) {
            ip.emergencyBreak();
        }
        while (this.processors.size() > 0) {
            System.out.println("---------------------------------------------");
            System.out.println(this.toString() + "please wait, shutting down is still continue, num alive item processors: " + this.processors.size());
            for (HashId hid : this.processors.keySet()) {
                ItemProcessor ipr = this.processors.get(hid);
                System.out.println(this.toString() + "processor " + hid + " is " + ipr);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println(this.toString() + "please wait, executorService is shutting down");
        this.executorService.shutdown();
        this.lowPrioExecutorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("executorService.awaitTermination... timeout");
        }
        try {
            this.lowPrioExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("lowPrioExecutorService.awaitTermination... timeout");
        }
        this.cache.shutdown();
        this.parcelCache.shutdown();
        System.out.println(this.toString() + "shutdown finished");
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public void report(String label, String message, int level) {
        if (level <= this.verboseLevel) {
            System.out.println(label + message);
        }
    }

    public void report(String label, Callable<String> message, int level) {
        if (level <= this.verboseLevel) {
            try {
                System.out.println(label + message.call());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void report(String label, String message) {
        this.report(label, message, 2);
    }

    public void report(String label, Callable<String> message) {
        this.report(label, message, 2);
    }

    protected String concatReportMessage(Object ... messages) {
        String returnMessage = "";
        for (Object m : messages) {
            returnMessage = returnMessage + (m != null ? m.toString() : "null");
        }
        return returnMessage;
    }

    public void addNode(NodeInfo nodeToAdd) {
        this.ledger.addNode(nodeToAdd);
        this.network.addNode(nodeToAdd);
        if (!this.config.updateConsensusConfig(this.network.getNodesCount())) {
            throw new RuntimeException("Dynamic consensus reconfigurator isn't set");
        }
    }

    public void removeNode(NodeInfo nodeToRemove) {
        this.ledger.removeNode(nodeToRemove);
        this.network.removeNode(nodeToRemove);
        if (!this.config.updateConsensusConfig(this.network.getNodesCount())) {
            throw new RuntimeException("Dynamic consensus reconfigurator isn't set");
        }
    }

    public Binder provideStats() {
        return Binder.of("uptime", (Object)(Instant.now().getEpochSecond() - this.nodeStartTime.getEpochSecond()), new Object[]{"ledgerSize", this.ledgerSize.values().stream().reduce((i1, i2) -> i1 + i2).get(), "smallIntervalApproved", this.smallIntervalApproved, "bigIntervalApproved", this.bigIntervalApproved, "uptimeApproved", this.uptimeApproved});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemSanitationDone(StateRecord record) {
        Map<HashId, StateRecord> map = this.recordsToSanitate;
        synchronized (map) {
            if (this.recordsToSanitate.containsKey(record.getId())) {
                this.recordsToSanitate.remove(record.getId());
                HashSet idsToRemove = new HashSet();
                for (StateRecord r : this.recordsToSanitate.values()) {
                    if (r.getLockedByRecordId() != record.getRecordId()) continue;
                    try {
                        this.itemLock.synchronize(r.getId(), lock -> {
                            if (record.getState() == ItemState.APPROVED) {
                                if (r.getState() == ItemState.LOCKED) {
                                    r.setState(ItemState.REVOKED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                } else if (r.getState() == ItemState.LOCKED_FOR_CREATION) {
                                    r.setState(ItemState.APPROVED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                }
                            } else if (record.getState() == ItemState.DECLINED) {
                                if (r.getState() == ItemState.LOCKED) {
                                    r.setState(ItemState.APPROVED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                } else if (r.getState() == ItemState.LOCKED_FOR_CREATION) {
                                    r.destroy();
                                    idsToRemove.add(r.getId());
                                }
                            } else if (record.getState() == ItemState.REVOKED) {
                                if (r.getState() == ItemState.LOCKED) {
                                    r.setState(ItemState.REVOKED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                } else if (r.getState() == ItemState.LOCKED_FOR_CREATION) {
                                    r.setState(ItemState.APPROVED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                }
                            } else if (record.getState() == ItemState.UNDEFINED) {
                                if (r.getState() == ItemState.LOCKED) {
                                    r.setState(ItemState.APPROVED);
                                    r.save();
                                    idsToRemove.add(r.getId());
                                } else if (r.getState() == ItemState.LOCKED_FOR_CREATION) {
                                    r.destroy();
                                    idsToRemove.add(r.getId());
                                }
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                idsToRemove.stream().forEach(id -> this.recordsToSanitate.remove(id));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void itemSanitationFailed(StateRecord record) {
        if (!this.recordsToSanitate.containsKey(record.getId())) return;
        Contract contract = (Contract)this.ledger.getItem(record);
        if (contract != null) {
            record.setState(ItemState.PENDING);
            try {
                this.itemLock.synchronize(record.getId(), lock -> {
                    record.save();
                    return null;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object x = this.checkItemInternal(contract.getId(), null, contract, true, true, true);
            if (!(x instanceof ItemProcessor)) throw new IllegalStateException("should never happen because ommitItemResult is true");
            ((ItemProcessor)x).doneEvent.addConsumer(i -> this.executorService.schedule(() -> this.itemSanitationDone(record), 0L, TimeUnit.SECONDS));
            return;
        }
        record.setState(ItemState.UNDEFINED);
        try {
            this.itemLock.synchronize(record.getId(), lock -> {
                record.destroy();
                return null;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.itemSanitationDone(record);
    }

    private void checkSpecialItem(Approvable item) {
        Contract contract;
        if (item instanceof Contract && (contract = (Contract)item).getIssuer().getKeys().equals(new HashSet<PublicKey>(Arrays.asList(this.config.getNetworkConfigIssuerKey())))) {
            if (contract.getParent() == null) {
                return;
            }
            if (contract.getRevoking().size() == 0 || !contract.getRevoking().get(0).getId().equals(contract.getParent())) {
                return;
            }
            Contract parent = contract.getRevoking().get(0);
            if (!this.checkContractCorrespondsToConfig(parent, this.network.allNodes())) {
                return;
            }
            if (!this.checkIfContractContainsNetConfig(contract)) {
                return;
            }
            List<NodeInfo> networkNodes = this.network.allNodes();
            List contractNodes = (List)DefaultBiMapper.getInstance().deserializeObject(contract.getStateData().get("net_config"));
            contractNodes.stream().forEach(nodeInfo -> {
                if (!networkNodes.contains(nodeInfo)) {
                    this.addNode((NodeInfo)nodeInfo);
                }
                networkNodes.remove(nodeInfo);
            });
            networkNodes.stream().forEach(nodeInfo -> this.removeNode((NodeInfo)nodeInfo));
        }
    }

    private boolean checkIfContractContainsNetConfig(Contract contract) {
        if (!contract.getStateData().containsKey("net_config")) {
            return false;
        }
        if (!(contract.getOwner() instanceof ListRole)) {
            return false;
        }
        ListRole owner = (ListRole)contract.getOwner();
        if (owner.getQuorum() == 0 || owner.getQuorum() < owner.getRoles().size() - 1) {
            return false;
        }
        Object obj = DefaultBiMapper.getInstance().deserializeObject(contract.getStateData().get("net_config"));
        if (!(obj instanceof List)) {
            return false;
        }
        List contractNodes = (List)obj;
        Set<PublicKey> ownerKeys = contract.getOwner().getKeys();
        if (contractNodes.size() != ownerKeys.size() || !contractNodes.stream().allMatch(nodeInfo -> nodeInfo instanceof NodeInfo && ownerKeys.contains(((NodeInfo)nodeInfo).getPublicKey()))) {
            return false;
        }
        for (Permission permission : contract.getPermissions().values()) {
            if (permission instanceof ChangeOwnerPermission && (!(permission.getRole() instanceof RoleLink) || ((RoleLink)permission.getRole()).getRole() != contract.getOwner())) {
                return false;
            }
            if (!(permission instanceof ModifyDataPermission) || !((ModifyDataPermission)permission).getFields().containsKey("net_config") || permission.getRole() instanceof RoleLink && ((RoleLink)permission.getRole()).getRole() == contract.getOwner()) continue;
            return false;
        }
        return true;
    }

    private boolean checkContractCorrespondsToConfig(Contract contract, List<NodeInfo> netNodes) {
        if (!this.checkIfContractContainsNetConfig(contract)) {
            return false;
        }
        List contractNodes = (List)DefaultBiMapper.getInstance().deserializeObject(contract.getStateData().get("net_config"));
        return contractNodes.size() == netNodes.size() && contractNodes.stream().allMatch(nodeInfo -> netNodes.contains(nodeInfo));
    }

    private /* synthetic */ String lambda$null$23(HashId itemId, StateRecord r) throws Exception {
        return this.concatReportMessage(new Object[]{"checkItemInternal: ", itemId, "found item result, and state is: ", r.getState()});
    }

    public static enum ResyncingItemProcessingState {
        WAIT_FOR_VOTES,
        PENDING_TO_COMMIT,
        IS_COMMITTING,
        COMMIT_SUCCESSFUL,
        COMMIT_FAILED;

    }

    private class ResyncingItem {
        private HashId hashId;
        private StateRecord record;
        private final ItemState stateWas;
        private ResyncingItemProcessingState resyncingState;
        private final AsyncEvent<ResyncingItem> finishEvent = new AsyncEvent();
        private HashMap<ItemState, Set<NodeInfo>> resyncNodes = new HashMap();
        private final Object mutex = new Object();

        public ResyncingItem(HashId hid, StateRecord record) {
            this.resyncingState = ResyncingItemProcessingState.WAIT_FOR_VOTES;
            this.hashId = hid;
            this.record = record;
            StateRecord recordWas = Node.this.ledger.getRecord(hid);
            this.stateWas = recordWas != null ? recordWas.getState() : ItemState.UNDEFINED;
            this.resyncNodes.put(ItemState.APPROVED, new HashSet());
            this.resyncNodes.put(ItemState.REVOKED, new HashSet());
            this.resyncNodes.put(ItemState.DECLINED, new HashSet());
            this.resyncNodes.put(ItemState.UNDEFINED, new HashSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void resyncVote(NodeInfo node, ItemState state) {
            boolean approvedConsenus = false;
            boolean revokedConsenus = false;
            boolean declinedConsenus = false;
            boolean undefinedConsenus = false;
            Object object = this.mutex;
            synchronized (object) {
                for (ItemState is : this.resyncNodes.keySet()) {
                    this.resyncNodes.get((Object)is).remove(node);
                }
                if (!this.resyncNodes.containsKey((Object)state)) {
                    this.resyncNodes.put(state, new HashSet());
                }
                this.resyncNodes.get((Object)state).add(node);
                if (this.isResyncPollingFinished()) {
                    return;
                }
                if (this.resyncNodes.get((Object)ItemState.REVOKED).size() >= Node.this.config.getPositiveConsensus()) {
                    revokedConsenus = true;
                    this.resyncingState = ResyncingItemProcessingState.PENDING_TO_COMMIT;
                } else if (this.resyncNodes.get((Object)ItemState.DECLINED).size() >= Node.this.config.getPositiveConsensus()) {
                    declinedConsenus = true;
                    this.resyncingState = ResyncingItemProcessingState.PENDING_TO_COMMIT;
                } else if (this.resyncNodes.get((Object)ItemState.APPROVED).size() >= Node.this.config.getPositiveConsensus()) {
                    approvedConsenus = true;
                    this.resyncingState = ResyncingItemProcessingState.PENDING_TO_COMMIT;
                } else if (this.resyncNodes.get((Object)ItemState.UNDEFINED).size() >= Node.this.config.getResyncBreakConsensus()) {
                    undefinedConsenus = true;
                    this.resyncingState = ResyncingItemProcessingState.PENDING_TO_COMMIT;
                }
                if (!this.isResyncPollingFinished()) {
                    return;
                }
            }
            if (revokedConsenus) {
                Node.this.executorService.submit(() -> this.resyncAndCommit(ItemState.REVOKED), Node.this.toString() + " > item " + this.hashId + " :: resyncVote -> resyncAndCommit");
            } else if (declinedConsenus) {
                Node.this.executorService.submit(() -> this.resyncAndCommit(ItemState.DECLINED), Node.this.toString() + " > item " + this.hashId + " :: resyncVote -> resyncAndCommit");
            } else if (approvedConsenus) {
                Node.this.executorService.submit(() -> this.resyncAndCommit(ItemState.APPROVED), Node.this.toString() + " > item " + this.hashId + " :: resyncVote -> resyncAndCommit");
            } else if (undefinedConsenus) {
                Node.this.executorService.submit(() -> this.resyncAndCommit(ItemState.UNDEFINED), Node.this.toString() + " > item " + this.hashId + " :: resyncVote -> resyncAndCommit");
            } else {
                throw new RuntimeException("error: resync consensus reported without consensus");
            }
        }

        private final void resyncAndCommit(ItemState committingState) {
            this.resyncingState = ResyncingItemProcessingState.IS_COMMITTING;
            Average startDateAvg = new Average();
            Average expiresAtAvg = new Average();
            Node.this.executorService.submit(() -> {
                if (committingState.isConsensusFound()) {
                    HashSet<NodeInfo> rNodes = new HashSet<NodeInfo>();
                    Set<NodeInfo> nowNodes = this.resyncNodes.get((Object)committingState);
                    HashMap<ItemState, Set<NodeInfo>> hashMap = this.resyncNodes;
                    synchronized (hashMap) {
                        for (NodeInfo ni : nowNodes) {
                            rNodes.add(ni);
                        }
                    }
                    for (NodeInfo ni : rNodes) {
                        if (ni == null) continue;
                        try {
                            ItemResult r = Node.this.network.getItemState(ni, this.hashId);
                            if (r == null) continue;
                            startDateAvg.update(r.createdAt.toEpochSecond());
                            expiresAtAvg.update(r.expiresAt.toEpochSecond());
                            ZonedDateTime createdAt = ZonedDateTime.ofInstant(Instant.ofEpochSecond((long)startDateAvg.average()), ZoneId.systemDefault());
                            ZonedDateTime expiresAt = ZonedDateTime.ofInstant(Instant.ofEpochSecond((long)expiresAtAvg.average()), ZoneId.systemDefault());
                            try {
                                Node.this.itemLock.synchronize(this.hashId, lock -> {
                                    Node.this.ledger.findOrCreate(this.hashId).setState(committingState).setCreatedAt(createdAt).setExpiresAt(expiresAt).save();
                                    return null;
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException r) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.resyncingState = ResyncingItemProcessingState.COMMIT_SUCCESSFUL;
                } else {
                    this.resyncingState = ResyncingItemProcessingState.COMMIT_FAILED;
                }
                this.finishEvent.fire(this);
            }, Node.this.toString() + " > item " + this.hashId + " :: resyncAndCommit -> body");
        }

        public void closeByTimeout() {
            this.resyncingState = ResyncingItemProcessingState.COMMIT_FAILED;
            this.finishEvent.fire(this);
        }

        public boolean needsResyncVoteFrom(NodeInfo node) {
            return !this.resyncNodes.get((Object)ItemState.APPROVED).contains(node) && !this.resyncNodes.get((Object)ItemState.REVOKED).contains(node) && !this.resyncNodes.get((Object)ItemState.DECLINED).contains(node) && !this.resyncNodes.get((Object)ItemState.UNDEFINED).contains(node);
        }

        public ResyncingItemProcessingState getResyncingState() {
            return this.resyncingState;
        }

        public boolean isResyncPollingFinished() {
            return this.resyncingState != ResyncingItemProcessingState.WAIT_FOR_VOTES;
        }

        public boolean isCommitFinished() {
            return this.resyncingState == ResyncingItemProcessingState.COMMIT_SUCCESSFUL || this.resyncingState == ResyncingItemProcessingState.COMMIT_FAILED;
        }

        public HashId getId() {
            return this.hashId;
        }

        public ItemState getItemState() {
            if (this.record != null) {
                return this.record.getState();
            }
            return ItemState.UNDEFINED;
        }
    }

    public static enum ItemProcessingState {
        NOT_EXIST,
        INIT,
        DOWNLOADING,
        DOWNLOADED,
        CHECKING,
        RESYNCING,
        GOT_RESYNCED_STATE,
        POLLING,
        GOT_CONSENSUS,
        DONE,
        SENDING_CONSENSUS,
        FINISHED,
        EMERGENCY_BREAK;


        public boolean isProcessedToConsensus() {
            switch (this) {
                case GOT_CONSENSUS: 
                case SENDING_CONSENSUS: 
                case DONE: 
                case FINISHED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDone() {
            switch (this) {
                case SENDING_CONSENSUS: 
                case DONE: 
                case FINISHED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isConsensusSentAndReceived() {
            return this == FINISHED;
        }

        public boolean isGotConsensus() {
            return this == GOT_CONSENSUS;
        }

        public boolean isGotResyncedState() {
            return this == GOT_RESYNCED_STATE;
        }

        public boolean isResyncing() {
            return this == RESYNCING;
        }

        public boolean canContinue() {
            return this != EMERGENCY_BREAK;
        }

        public boolean canRemoveSelf() {
            switch (this) {
                case FINISHED: 
                case EMERGENCY_BREAK: {
                    return true;
                }
            }
            return false;
        }

        public boolean notCheckedYet() {
            switch (this) {
                case NOT_EXIST: 
                case INIT: 
                case DOWNLOADING: 
                case DOWNLOADED: 
                case CHECKING: 
                case RESYNCING: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum ParcelProcessingState {
        NOT_EXIST,
        INIT,
        DOWNLOADING,
        PREPARING,
        PAYMENT_CHECKING,
        PAYLOAD_CHECKING,
        RESYNCING,
        GOT_RESYNCED_STATE,
        PAYMENT_POLLING,
        PAYLOAD_POLLING,
        GOT_CONSENSUS,
        SENDING_CONSENSUS,
        FINISHED,
        EMERGENCY_BREAK;


        public boolean isProcessedToConsensus() {
            switch (this) {
                case GOT_CONSENSUS: 
                case SENDING_CONSENSUS: 
                case FINISHED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isConsensusSentAndReceived() {
            return this == FINISHED;
        }

        public boolean isGotConsensus() {
            return this == GOT_CONSENSUS;
        }

        public boolean isGotResyncedState() {
            return this == GOT_RESYNCED_STATE;
        }

        public boolean isResyncing() {
            return this == RESYNCING;
        }

        public boolean canContinue() {
            return this != EMERGENCY_BREAK;
        }

        public boolean canRemoveSelf() {
            switch (this) {
                case FINISHED: 
                case EMERGENCY_BREAK: {
                    return true;
                }
            }
            return false;
        }

        public boolean isProcessing() {
            return this.canContinue() && this != FINISHED && this != NOT_EXIST;
        }

        public Binder toBinder() {
            return Binder.fromKeysValues("state", this.name());
        }

        static {
            DefaultBiMapper.registerAdapter(ParcelProcessingState.class, new BiAdapter(){

                public Binder serialize(Object object, BiSerializer serializer) {
                    return ((ParcelProcessingState)((Object)object)).toBinder();
                }

                public ParcelProcessingState deserialize(Binder binder, BiDeserializer deserializer) {
                    return ParcelProcessingState.valueOf(binder.getStringOrThrow("state"));
                }

                @Override
                public String typeName() {
                    return "ParcelProcessingState";
                }
            });
        }
    }

    private class ItemProcessor {
        private final HashId itemId;
        private final HashId parcelId;
        private Approvable item;
        private final StateRecord record;
        private final ItemState stateWas;
        private ItemProcessingState processingState;
        private Set<NodeInfo> sources = new HashSet<NodeInfo>();
        private boolean resyncItselfOnly;
        private Set<NodeInfo> positiveNodes = new HashSet<NodeInfo>();
        private Set<NodeInfo> negativeNodes = new HashSet<NodeInfo>();
        private HashMap<HashId, ResyncingItem> resyncingItems = new HashMap();
        private List<StateRecord> lockedToRevoke = new ArrayList<StateRecord>();
        private List<StateRecord> lockedToCreate = new ArrayList<StateRecord>();
        private Instant pollingExpiresAt;
        private Instant consensusReceivedExpiresAt;
        private Instant resyncExpiresAt;
        private boolean alreadyChecked;
        private boolean isCheckingForce = false;
        private final AsyncEvent<Void> downloadedEvent = new AsyncEvent();
        private final AsyncEvent<Void> doneEvent = new AsyncEvent();
        private final AsyncEvent<Void> pollingReadyEvent = new AsyncEvent();
        private final AsyncEvent<Void> removedEvent = new AsyncEvent();
        private final Object mutex;
        private final Object resyncMutex;
        private ScheduledFuture<?> downloader;
        private RunnableWithDynamicPeriod poller;
        private RunnableWithDynamicPeriod consensusReceivedChecker;
        private RunnableWithDynamicPeriod resyncer;

        public ItemProcessor(HashId itemId, HashId parcelId, Approvable item, Object lock, boolean isCheckingForce) {
            this.mutex = lock;
            this.resyncMutex = new Object();
            this.isCheckingForce = isCheckingForce;
            this.processingState = ItemProcessingState.INIT;
            this.itemId = itemId;
            this.parcelId = parcelId;
            if (item == null) {
                item = Node.this.cache.get(itemId);
            }
            this.item = item;
            StateRecord recordWas = null;
            try {
                recordWas = Node.this.ledger.getRecord(itemId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.stateWas = recordWas != null ? recordWas.getState() : ItemState.UNDEFINED;
            this.record = Node.this.ledger.findOrCreate(itemId);
            this.pollingExpiresAt = Instant.now().plus(Node.this.config.getMaxElectionsTime());
            this.consensusReceivedExpiresAt = Instant.now().plus(Node.this.config.getMaxConsensusReceivedCheckTime());
            this.resyncExpiresAt = Instant.now().plus(Node.this.config.getMaxResyncTime());
            this.alreadyChecked = false;
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", itemId, " from parcel: ", parcelId, " :: created, state ", this.processingState}), 1);
            if (this.item != null) {
                Node.this.executorService.submit(() -> this.itemDownloaded(), Node.this.toString() + this.toString() + " :: ItemProcessor -> itemDownloaded");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pulseDownload() {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                if (!this.processingState.isProcessedToConsensus()) {
                    this.processingState = ItemProcessingState.DOWNLOADING;
                }
                Object object = this.mutex;
                synchronized (object) {
                    if (this.item == null && (this.downloader == null || this.downloader.isDone())) {
                        this.downloader = (ScheduledFuture)Node.this.executorService.submit(() -> this.download(), Node.this.toString() + this.toString() + " :: item pulseDownload -> download");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download() {
            if (this.processingState.canContinue()) {
                while (!this.isPollingExpired() && this.item == null) {
                    if (this.sources.isEmpty()) {
                        log.e("empty sources for download tasks, stopping", new Object[0]);
                        return;
                    }
                    try {
                        NodeInfo source;
                        Set<NodeInfo> set = this.sources;
                        synchronized (set) {
                            source = (NodeInfo)Do.sample(this.sources);
                        }
                        this.item = Node.this.network.getItem(this.itemId, source, Node.this.config.getMaxGetItemTime());
                        if (this.item != null) {
                            this.itemDownloaded();
                            return;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void itemDownloaded() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: itemDownloaded, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                Object object = Node.this.cache;
                synchronized (object) {
                    Node.this.cache.put(this.item);
                }
                object = this.mutex;
                synchronized (object) {
                    Node.this.ledger.putItem(this.record, this.item, Instant.now().plus(Node.this.config.getMaxDiskCacheAge()));
                }
                if (!this.processingState.isProcessedToConsensus()) {
                    this.processingState = ItemProcessingState.DOWNLOADED;
                }
                if (this.isCheckingForce) {
                    this.checkItem();
                }
                this.downloadedEvent.fire();
            }
        }

        private void stopDownloader() {
            if (this.downloader != null) {
                this.downloader.cancel(true);
            }
        }

        private final synchronized void checkItem() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: checkItem, state ", this.processingState}), 1);
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus() && this.processingState != ItemProcessingState.POLLING && this.processingState != ItemProcessingState.CHECKING && this.processingState != ItemProcessingState.RESYNCING) {
                if (this.alreadyChecked) {
                    throw new RuntimeException("Check already processed");
                }
                if (!this.processingState.isProcessedToConsensus()) {
                    this.processingState = ItemProcessingState.CHECKING;
                }
                HashMap<Object, Object> itemsToResync = new HashMap();
                boolean needToResync = false;
                try {
                    boolean checkPassed = false;
                    if (this.item.shouldBeTU()) {
                        if (this.item.isTU(Node.this.config.getTransactionUnitsIssuerKey(), Node.this.config.getTUIssuerName())) {
                            checkPassed = this.item.paymentCheck(Node.this.config.getTransactionUnitsIssuerKey());
                        } else {
                            checkPassed = false;
                            this.item.addError(Errors.BADSTATE, this.item.getId().toString(), "Item that should be TU contract is not TU contract");
                        }
                    } else {
                        checkPassed = this.item.check();
                    }
                    if (checkPassed) {
                        itemsToResync = this.isNeedToResync(true);
                        boolean bl = needToResync = !itemsToResync.isEmpty();
                        if (!needToResync) {
                            this.checkSubItems();
                        }
                    }
                }
                catch (Quantiser.QuantiserException e) {
                    this.emergencyBreak();
                    return;
                }
                this.alreadyChecked = true;
                if (!needToResync) {
                    this.commitCheckedAndStartPolling();
                } else {
                    for (HashId hashId : itemsToResync.keySet()) {
                        this.addItemToResync(hashId, (StateRecord)itemsToResync.get(hashId));
                    }
                    this.pulseResync();
                }
            }
        }

        private final void checkSubItems() {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                this.checkSubItemsOf(this.item);
            }
        }

        private final synchronized void checkSubItemsOf(Approvable checkingItem) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                this.checkReferencesOf(checkingItem);
                this.checkRevokesOf(checkingItem);
                this.checkNewsOf(checkingItem);
            }
        }

        private final synchronized void checkReferencesOf(Approvable checkingItem) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                for (Approvable ref : checkingItem.getReferencedItems()) {
                    HashId id = ref.getId();
                    if (Node.this.ledger.isApproved(id)) continue;
                    checkingItem.addError(Errors.BAD_REF, id.toString(), "reference not approved");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final synchronized void checkRevokesOf(Approvable checkingItem) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                for (Approvable a : checkingItem.getRevokingItems()) {
                    if (a instanceof Contract) {
                        ((Contract)a).getErrors().clear();
                    }
                    this.checkReferencesOf(a);
                    for (ErrorRecord er : a.getErrors()) {
                        checkingItem.addError(Errors.BAD_REVOKE, a.getId().toString(), "can't revoke: " + er);
                    }
                    Object object = this.mutex;
                    synchronized (object) {
                        try {
                            Node.this.itemLock.synchronize(a.getId(), lock -> {
                                StateRecord r = this.record.lockToRevoke(a.getId());
                                if (r == null) {
                                    checkingItem.addError(Errors.BAD_REVOKE, a.getId().toString(), "can't revoke");
                                } else if (!this.lockedToRevoke.contains(r)) {
                                    this.lockedToRevoke.add(r);
                                }
                                return null;
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final synchronized void checkNewsOf(Approvable checkingItem) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                for (Approvable newItem : checkingItem.getNewItems()) {
                    this.checkSubItemsOf(newItem);
                    if (!newItem.getErrors().isEmpty()) {
                        checkingItem.addError(Errors.BAD_NEW_ITEM, newItem.getId().toString(), "bad new item: not passed check");
                        continue;
                    }
                    Object object = this.mutex;
                    synchronized (object) {
                        try {
                            Node.this.itemLock.synchronize(newItem.getId(), lock -> {
                                StateRecord r = this.record.createOutputLockRecord(newItem.getId());
                                if (r == null) {
                                    checkingItem.addError(Errors.NEW_ITEM_EXISTS, newItem.getId().toString(), "new item exists in ledger");
                                } else if (!this.lockedToCreate.contains(r)) {
                                    this.lockedToCreate.add(r);
                                }
                                return null;
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void commitCheckedAndStartPolling() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: commitCheckedAndStartPolling, state ", this.processingState}), 1);
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                boolean checkPassed = this.item.getErrors().isEmpty();
                if (!checkPassed) {
                    Node.this.informer.inform(this.item);
                }
                Object object = this.mutex;
                synchronized (object) {
                    if (this.record.getState() == ItemState.PENDING) {
                        if (checkPassed) {
                            this.setState(ItemState.PENDING_POSITIVE);
                        } else {
                            this.setState(ItemState.PENDING_NEGATIVE);
                        }
                    }
                    this.record.setExpiresAt(this.item.getExpiresAt());
                    try {
                        this.record.save();
                    }
                    catch (Ledger.Failure failure) {
                        this.emergencyBreak();
                        return;
                    }
                }
                if (!this.processingState.isProcessedToConsensus()) {
                    this.processingState = ItemProcessingState.POLLING;
                }
                this.vote(Node.this.myInfo, this.record.getState());
                this.broadcastMyState();
                this.pulseStartPolling();
                this.pollingReadyEvent.fire();
            }
        }

        public HashMap<HashId, StateRecord> isNeedToResync(boolean baseCheckPassed) {
            if (this.processingState.canContinue()) {
                HashMap<HashId, StateRecord> unknownParts = new HashMap<HashId, StateRecord>();
                HashMap<HashId, StateRecord> knownParts = new HashMap<HashId, StateRecord>();
                if (baseCheckPassed) {
                    for (Approvable ref : this.item.getReferencedItems()) {
                        HashId id = ref.getId();
                        StateRecord r = Node.this.ledger.getRecord(id);
                        if (r == null || !r.getState().isConsensusFound()) {
                            unknownParts.put(id, r);
                            continue;
                        }
                        knownParts.put(id, r);
                    }
                    for (Approvable a : this.item.getRevokingItems()) {
                        StateRecord r = Node.this.ledger.getRecord(a.getId());
                        if (r == null || !r.getState().isConsensusFound()) {
                            unknownParts.put(a.getId(), r);
                            continue;
                        }
                        knownParts.put(a.getId(), r);
                    }
                }
                boolean needToResync = false;
                if (unknownParts.size() + knownParts.size() > 0) {
                    boolean bl = needToResync = baseCheckPassed && unknownParts.size() > 0 && knownParts.size() >= Node.this.config.getKnownSubContractsToResync();
                }
                if (needToResync) {
                    return unknownParts;
                }
            }
            return new HashMap<HashId, StateRecord>();
        }

        private final void broadcastMyState() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: broadcastMyState, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                ParcelNotification.ParcelNotificationType notificationType = this.item.shouldBeTU() ? ParcelNotification.ParcelNotificationType.PAYMENT : ParcelNotification.ParcelNotificationType.PAYLOAD;
                ParcelNotification notification = new ParcelNotification(Node.this.myInfo, this.itemId, this.parcelId, this.getResult(), true, notificationType);
                Node.this.network.broadcast(Node.this.myInfo, notification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void pulseStartPolling() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: pulseStartPolling, state ", this.processingState}), 1);
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                Object object = this.mutex;
                synchronized (object) {
                    if (!this.processingState.isProcessedToConsensus() && this.poller == null) {
                        List<Integer> pollTimes = Node.this.config.getPollTime();
                        this.poller = new RunnableWithDynamicPeriod(() -> this.sendStartPollingNotification(), pollTimes, Node.this.executorService);
                        this.poller.run();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendStartPollingNotification() {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                Object object = this.mutex;
                synchronized (object) {
                    if (this.isPollingExpired()) {
                        this.processingState = ItemProcessingState.GOT_CONSENSUS;
                        this.stopPoller();
                        this.stopDownloader();
                        this.rollbackChanges(ItemState.UNDEFINED);
                        return;
                    }
                }
                ParcelNotification.ParcelNotificationType notificationType = this.item.shouldBeTU() ? ParcelNotification.ParcelNotificationType.PAYMENT : ParcelNotification.ParcelNotificationType.PAYLOAD;
                ParcelNotification notification = new ParcelNotification(Node.this.myInfo, this.itemId, this.parcelId, this.getResult(), true, notificationType);
                List<NodeInfo> nodes = Node.this.network.allNodes();
                for (NodeInfo node : nodes) {
                    if (this.positiveNodes.contains(node) || this.negativeNodes.contains(node)) continue;
                    Node.this.network.deliver(node, notification);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void vote(NodeInfo node, ItemState state) {
            if (this.processingState.canContinue()) {
                boolean positiveConsensus = false;
                boolean negativeConsensus = false;
                if (state.isPositive() && this.positiveNodes.contains(node) || !state.isPositive() && this.negativeNodes.contains(node)) {
                    return;
                }
                Object object = this.mutex;
                synchronized (object) {
                    Set<NodeInfo> remove;
                    Set<NodeInfo> add;
                    if (this.processingState.canRemoveSelf()) {
                        return;
                    }
                    if (state.isPositive()) {
                        add = this.positiveNodes;
                        remove = this.negativeNodes;
                    } else {
                        add = this.negativeNodes;
                        remove = this.positiveNodes;
                    }
                    add.add(node);
                    remove.remove(node);
                    ItemProcessingState stateWas = this.processingState;
                    if (this.processingState.isProcessedToConsensus()) {
                        if (this.processingState.isDone()) {
                            this.close();
                        }
                        return;
                    }
                    if (this.negativeNodes.size() >= Node.this.config.getNegativeConsensus()) {
                        negativeConsensus = true;
                        this.processingState = ItemProcessingState.GOT_CONSENSUS;
                    } else if (this.positiveNodes.size() >= Node.this.config.getPositiveConsensus()) {
                        positiveConsensus = true;
                        this.processingState = ItemProcessingState.GOT_CONSENSUS;
                    }
                    if (!this.processingState.isProcessedToConsensus()) {
                        return;
                    }
                }
                if (positiveConsensus) {
                    this.approveAndCommit();
                } else if (negativeConsensus) {
                    this.rollbackChanges(ItemState.DECLINED);
                } else {
                    throw new RuntimeException("error: consensus reported without consensus");
                }
            }
        }

        private final void approveAndCommit() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: approveAndCommit, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                this.setState(ItemState.APPROVED);
                Node.this.executorService.submit(() -> this.downloadAndCommit(), Node.this.toString() + this.toString() + " :: approveAndCommit -> downloadAndCommit");
            }
        }

        private void downloadAndCommitSubItemsOf(Approvable commitingItem) {
            if (this.processingState.canContinue()) {
                for (Approvable revokingItem : commitingItem.getRevokingItems()) {
                    try {
                        Node.this.itemLock.synchronize(revokingItem.getId(), lock -> {
                            StateRecord r = Node.this.ledger.findOrCreate(revokingItem.getId());
                            r.setState(ItemState.REVOKED);
                            r.setExpiresAt(ZonedDateTime.now().plus(Node.this.config.getRevokedItemExpiration()));
                            try {
                                r.save();
                            }
                            catch (Ledger.Failure failure) {
                                this.emergencyBreak();
                                return null;
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (Approvable newItem : commitingItem.getNewItems()) {
                    try {
                        Node.this.itemLock.synchronize(newItem.getId(), lock -> {
                            StateRecord r = Node.this.ledger.findOrCreate(newItem.getId());
                            r.setState(ItemState.APPROVED);
                            r.setExpiresAt(newItem.getExpiresAt());
                            try {
                                r.save();
                            }
                            catch (Ledger.Failure failure) {
                                this.emergencyBreak();
                                return null;
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Node.this.lowPrioExecutorService.schedule(() -> Node.this.checkSpecialItem(newItem), 100L, TimeUnit.MILLISECONDS);
                    this.downloadAndCommitSubItemsOf(newItem);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadAndCommit() {
            if (this.processingState.canContinue()) {
                try {
                    if (this.item == null) {
                        this.pollingExpiresAt = Instant.now().plus(Node.this.config.getMaxDownloadOnApproveTime());
                        this.downloadedEvent.await(this.getMillisLeft());
                    }
                    this.downloadAndCommitSubItemsOf(this.item);
                    Object object = this.mutex;
                    synchronized (object) {
                        this.lockedToCreate.clear();
                        this.lockedToRevoke.clear();
                        try {
                            this.record.save();
                        }
                        catch (Ledger.Failure failure) {
                            this.emergencyBreak();
                            return;
                        }
                        if (this.record.getState() != ItemState.APPROVED) {
                            log.e("record is not approved " + (Object)((Object)this.record.getState()), new Object[0]);
                        }
                    }
                    Node.this.lowPrioExecutorService.schedule(() -> Node.this.checkSpecialItem(this.item), 100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException e) {
                    this.setState(ItemState.UNDEFINED);
                    try {
                        Node.this.itemLock.synchronize(this.record.getId(), lock -> {
                            this.record.destroy();
                            return null;
                        });
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackChanges(ItemState newState) {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: rollbackChanges, state ", this.processingState}), 1);
            Object object = Node.this.ledgerRollbackLock;
            synchronized (object) {
                Node.this.ledger.transaction(() -> {
                    for (StateRecord stateRecord : this.lockedToRevoke) {
                        try {
                            Node.this.itemLock.synchronize(stateRecord.getId(), lock -> {
                                stateRecord.unlock().save();
                                return null;
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.lockedToRevoke.clear();
                    for (StateRecord stateRecord : this.lockedToCreate) {
                        try {
                            Node.this.itemLock.synchronize(stateRecord.getId(), lock -> {
                                stateRecord.unlock().save();
                                return null;
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.lockedToCreate.clear();
                    this.setState(newState);
                    ZonedDateTime expiration = ZonedDateTime.now().plus(newState == ItemState.REVOKED ? Node.this.config.getRevokedItemExpiration() : Node.this.config.getDeclinedItemExpiration());
                    this.record.setExpiresAt(expiration);
                    try {
                        Object object = this.mutex;
                        synchronized (object) {
                            this.record.save();
                        }
                    }
                    catch (Ledger.Failure failure) {
                        failure.printStackTrace();
                        log.e(failure.getMessage(), new Object[0]);
                    }
                    return null;
                });
                this.close();
            }
        }

        private void stopPoller() {
            if (this.poller != null) {
                this.poller.cancel(true);
            }
        }

        private boolean isPollingExpired() {
            return this.pollingExpiresAt.isBefore(Instant.now());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void pulseSendNewConsensus() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: pulseSendNewConsensus, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                this.processingState = ItemProcessingState.SENDING_CONSENSUS;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.consensusReceivedChecker == null) {
                        List<Integer> periodsMillis = Node.this.config.getConsensusReceivedCheckTime();
                        this.consensusReceivedChecker = new RunnableWithDynamicPeriod(() -> this.sendNewConsensusNotification(), periodsMillis, Node.this.executorService);
                        this.consensusReceivedChecker.run();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendNewConsensusNotification() {
            if (this.processingState.canContinue()) {
                if (this.processingState.isConsensusSentAndReceived()) {
                    return;
                }
                Object object = this.mutex;
                synchronized (object) {
                    if (this.isConsensusReceivedExpired()) {
                        this.processingState = ItemProcessingState.FINISHED;
                        this.stopConsensusReceivedChecker();
                        this.removeSelf();
                        return;
                    }
                }
                ParcelNotification.ParcelNotificationType notificationType = this.item.shouldBeTU() ? ParcelNotification.ParcelNotificationType.PAYMENT : ParcelNotification.ParcelNotificationType.PAYLOAD;
                ParcelNotification notification = new ParcelNotification(Node.this.myInfo, this.itemId, this.parcelId, this.getResult(), true, notificationType);
                List<NodeInfo> nodes = Node.this.network.allNodes();
                for (NodeInfo node : nodes) {
                    if (this.positiveNodes.contains(node) || this.negativeNodes.contains(node)) continue;
                    if (!Node.this.myInfo.equals(node)) {
                        Node.this.network.deliver(node, notification);
                        continue;
                    }
                    if (!this.processingState.isProcessedToConsensus()) continue;
                    this.vote(Node.this.myInfo, this.record.getState());
                }
            }
        }

        private final Boolean checkIfAllReceivedConsensus() {
            if (this.processingState.canContinue()) {
                List<NodeInfo> nodes = Node.this.network.allNodes();
                Boolean allReceived = nodes.size() <= this.positiveNodes.size() + this.negativeNodes.size();
                if (allReceived.booleanValue()) {
                    this.processingState = ItemProcessingState.FINISHED;
                    this.stopConsensusReceivedChecker();
                }
                return allReceived;
            }
            return true;
        }

        private boolean isConsensusReceivedExpired() {
            return this.consensusReceivedExpiresAt.isBefore(Instant.now());
        }

        private void stopConsensusReceivedChecker() {
            if (this.consensusReceivedChecker != null) {
                this.consensusReceivedChecker.cancel(true);
            }
        }

        public final void pulseResync() {
            this.pulseResync(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pulseResync(boolean resyncItself) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                this.resyncItselfOnly = resyncItself;
                if (resyncItself) {
                    this.addItemToResync(this.itemId, this.record);
                }
                if (!this.processingState.isProcessedToConsensus()) {
                    this.processingState = ItemProcessingState.RESYNCING;
                }
                this.pulseCheckIfItemsResynced();
                for (ResyncingItem ri : this.resyncingItems.values()) {
                    if (!ri.needsResyncVoteFrom(Node.this.myInfo)) continue;
                    if (ri.getItemState().isConsensusFound()) {
                        this.resyncVote(ri.getId(), Node.this.myInfo, ri.getItemState());
                        continue;
                    }
                    this.resyncVote(ri.getId(), Node.this.myInfo, ItemState.UNDEFINED);
                }
                Object object = this.mutex;
                synchronized (object) {
                    List<Integer> periodsMillis = Node.this.config.getResyncTime();
                    if (this.resyncer == null) {
                        this.resyncer = new RunnableWithDynamicPeriod(() -> this.sendResyncNotification(), periodsMillis, Node.this.executorService);
                        this.resyncer.run();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendResyncNotification() {
            if (this.processingState.canContinue()) {
                if (!this.processingState.isProcessedToConsensus()) {
                    Object object = this.mutex;
                    synchronized (object) {
                        if (this.processingState.isGotResyncedState()) {
                            return;
                        }
                        if (this.isResyncExpired()) {
                            this.processingState = ItemProcessingState.GOT_RESYNCED_STATE;
                            for (ResyncingItem ri : this.resyncingItems.values()) {
                                ri.closeByTimeout();
                            }
                            this.stopResync();
                            return;
                        }
                    }
                    Node.this.network.eachNode(node -> {
                        HashMap<HashId, ItemState> itemsToResync = new HashMap<HashId, ItemState>();
                        for (HashId hid : this.resyncingItems.keySet()) {
                            if (!this.resyncingItems.get(hid).needsResyncVoteFrom((NodeInfo)node)) continue;
                            itemsToResync.put(hid, this.resyncingItems.get(hid).getItemState().isConsensusFound() ? this.resyncingItems.get(hid).getItemState() : ItemState.UNDEFINED);
                        }
                        if (itemsToResync.size() > 0) {
                            ItemResyncNotification notification = new ItemResyncNotification(Node.this.myInfo, this.itemId, itemsToResync, true);
                            Node.this.network.deliver((NodeInfo)node, notification);
                        }
                    });
                } else {
                    this.stopResync();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void resyncVote(HashId hid, NodeInfo node, ItemState state) {
            if (this.processingState.canContinue()) {
                if (!this.processingState.isProcessedToConsensus()) {
                    Object object = this.resyncMutex;
                    synchronized (object) {
                        if (this.resyncingItems.containsKey(hid)) {
                            this.resyncingItems.get(hid).resyncVote(node, state);
                        }
                        boolean isResyncPollingFinished = true;
                        for (ResyncingItem ri : this.resyncingItems.values()) {
                            if (ri.isResyncPollingFinished()) continue;
                            isResyncPollingFinished = false;
                            break;
                        }
                        if (isResyncPollingFinished) {
                            this.processingState = ItemProcessingState.GOT_RESYNCED_STATE;
                            this.stopResync();
                        }
                    }
                } else {
                    this.stopResync();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void pulseCheckIfItemsResynced() {
            if (this.processingState.canContinue()) {
                Object object = this.resyncMutex;
                synchronized (object) {
                    for (HashId hid : this.resyncingItems.keySet()) {
                        this.resyncingItems.get(hid).finishEvent.addConsumer(i -> this.onResyncItemFinished((ResyncingItem)i));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onResyncItemFinished(ResyncingItem ri) {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                int numFinished = 0;
                Object object = this.resyncMutex;
                synchronized (object) {
                    for (ResyncingItem rit : this.resyncingItems.values()) {
                        if (!rit.isCommitFinished()) continue;
                        ++numFinished;
                    }
                }
                if (this.resyncingItems.size() == numFinished && this.processingState.isGotResyncedState()) {
                    if (!this.processingState.isProcessedToConsensus()) {
                        this.processingState = ItemProcessingState.CHECKING;
                    }
                    if (this.resyncItselfOnly) {
                        if (this.itemId.equals(ri.hashId) && ri.getResyncingState() == ResyncingItemProcessingState.COMMIT_FAILED) {
                            this.rollbackChanges(this.stateWas);
                            Node.this.executorService.schedule(() -> Node.this.itemSanitationFailed(ri.record), 0L, TimeUnit.SECONDS);
                            return;
                        }
                        this.processingState = ItemProcessingState.FINISHED;
                        this.close();
                        Node.this.executorService.schedule(() -> Node.this.itemSanitationDone(ri.record), 0L, TimeUnit.SECONDS);
                    } else {
                        try {
                            this.checkSubItems();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.commitCheckedAndStartPolling();
                    }
                }
            }
        }

        private boolean isResyncExpired() {
            return this.resyncExpiresAt.isBefore(Instant.now());
        }

        private void stopResync() {
            if (this.resyncer != null) {
                this.resyncer.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addItemToResync(HashId hid, StateRecord record) {
            if (this.processingState.canContinue()) {
                try {
                    Object object = this.resyncMutex;
                    synchronized (object) {
                        if (!this.resyncingItems.containsKey(hid)) {
                            this.resyncingItems.put(hid, new ResyncingItem(hid, record));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private long getMillisLeft() {
            return this.pollingExpiresAt.toEpochMilli() - Instant.now().toEpochMilli();
        }

        private void forceChecking(boolean isCheckingForce) {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: forceChecking, state ", this.processingState}), 1);
            this.isCheckingForce = isCheckingForce;
            if (this.processingState.canContinue() && this.processingState == ItemProcessingState.DOWNLOADED) {
                Node.this.executorService.submit(() -> this.checkItem(), Node.this.toString() + this.toString() + " :: forceChecking -> checkItem");
            }
        }

        private void close() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: close, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                this.processingState = ItemProcessingState.DONE;
            }
            this.stopPoller();
            this.downloadedEvent.fire();
            this.pollingReadyEvent.fire();
            this.doneEvent.fire();
            if (this.processingState.canContinue()) {
                if (!this.resyncItselfOnly) {
                    this.checkIfAllReceivedConsensus();
                    if (this.processingState == ItemProcessingState.DONE) {
                        this.pulseSendNewConsensus();
                    } else {
                        this.removeSelf();
                    }
                } else {
                    this.processingState = ItemProcessingState.FINISHED;
                    this.removeSelf();
                }
            } else {
                this.removeSelf();
            }
        }

        private void emergencyBreak() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: emergencyBreak, state ", this.processingState}), 1);
            this.processingState = ItemProcessingState.EMERGENCY_BREAK;
            this.stopDownloader();
            this.stopPoller();
            this.stopConsensusReceivedChecker();
            this.stopResync();
            for (ResyncingItem ri : this.resyncingItems.values()) {
                if (ri.isCommitFinished()) continue;
                ri.closeByTimeout();
            }
            this.rollbackChanges(this.stateWas);
            this.processingState = ItemProcessingState.FINISHED;
        }

        private ItemState getState() {
            return this.record.getState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setState(ItemState newState) {
            Object object = this.mutex;
            synchronized (object) {
                this.record.setState(newState);
            }
        }

        private final void removeSelf() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"item processor for item: ", this.itemId, " from parcel: ", this.parcelId, " :: removeSelf, state ", this.processingState}), 1);
            if (this.processingState.canRemoveSelf()) {
                this.forceRemoveSelf();
            }
        }

        private void forceRemoveSelf() {
            Node.this.processors.remove(this.itemId);
            this.stopDownloader();
            this.stopPoller();
            this.stopConsensusReceivedChecker();
            this.stopResync();
            this.downloadedEvent.fire();
            this.pollingReadyEvent.fire();
            this.doneEvent.fire();
            this.removedEvent.fire();
        }

        public @NonNull ItemResult getResult() {
            return new ItemResult(this.record, this.item != null);
        }

        private final boolean needsVoteFrom(NodeInfo node) {
            return this.record.getState().isPending() && !this.positiveNodes.contains(node) && !this.negativeNodes.contains(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addToSources(NodeInfo node) {
            if (this.item != null) {
                return;
            }
            Set<NodeInfo> set = this.sources;
            synchronized (set) {
                if (this.sources.add(node)) {
                    this.pulseDownload();
                }
            }
        }

        private boolean isDone() {
            return this.processingState.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T lock(Supplier<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return c.get();
            }
        }

        public String toString() {
            return "ip -> parcel: " + this.parcelId + ", item: " + this.itemId + ", processing state: " + (Object)((Object)this.processingState);
        }
    }

    private class ParcelProcessor {
        private final HashId parcelId;
        private Parcel parcel;
        private Contract payment;
        private Contract payload;
        private ItemProcessor paymentProcessor;
        private ItemProcessor payloadProcessor;
        private ItemResult paymentResult = null;
        private ItemResult payloadResult = null;
        private Set<NodeInfo> sources = new HashSet<NodeInfo>();
        private HashMap<NodeInfo, ItemState> paymentDelayedVotes = new HashMap();
        private HashMap<NodeInfo, ItemState> payloadDelayedVotes = new HashMap();
        private ParcelProcessingState processingState;
        private final Object mutex;
        private ScheduledFuture<?> downloader;
        private ScheduledFuture<?> processSchedule;
        private final AsyncEvent<Void> downloadedEvent = new AsyncEvent();
        private final AsyncEvent<Void> doneEvent = new AsyncEvent();

        public ParcelProcessor(HashId parcelId, Parcel parcel, Object lock) {
            this.mutex = lock;
            this.parcelId = parcelId;
            this.parcel = parcel;
            if (parcel == null) {
                parcel = Node.this.parcelCache.get(parcelId);
            }
            this.parcel = parcel;
            if (parcel != null) {
                this.payment = parcel.getPaymentContract();
                this.payload = parcel.getPayloadContract();
            }
            this.processingState = ParcelProcessingState.INIT;
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage("parcel processor for: ", parcelId, " created"), 1);
            if (this.parcel != null) {
                Node.this.executorService.submit(() -> this.parcelDownloaded(), Node.this.toString() + " pp > parcel " + parcelId + " :: ParcelProcessor -> parcelDownloaded");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pulseProcessing() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: pulseProcessing, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                Object object = this.mutex;
                synchronized (object) {
                    if (this.processSchedule == null || this.processSchedule.isDone()) {
                        this.processSchedule = (ScheduledFuture)Node.this.executorService.submit(() -> this.process(), Node.this.toString() + " pp > parcel " + this.parcelId + " :: pulseProcessing -> process");
                    }
                }
            }
        }

        private void process() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: process, payment ", this.payment.getId(), ", payload ", this.payload.getId(), ", state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                this.processingState = ParcelProcessingState.PREPARING;
                try {
                    Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: check payment, state ", this.processingState}), 1);
                    if (this.paymentResult == null) {
                        this.processingState = ParcelProcessingState.PAYMENT_CHECKING;
                        for (NodeInfo ni : this.paymentDelayedVotes.keySet()) {
                            this.paymentProcessor.vote(ni, this.paymentDelayedVotes.get(ni));
                        }
                        this.paymentDelayedVotes.clear();
                        this.processingState = ParcelProcessingState.PAYMENT_POLLING;
                        if (!this.paymentProcessor.isDone()) {
                            this.paymentProcessor.doneEvent.await();
                        }
                        this.paymentResult = this.paymentProcessor.getResult();
                    }
                    Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payment checked, state ", this.processingState}), 1);
                    if (this.paymentResult.state.isApproved()) {
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: check payload, state ", this.processingState}), 1);
                        if (this.payloadResult == null) {
                            this.processingState = ParcelProcessingState.PAYLOAD_CHECKING;
                            this.payload.getQuantiser().reset(this.parcel.getQuantasLimit());
                            this.payloadProcessor.forceChecking(true);
                            for (NodeInfo ni : this.payloadDelayedVotes.keySet()) {
                                this.payloadProcessor.vote(ni, this.payloadDelayedVotes.get(ni));
                            }
                            this.payloadDelayedVotes.clear();
                            this.processingState = ParcelProcessingState.PAYLOAD_POLLING;
                            if (!this.payloadProcessor.isDone()) {
                                this.payloadProcessor.doneEvent.await();
                            }
                            this.payloadResult = this.payloadProcessor.getResult();
                        }
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payload checked, state ", this.processingState}), 1);
                    } else {
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payment was not approved: ", this.paymentResult.state, ", state ", this.processingState}), 1);
                        if (this.payloadProcessor != null) {
                            this.payloadProcessor.emergencyBreak();
                            this.payloadProcessor.doneEvent.await();
                        }
                    }
                    this.processingState = ParcelProcessingState.FINISHED;
                    Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: processing finished, state ", this.processingState}), 1);
                    this.doneEvent.fire();
                    if (this.paymentProcessor != null && this.paymentProcessor.processingState != ItemProcessingState.FINISHED) {
                        this.paymentProcessor.removedEvent.await();
                    }
                    if (this.payloadProcessor != null && this.payloadProcessor.processingState != ItemProcessingState.FINISHED) {
                        this.payloadProcessor.removedEvent.await();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.processingState = ParcelProcessingState.FINISHED;
                    this.doneEvent.fire();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.processingState = ParcelProcessingState.FINISHED;
                    this.doneEvent.fire();
                }
                this.removeSelf();
            }
        }

        private void stopProcesser() {
            if (this.processSchedule != null) {
                this.processSchedule.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pulseDownload() {
            if (this.processingState.canContinue() && !this.processingState.isProcessedToConsensus()) {
                this.processingState = ParcelProcessingState.DOWNLOADING;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.parcel == null && (this.downloader == null || this.downloader.isDone())) {
                        this.downloader = (ScheduledFuture)Node.this.executorService.submit(() -> this.download(), Node.this.toString() + " > parcel " + this.parcelId + " :: parcel pulseDownload -> download");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download() {
            if (this.processingState.canContinue()) {
                int retryCounter = Node.this.config.getGetItemRetryCount();
                while (!this.isPayloadPollingExpired() && this.parcel == null) {
                    if (this.sources.isEmpty()) {
                        return;
                    }
                    try {
                        NodeInfo source;
                        Set<NodeInfo> set = this.sources;
                        synchronized (set) {
                            source = (NodeInfo)Do.sample(this.sources);
                        }
                        this.parcel = Node.this.network.getParcel(this.parcelId, source, Node.this.config.getMaxGetItemTime());
                        if (this.parcel != null) {
                            this.parcelDownloaded();
                            return;
                        }
                        Thread.sleep(1000L);
                        --retryCounter;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (retryCounter > 0) continue;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void parcelDownloaded() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: parcelDownloaded, state ", this.processingState}), 1);
            if (this.processingState.canContinue()) {
                Object object = Node.this.parcelCache;
                synchronized (object) {
                    Node.this.parcelCache.put(this.parcel);
                }
                this.payment = this.parcel.getPaymentContract();
                this.payload = this.parcel.getPayloadContract();
                object = this.mutex;
                synchronized (object) {
                    Object x = Node.this.checkItemInternal(this.payment.getId(), this.parcelId, this.payment, true, true);
                    if (x instanceof ItemProcessor) {
                        this.paymentProcessor = (ItemProcessor)x;
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payment is processing, item processing state: ", this.paymentProcessor.processingState, ", parcel processing state ", this.processingState, ", item state ", this.paymentProcessor.getState()}), 1);
                        if (!this.parcelId.equals(this.paymentProcessor.parcelId)) {
                            this.paymentResult = ItemResult.UNDEFINED;
                        }
                    } else {
                        this.paymentResult = (ItemResult)x;
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payment already processed, parcel processing state ", this.processingState, ", item state ", this.paymentResult.state}), 1);
                        if (this.paymentResult.state == ItemState.APPROVED) {
                            this.paymentResult = ItemResult.UNDEFINED;
                        }
                    }
                    if ((x = Node.this.checkItemInternal(this.payload.getId(), this.parcelId, this.payload, true, false)) instanceof ItemProcessor) {
                        this.payloadProcessor = (ItemProcessor)x;
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payload is processing, item processing state: ", this.payloadProcessor.processingState, ", parcel processing state ", this.processingState, ", item state ", this.payloadProcessor.getState()}), 1);
                    } else {
                        this.payloadResult = (ItemResult)x;
                        Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: payload already processed, parcel processing state ", this.processingState, ", item state ", this.payloadResult.state}), 1);
                    }
                }
                this.pulseProcessing();
                this.downloadedEvent.fire();
            }
        }

        private void stopDownloader() {
            if (this.downloader != null) {
                this.downloader.cancel(true);
            }
        }

        private final void vote(NodeInfo node, ItemState state, boolean isTU) {
            if (this.processingState.canContinue()) {
                if (isTU) {
                    if (this.paymentProcessor != null) {
                        this.paymentProcessor.vote(node, state);
                    } else {
                        this.paymentDelayedVotes.put(node, state);
                    }
                } else if (this.payloadProcessor != null) {
                    this.payloadProcessor.vote(node, state);
                } else {
                    this.payloadDelayedVotes.put(node, state);
                }
            }
        }

        public ItemResult getPayloadResult() {
            if (this.payloadResult != null) {
                return this.payloadResult;
            }
            if (this.payloadProcessor != null) {
                return this.payloadProcessor.getResult();
            }
            return ItemResult.UNDEFINED;
        }

        private ItemState getPayloadState() {
            if (this.payloadResult != null) {
                return this.payloadResult.state;
            }
            if (this.payloadProcessor != null) {
                return this.payloadProcessor.getState();
            }
            return ItemState.PENDING;
        }

        public ItemResult getPaymentResult() {
            if (this.paymentResult != null) {
                return this.paymentResult;
            }
            if (this.paymentProcessor != null) {
                return this.paymentProcessor.getResult();
            }
            return ItemResult.UNDEFINED;
        }

        private ItemState getPaymentState() {
            if (this.paymentResult != null) {
                return this.paymentResult.state;
            }
            if (this.paymentProcessor != null) {
                return this.paymentProcessor.getState();
            }
            return ItemState.PENDING;
        }

        private ItemProcessingState getPaymentProcessingState() {
            if (this.paymentProcessor != null) {
                return this.paymentProcessor.processingState;
            }
            return ItemProcessingState.NOT_EXIST;
        }

        private ItemProcessingState getPayloadProcessingState() {
            if (this.payloadProcessor != null) {
                return this.payloadProcessor.processingState;
            }
            return ItemProcessingState.NOT_EXIST;
        }

        private final boolean needsPayloadVoteFrom(NodeInfo node) {
            if (this.payloadProcessor != null) {
                return this.payloadProcessor.needsVoteFrom(node);
            }
            return false;
        }

        private final boolean needsPaymentVoteFrom(NodeInfo node) {
            if (this.paymentProcessor != null) {
                return this.paymentProcessor.needsVoteFrom(node);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addToSources(NodeInfo node) {
            if (this.parcel != null) {
                return;
            }
            Set<NodeInfo> set = this.sources;
            synchronized (set) {
                if (this.sources.add(node)) {
                    this.pulseDownload();
                }
            }
        }

        private final void removeSelf() {
            Node.this.report(Node.this.getLabel(), () -> Node.this.concatReportMessage(new Object[]{"parcel processor for: ", this.parcelId, " :: removeSelf, state ", this.processingState}), 1);
            if (this.processingState.canRemoveSelf()) {
                Node.this.parcelProcessors.remove(this.parcelId);
                this.stopDownloader();
                this.stopProcesser();
                this.doneEvent.fire();
            }
        }

        private boolean isPayloadPollingExpired() {
            if (this.payloadProcessor != null) {
                return this.payloadProcessor.isPollingExpired();
            }
            return false;
        }

        private boolean isDone() {
            return this.processingState == ParcelProcessingState.FINISHED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T lock(Supplier<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return c.get();
            }
        }
    }
}

