/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.PublicKey;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.yaml.snakeyaml.Yaml;

public class NodeInfo
implements BiSerializable {
    private PublicKey publicKey;
    private InetSocketAddress nodeAddress;
    private InetSocketAddress clientAddress;
    private InetSocketAddress serverAddress;
    private int number;
    private String nodeName;
    private String publicHost;

    public NodeInfo() {
    }

    public NodeInfo(@NonNull PublicKey publicKey, int number, @NonNull String nodeName, @NonNull String host, int datagramPort, int clientHttpPort, int serverHttpPort) {
        this(publicKey, number, nodeName, host, host, datagramPort, clientHttpPort, serverHttpPort);
    }

    public String getPublicHost() {
        return this.publicHost;
    }

    public NodeInfo(@NonNull PublicKey publicKey, int number, @NonNull String nodeName, @NonNull String host, String publicHost, int datagramPort, int clientHttpPort, int serverHttpPort) {
        assert (number >= 0);
        assert (datagramPort > 0);
        assert (clientHttpPort > 0);
        this.publicKey = publicKey;
        this.number = number;
        this.nodeName = nodeName;
        this.publicHost = publicHost;
        this.nodeAddress = new InetSocketAddress(host, datagramPort);
        this.clientAddress = new InetSocketAddress(publicHost, clientHttpPort);
        this.serverAddress = new InetSocketAddress(host, serverHttpPort);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public InetSocketAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public InetSocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.nodeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return this.number == nodeInfo.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "NI(" + this.number + ")";
    }

    public static NodeInfo loadYaml(Path fileName) {
        try {
            Yaml yaml = new Yaml();
            Binder b = Binder.from(yaml.load(new FileInputStream(fileName.toString())));
            int count = fileName.getNameCount();
            String n = fileName.getName(count - 1).toString();
            n = n.substring(0, n.length() - 5) + ".public.unikey";
            String keyPath = "/" + fileName.subpath(0, count - 2) + "/keys/" + n;
            System.out.println("expected key file path: <" + keyPath + ">");
            PublicKey key = new PublicKey(Do.read(keyPath));
            return new NodeInfo(key, b.getIntOrThrow("node_number"), b.getStringOrThrow("node_name"), (String)b.getListOrThrow("ip").get(0), b.getStringOrThrow("public_host"), b.getIntOrThrow("udp_server_port"), b.getIntOrThrow("http_client_port"), b.getIntOrThrow("http_server_port"));
        }
        catch (Exception e) {
            System.err.println("failed to load node: " + fileName + ": " + e);
            e.printStackTrace();
            return null;
        }
    }

    public String publicUrlString() {
        return this.publicHost.equals("localhost") ? "http://localhost:" + this.clientAddress.getPort() : "http://" + this.publicHost + ":8080";
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        this.publicKey = (PublicKey)deserializer.deserialize(data.getBinderOrThrow("publicKey"));
        this.publicHost = data.getStringOrThrow("publicHost");
        String host = data.getStringOrThrow("host");
        this.nodeAddress = new InetSocketAddress(host, data.getIntOrThrow("udpPort"));
        this.clientAddress = new InetSocketAddress(host, data.getIntOrThrow("clientPort"));
        this.serverAddress = new InetSocketAddress(host, data.getIntOrThrow("serverPort"));
        this.nodeName = data.getStringOrThrow("name");
        this.number = data.getIntOrThrow("number");
    }

    @Override
    public Binder serialize(BiSerializer serializer) {
        return Binder.of("publicKey", serializer.serialize(this.publicKey), new Object[]{"publicHost", this.publicHost, "host", this.clientAddress.getHostName(), "clientPort", this.clientAddress.getPort(), "serverPort", this.serverAddress.getPort(), "udpPort", this.nodeAddress.getPort(), "name", this.nodeName, "number", this.number});
    }

    public String internalUrlString() {
        return "http://" + this.clientAddress.getHostName() + ":" + this.clientAddress.getPort();
    }

    public static NodeInfo initFrom(ResultSet rs) throws SQLException, EncryptionError {
        return new NodeInfo(new PublicKey(rs.getBytes("public_key")), rs.getInt("node_number"), rs.getString("node_name"), rs.getString("host"), rs.getString("public_host"), rs.getInt("udp_server_port"), rs.getInt("http_client_port"), rs.getInt("http_server_port"));
    }

    static {
        DefaultBiMapper.registerClass(NodeInfo.class);
    }
}

