/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.node2.ItemNotification;
import com.icodici.universa.node2.ItemResyncNotification;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.ParcelNotification;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sergeych.boss.Boss;

public abstract class Notification {
    private transient NodeInfo from;
    private static Map<Integer, Class<? extends Notification>> classes = new HashMap<Integer, Class<? extends Notification>>();

    protected Notification() {
    }

    public NodeInfo getFrom() {
        return this.from;
    }

    public Notification(NodeInfo from) {
        this.from = from;
    }

    protected abstract void writeTo(Boss.Writer var1) throws IOException;

    protected abstract void readFrom(Boss.Reader var1) throws IOException;

    protected abstract int getTypeCode();

    protected static void registerClass(int code, Class<? extends Notification> klass) {
        classes.put(code, klass);
    }

    static byte[] pack(Collection<Notification> notifications) {
        Boss.Writer writer = new Boss.Writer();
        try {
            for (Notification n : notifications) {
                Notification.write(writer, n);
            }
            return writer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to pack notification", e);
        }
    }

    public static void write(Boss.Writer writer, Notification n) throws IOException {
        writer.write(n.getTypeCode());
        n.writeTo(writer);
    }

    static List<Notification> unpack(NodeInfo from, byte[] packed) throws IOException {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Boss.Reader r = new Boss.Reader(packed);
        try {
            while (true) {
                Notification n;
                if ((n = Notification.read(from, r)) == null) {
                    continue;
                }
                notifications.add(n);
            }
        }
        catch (EOFException n) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new IOException("Failed to decoded notification", e);
        }
        return notifications;
    }

    public static Notification read(NodeInfo from, Boss.Reader r) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int code = r.readInt();
        Class<? extends Notification> nclass = classes.get(code);
        if (nclass != null) {
            Constructor<? extends Notification> c = nclass.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Notification n = c.newInstance(new Object[0]);
            n.readFrom(r);
            n.from = from;
            return n;
        }
        System.out.println("*** unknown notification class code: " + code);
        return null;
    }

    static {
        ItemNotification.init();
        ParcelNotification.init();
        ItemResyncNotification.init();
    }
}

