/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.HashId;
import com.icodici.universa.contract.Parcel;
import java.time.Duration;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.sergeych.utils.Base64;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ParcelCache {
    private final Timer cleanerTimer = new Timer();
    private final Duration maxAge;
    private ConcurrentHashMap<HashId, Record> records = new ConcurrentHashMap();

    public ParcelCache(Duration maxAge) {
        this.maxAge = maxAge;
        this.cleanerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ParcelCache.this.cleanUp();
            }
        }, 5000L, 5000L);
    }

    final void cleanUp() {
        Instant now = Instant.now();
        this.records.values().forEach(r -> ((Record)r).checkExpiration(now));
    }

    public void shutdown() {
        this.cleanerTimer.cancel();
        this.cleanerTimer.purge();
    }

    public @Nullable Parcel get(HashId itemId) {
        Record i = this.records.get(itemId);
        if (i != null && i.parcel == null) {
            throw new RuntimeException("cache: record with empty item");
        }
        return i != null ? i.parcel : null;
    }

    public void put(Parcel parcel) {
        new Record(parcel);
    }

    public void idsCheck(HashId itemId) {
        for (HashId x : this.records.keySet()) {
            System.out.println(" checking " + itemId + " eq " + x + ": " + itemId.equals(x) + " / " + x.equals(itemId));
            System.out.println(" codes: " + itemId.hashCode() + " / " + x.hashCode());
            System.out.println(" digest check: " + Base64.encodeString(itemId.getDigest()));
            System.out.println(" digest data : " + Base64.encodeString(x.getDigest()));
        }
    }

    public int size() {
        return this.records.size();
    }

    private class Record {
        private Instant expiresAt;
        private Parcel parcel;

        private Record(Parcel parcel) {
            this.expiresAt = Instant.now().plus(ParcelCache.this.maxAge);
            this.parcel = parcel;
            ParcelCache.this.records.put(parcel.getId(), this);
        }

        private void checkExpiration(Instant now) {
            if (this.expiresAt.isBefore(now)) {
                ParcelCache.this.records.remove(this.parcel.getId());
            }
        }
    }
}

