/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.HashId;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.ItemNotification;
import com.icodici.universa.node2.NodeInfo;
import java.io.IOException;
import net.sergeych.boss.Boss;

public class ParcelNotification
extends ItemNotification {
    private static final int CODE_PARCEL_NOTIFICATION = 2;
    private HashId parcelId;
    private ParcelNotificationType type = ParcelNotificationType.PAYLOAD;

    public HashId getParcelId() {
        return this.parcelId;
    }

    public ParcelNotificationType getType() {
        return this.type;
    }

    public ParcelNotification(NodeInfo from, HashId itemId, HashId parcelId, ItemResult itemResult, boolean requestResult, ParcelNotificationType type) {
        super(from, itemId, itemResult, requestResult);
        this.parcelId = parcelId;
        this.type = type;
    }

    protected ParcelNotification() {
    }

    @Override
    protected void writeTo(Boss.Writer bw) throws IOException {
        super.writeTo(bw);
        bw.writeObject(this.type.ordinal());
        if (this.parcelId != null) {
            bw.writeObject(this.parcelId.getDigest());
        }
    }

    @Override
    protected void readFrom(Boss.Reader br) throws IOException {
        super.readFrom(br);
        this.type = ParcelNotificationType.values()[br.readInt()];
        try {
            byte[] parcelBytes = br.readBinary();
            if (parcelBytes != null) {
                this.parcelId = HashId.withDigest(parcelBytes);
            }
        }
        catch (IOException e) {
            this.parcelId = null;
        }
    }

    @Override
    protected int getTypeCode() {
        return 2;
    }

    @Override
    public String toString() {
        return "[ParcelNotification from: " + this.getFrom() + " for parcel: " + this.parcelId + " and item: " + this.getItemId() + ", type is: " + (Object)((Object)this.type) + ", is answer requested: " + this.answerIsRequested() + "]";
    }

    public static void init() {
        ParcelNotification.registerClass(2, ParcelNotification.class);
    }

    public static enum ParcelNotificationType {
        PAYMENT,
        PAYLOAD;


        public boolean isTU() {
            return this == PAYMENT;
        }
    }
}

