/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2;

import com.icodici.universa.node2.Config;
import java.io.IOException;

public class Quantiser {
    private int quantaSum_ = 0;
    private int quantaLimit_ = -1;
    private boolean isCalculationFinished_ = false;
    public static int quantaPerUTN = Config.quantiser_quantaPerUTN;

    public void reset(int newLimit) {
        this.quantaSum_ = 0;
        this.quantaLimit_ = newLimit;
        this.isCalculationFinished_ = false;
    }

    public void resetNoLimit() {
        this.reset(-1);
    }

    public void addWorkCost(QuantiserProcesses process) throws QuantiserException {
        this.quantaSum_ += process.getCost();
        if (this.quantaLimit_ >= 0 && this.quantaSum_ > this.quantaLimit_) {
            throw new QuantiserException();
        }
    }

    public void addWorkCostFrom(Quantiser quantiser) throws QuantiserException {
        this.quantaSum_ += quantiser.getQuantaSum();
        if (this.quantaLimit_ >= 0 && this.quantaSum_ > this.quantaLimit_) {
            throw new QuantiserException();
        }
    }

    public int getQuantaSum() {
        return this.quantaSum_;
    }

    public int getQuantaLimit() {
        return this.quantaLimit_;
    }

    public boolean isCalculationFinished() {
        return this.isCalculationFinished_;
    }

    public void finishCalculation() {
        this.isCalculationFinished_ = true;
    }

    public class QuantiserException
    extends IOException {
    }

    public static enum QuantiserProcesses {
        PRICE_CHECK_2048_SIG,
        PRICE_CHECK_4096_SIG,
        PRICE_APPLICABLE_PERM,
        PRICE_SPLITJOIN_PERM,
        PRICE_REVOKE_VERSION,
        PRICE_REGISTER_VERSION,
        PRICE_CHECK_REFERENCED_VERSION;


        public int getCost() {
            switch (this) {
                case PRICE_CHECK_2048_SIG: {
                    return 1;
                }
                case PRICE_CHECK_4096_SIG: {
                    return 8;
                }
                case PRICE_APPLICABLE_PERM: {
                    return 1;
                }
                case PRICE_SPLITJOIN_PERM: {
                    return 2;
                }
                case PRICE_REGISTER_VERSION: {
                    return 20;
                }
                case PRICE_REVOKE_VERSION: {
                    return 20;
                }
                case PRICE_CHECK_REFERENCED_VERSION: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

