/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.HashType;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.network.BasicHttpClientSession;
import com.icodici.universa.node2.network.CommandFailedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.LogPrinter;
import net.sergeych.utils.Ut;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BasicHttpClient {
    private static final int DEFAULT_RECONNECT_TIMES = 3;
    private static final int CONNECTION_READ_TIMEOUT = 5000;
    private static final int CONNECTION_TIMEOUT = 2000;
    private static LogPrinter log = new LogPrinter("HTCL");
    private String url;
    protected BasicHttpClientSession session;
    int nodeNumber = -1;

    public BasicHttpClient(String rootUrlString) {
        this.url = rootUrlString;
    }

    public String getConnectMessage() {
        if (this.session != null) {
            return this.session.getConnectMessage();
        }
        throw new IllegalStateException("Session does not exist. Start BasicHttpClient for create session.");
    }

    public BasicHttpClientSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        throw new IllegalStateException("Session does not exist. Start BasicHttpClient for create session.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicHttpClientSession start(PrivateKey privateKey, PublicKey nodePublicKey, BasicHttpClientSession session) throws IOException {
        BasicHttpClient basicHttpClient = this;
        synchronized (basicHttpClient) {
            if (session != null) {
                this.session = session;
                this.session.setNodePublicKey(nodePublicKey);
                this.session.setPrivateKey(privateKey);
                Binder result = this.command("hello", new Object[0]);
                this.session.setConnectMessage(result.getStringOrThrow("message"));
                if (!result.getStringOrThrow("status").equals("OK")) {
                    throw new ConnectionFailedException("" + result);
                }
            } else {
                this.session = new BasicHttpClientSession();
                this.session.setNodePublicKey(nodePublicKey);
                this.session.setPrivateKey(privateKey);
                Answer a = this.requestOrThrow("connect", "client_key", privateKey.getPublicKey().pack());
                this.session.setSessionId(a.data.getLongOrThrow("session_id"));
                byte[] server_nonce = a.data.getBinaryOrThrow("server_nonce");
                byte[] client_nonce = Do.randomBytes(47);
                byte[] data = Boss.pack(Binder.fromKeysValues("client_nonce", client_nonce, "server_nonce", server_nonce));
                a = this.requestOrThrow("get_token", "signature", privateKey.sign(data, HashType.SHA512), "data", data, "session_id", this.session.getSessionId());
                data = a.data.getBinaryOrThrow("data");
                if (!nodePublicKey.verify(data, a.data.getBinaryOrThrow("signature"), HashType.SHA512)) {
                    throw new IOException("node signature failed");
                }
                Binder params = Boss.unpack(data);
                if (!Arrays.equals(client_nonce, params.getBinaryOrThrow("client_nonce"))) {
                    throw new IOException("client nonce mismatch");
                }
                byte[] key = Boss.unpack(privateKey.decrypt(params.getBinaryOrThrow("encrypted_token"))).getBinaryOrThrow("sk");
                this.session.setSessionKey(new SymmetricKey(key));
                Binder result = this.command("hello", new Object[0]);
                this.session.setConnectMessage(result.getStringOrThrow("message"));
                if (!result.getStringOrThrow("status").equals("OK")) {
                    throw new ConnectionFailedException("" + result);
                }
            }
            return this.session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() throws IOException {
        BasicHttpClient basicHttpClient = this;
        synchronized (basicHttpClient) {
            System.err.println("RESTART");
            PrivateKey privateKey = this.session.getPrivateKey();
            PublicKey nodePublicKey = this.session.getNodePublicKey();
            this.session = null;
            this.start(privateKey, nodePublicKey, null);
        }
    }

    public boolean ping() {
        try {
            return this.command("sping", new Object[0]).getStringOrThrow("sping").equals("spong");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Binder command(String name, Binder params) throws IOException {
        BasicHttpClient basicHttpClient = this;
        synchronized (basicHttpClient) {
            if (this.session == null || this.session.getSessionKey() == null) {
                throw new IllegalStateException("Session does not created or session key is not got yet.");
            }
            Binder call = Binder.fromKeysValues("command", name, "params", params);
            for (int i = 0; i < 3; ++i) {
                ErrorRecord er = null;
                try {
                    Answer a = this.requestOrThrow("command", "command", "command", "params", this.session.getSessionKey().encrypt(Boss.pack(call)), "session_id", this.session.getSessionId());
                    Binder data = Boss.unpack(this.session.getSessionKey().decrypt(a.data.getBinaryOrThrow("result")));
                    Binder result = data.getBinder("result", null);
                    if (result != null) {
                        return result;
                    }
                    System.out.println("result: " + result);
                    er = (ErrorRecord)data.get("error");
                    if (er == null) {
                        er = new ErrorRecord(Errors.FAILURE, "", "unprocessablereply");
                    }
                }
                catch (EndpointException e) {
                    ErrorRecord r = e.getFirstError();
                    if (r.getError() == Errors.COMMAND_FAILED) {
                        throw e;
                    }
                    System.err.println(r);
                }
                catch (SocketTimeoutException e) {
                    System.err.println("Socket timeout while executing command " + name);
                    log.d("Socket timeout while executing command " + name + ": " + e);
                }
                catch (ConnectException e) {
                    System.err.println("Connection refused while executing command " + name);
                    log.d("Connection refused while executing command " + name + ": " + e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.d("error executing command " + name + ": " + e);
                }
                if (er != null) {
                    throw new CommandFailedException(er);
                }
                log.d("repeating command " + name + ", attempt " + (i + 1));
                try {
                    Thread.sleep(i * 3 * 100);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.restart();
            }
            throw new IOException("Failed to execute command " + name);
        }
    }

    public Binder command(String name, Object ... keysValues) throws IOException {
        return this.command(name, Binder.fromKeysValues(keysValues));
    }

    private Answer requestOrThrow(String connect, Object ... params) throws IOException {
        Answer answer = this.request(connect, params);
        if (answer.code >= 400 || answer.data.containsKey("errors")) {
            throw new EndpointException(answer);
        }
        return answer;
    }

    public String getUrl() {
        return this.url;
    }

    public Answer request(String path, Object ... keysValues) throws IOException {
        return this.request(path, Binder.fromKeysValues(keysValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer request(String path, Binder params) throws IOException {
        BasicHttpClient basicHttpClient = this;
        synchronized (basicHttpClient) {
            String charset = "UTF-8";
            byte[] data = Boss.pack(params);
            String boundary = "==boundary==" + Ut.randomString(48);
            String CRLF = "\r\n";
            URLConnection connection = new URL(this.url + "/" + path).openConnection();
            connection.setDoOutput(true);
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("User-Agent", "Universa JAVA API Client");
            try (OutputStream output = connection.getOutputStream();
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
                writer.append("--" + boundary).append(CRLF);
                writer.append("Content-Disposition: form-data; name=\"requestData\"; filename=\"requestData.boss\"").append(CRLF);
                writer.append("Content-Type: application/octet-stream").append(CRLF);
                writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                writer.append(CRLF).flush();
                output.write(data);
                output.flush();
                writer.append(CRLF).flush();
                writer.append("--" + boundary + "--").append(CRLF).flush();
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            int responseCode = httpConnection.getResponseCode();
            byte[] answer = Do.read(httpConnection.getInputStream());
            httpConnection.disconnect();
            return new Answer(responseCode, Binder.from(Boss.load(answer)));
        }
    }

    public String toString() {
        return "HTTPClient<" + this.getUrl() + ">";
    }

    public int getNodeNumber() {
        Matcher matcher;
        if (this.nodeNumber < 0 && (matcher = Pattern.compile("node-(\\d+)-").matcher(this.getUrl())).find()) {
            this.nodeNumber = Integer.valueOf(matcher.group(1));
        }
        return this.nodeNumber;
    }

    static {
        Config.forceInit(ErrorRecord.class);
        Config.forceInit(ItemState.class);
    }

    public class Answer {
        public final int code;
        public final Binder data;

        private Answer(@NonNull int code, Binder data) {
            Binder got;
            this.code = code;
            try {
                got = data.getBinderOrThrow("response");
            }
            catch (IllegalArgumentException e) {
                got = Binder.fromKeysValues("errors", Arrays.asList(new ErrorRecord(Errors.FAILURE, "", data.getString("error", "Got data has not response field."))));
            }
            this.data = got;
        }

        public String toString() {
            if (this.data.containsKey("errors")) {
                return "" + this.code + " error: " + this.data.getListOrThrow("errors");
            }
            return "" + this.code + ": " + this.data;
        }

        public boolean isOk() {
            return this.code == 200;
        }
    }

    public static class EndpointException
    extends IOException {
        private final Answer answer;

        public EndpointException(Answer answer) {
            super("Client::EndpointException " + answer);
            this.answer = answer;
        }

        public Answer getAnswer() {
            return this.answer;
        }

        public int getCode() {
            return this.answer.code;
        }

        public Binder getData() {
            return this.answer.data;
        }

        public List<ErrorRecord> getErrors() {
            return this.answer.data.getListOrThrow("errors");
        }

        public ErrorRecord getFirstError() {
            return this.getErrors().get(0);
        }
    }

    public static class ConnectionFailedException
    extends IOException {
        public ConnectionFailedException() {
            super("connection failed");
        }

        public ConnectionFailedException(String reason) {
            super(reason);
        }
    }
}

