/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import net.sergeych.tools.Binder;

public class BasicHttpClientSession {
    private String connectMessage;
    private PrivateKey privateKey;
    private SymmetricKey sessionKey;
    private long sessionId;
    private PublicKey nodePublicKey;

    public Binder asBinder() {
        return Binder.fromKeysValues("connectMessage", this.getConnectMessage(), "sessionKey", this.getSessionKey().pack(), "sessionId", this.getSessionId());
    }

    public static BasicHttpClientSession reconstructSession(Binder binder) {
        BasicHttpClientSession restoringSession = new BasicHttpClientSession();
        restoringSession.setConnectMessage((String)binder.getOrThrow("connectMessage"));
        restoringSession.setSessionKey(new SymmetricKey(binder.getBinaryOrThrow("sessionKey")));
        restoringSession.setSessionId(binder.getLongOrThrow("sessionId"));
        return restoringSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectMessage() {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            return this.connectMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectMessage(String connectMessage) {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            this.connectMessage = connectMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getPrivateKey() {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            return this.privateKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrivateKey(PrivateKey privateKey) {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            this.privateKey = privateKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymmetricKey getSessionKey() {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            return this.sessionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionKey(SymmetricKey sessionKey) {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            this.sessionKey = sessionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSessionId() {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            return this.sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionId(long sessionId) {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            this.sessionId = sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getNodePublicKey() {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            return this.nodePublicKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePublicKey(PublicKey nodePublicKey) {
        BasicHttpClientSession basicHttpClientSession = this;
        synchronized (basicHttpClientSession) {
            this.nodePublicKey = nodePublicKey;
        }
    }
}

