/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.node.network.BasicHTTPService;
import com.icodici.universa.node.network.microhttpd.MicroHTTPDService;
import com.icodici.universa.node2.network.ClientError;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.tools.BufferedLogger;
import net.sergeych.tools.Do;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongycastle.util.encoders.Base64;

public class BasicHttpServer {
    protected BasicHTTPService service;
    private final BufferedLogger log;
    private PrivateKey myKey;
    private final ConcurrentHashMap<String, SecureEndpoint> secureEndpoints = new ConcurrentHashMap();
    ConcurrentHashMap<PublicKey, Session> sessionsByKey = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Session> sessionsById = new ConcurrentHashMap();
    private AtomicLong sessionIds = new AtomicLong(ZonedDateTime.now().toEpochSecond() + (long)Do.randomInt(Integer.MAX_VALUE));

    BasicHttpServer(PrivateKey key, int port, int maxTrheads, BufferedLogger log) throws IOException {
        this.myKey = key;
        this.log = log;
        this.service = new MicroHTTPDService();
        this.addEndpoint("/ping", (Binder params) -> this.onPing(params));
        this.addEndpoint("/connect", (Binder params) -> this.onConnect(params));
        this.addEndpoint("/get_token", (Binder params) -> this.inSession(params.getLongOrThrow("session_id"), (Session s) -> s.getToken(params)));
        this.addEndpoint("/command", (Binder params) -> this.inSession(params.getLongOrThrow("session_id"), (Session s) -> s.command(params)));
        this.service.start(port, maxTrheads);
    }

    public void on(String path, BasicHTTPService.Handler handler) {
        this.service.on(path, handler);
    }

    private Binder onConnect(Binder params) throws ClientError {
        try {
            PublicKey clientKey = new PublicKey(params.getBinaryOrThrow("client_key"));
            return this.inSession(clientKey, (Session session) -> session.connect());
        }
        catch (Exception e) {
            throw new ClientError(Errors.BAD_CLIENT_KEY, "client_key", "bad client key");
        }
    }

    public void addSecureEndpoint(String commandName, SecureEndpoint ep) {
        this.secureEndpoints.put(commandName, ep);
    }

    public void addEndpoint(String path, Endpoint ep) {
        this.on(path, (request, response) -> {
            Binder result;
            try {
                Result epResult = new Result();
                ep.execute(this.extractParams(request), epResult);
                result = Binder.of("result", "ok", new Object[]{"response", epResult});
            }
            catch (Exception e) {
                result = Binder.of("result", "error", new Object[]{"error", e.toString(), "errorClass", e.getClass().getName()});
            }
            response.setBody(Boss.pack(result));
        });
    }

    void addEndpoint(String path, SimpleEndpoint sep) {
        this.addEndpoint(path, (Binder params, Result result) -> result.putAll(sep.execute(params)));
    }

    public Binder extractParams(BasicHTTPService.Request request) {
        Binder rp = request.getParams();
        String sparams = rp.getString("requestData64", null);
        if (sparams != null) {
            byte[] x = Base64.decode(sparams);
            return Boss.unpack(x);
        }
        BasicHTTPService.FileUpload rd = (BasicHTTPService.FileUpload)rp.get("requestData");
        if (rd != null) {
            byte[] data = rd.getBytes();
            return Boss.unpack(data);
        }
        return Binder.EMPTY;
    }

    private Binder onPing(Binder params) {
        Binder result = Binder.fromKeysValues("ping", "pong");
        result.putAll(params);
        return result;
    }

    public void shutdown() {
        try {
            this.service.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Binder inSession(PublicKey key, Implementor function) throws EncryptionError {
        return this.inSession(this.getSession(key), function);
    }

    private Binder inSession(Session s, Implementor processor) {
        try {
            s.errors.clear();
            return s.answer(processor.apply(s));
        }
        catch (ClientError e) {
            s.errors.add(e.getErrorRecord());
        }
        catch (Exception e) {
            s.errors.add(new ErrorRecord(Errors.FAILURE, "", e.getMessage()));
        }
        return s.answer(null);
    }

    private Binder inSession(long id, Implementor processor) {
        Session s = this.sessionsById.get(id);
        if (s == null) {
            throw new IllegalArgumentException("bad session number");
        }
        return this.inSession(s, processor);
    }

    private @NonNull Session getSession(PublicKey key) throws EncryptionError {
        Session r = this.sessionsByKey.get(key);
        if (r == null) {
            r = new Session(key);
            this.sessionsByKey.put(key, r);
            this.sessionsById.put(r.sessionId, r);
        }
        return r;
    }

    protected class Session {
        private PublicKey publicKey;
        private SymmetricKey sessionKey;
        private byte[] serverNonce;
        private byte[] encryptedAnswer;
        private long sessionId;
        private List<ErrorRecord> errors;

        protected Session(PublicKey key) throws EncryptionError {
            this.sessionId = BasicHttpServer.this.sessionIds.incrementAndGet();
            this.errors = Collections.synchronizedList(new ArrayList());
            this.publicKey = key;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        private void createSessionKey() throws EncryptionError {
            if (this.sessionKey == null) {
                this.sessionKey = new SymmetricKey();
                Binder data = Binder.fromKeysValues("sk", this.sessionKey.pack());
                this.encryptedAnswer = this.publicKey.encrypt(Boss.pack(data));
            }
        }

        Binder connect() {
            if (this.serverNonce == null) {
                this.serverNonce = Do.randomBytes(48);
            }
            return Binder.fromKeysValues("server_nonce", this.serverNonce, "session_id", "" + this.sessionId);
        }

        Binder getToken(Binder data) {
            block3: {
                byte[] signedAnswer = data.getBinaryOrThrow("data");
                try {
                    if (!this.publicKey.verify(signedAnswer, data.getBinaryOrThrow("signature"), HashType.SHA512)) break block3;
                    Binder params = Boss.unpack(signedAnswer);
                    if (!Arrays.equals(params.getBinaryOrThrow("server_nonce"), this.serverNonce)) {
                        this.addError(Errors.BAD_VALUE, "server_nonce", "does not match");
                        break block3;
                    }
                    this.createSessionKey();
                    Binder result = Binder.fromKeysValues("client_nonce", params.getBinaryOrThrow("client_nonce"), "encrypted_token", this.encryptedAnswer);
                    byte[] packed = Boss.pack(result);
                    return Binder.fromKeysValues("data", packed, "signature", BasicHttpServer.this.myKey.sign(packed, HashType.SHA512));
                }
                catch (Exception e) {
                    this.addError(Errors.BAD_VALUE, "signed_data", "wrong or tampered data block:" + e.getMessage());
                }
            }
            return null;
        }

        private Binder answer(Binder result) {
            if (result == null) {
                result = new Binder();
            }
            if (!this.errors.isEmpty()) {
                result.put("errors", this.errors);
            }
            return result;
        }

        private void addError(Errors code, String object, String message) {
            this.errors.add(new ErrorRecord(code, object, message));
        }

        public Binder command(Binder params) throws ClientError, EncryptionError {
            Binder result = null;
            try {
                result = Binder.fromKeysValues("result", this.executeAuthenticatedCommand(Boss.unpack(this.sessionKey.decrypt(params.getBinaryOrThrow("params")))));
            }
            catch (Exception e) {
                ErrorRecord r = e instanceof ClientError ? ((ClientError)e).getErrorRecord() : new ErrorRecord(Errors.COMMAND_FAILED, "", e.getMessage());
                result = Binder.fromKeysValues("error", r);
            }
            return Binder.fromKeysValues("result", this.sessionKey.encrypt(Boss.pack(result)));
        }

        private Binder executeAuthenticatedCommand(Binder params) throws ClientError {
            String cmd = params.getStringOrThrow("command");
            try {
                switch (cmd) {
                    case "hello": {
                        return Binder.fromKeysValues("status", "OK", "message", "welcome to the Universa");
                    }
                    case "sping": {
                        return Binder.fromKeysValues("sping", "spong");
                    }
                    case "test_error": {
                        throw new IllegalAccessException("sample error");
                    }
                }
                SecureEndpoint sep = (SecureEndpoint)BasicHttpServer.this.secureEndpoints.get(cmd);
                if (sep != null) {
                    return sep.execute(params.getBinder("params", Binder.EMPTY), this);
                }
            }
            catch (Exception e) {
                if (e instanceof ClientError) {
                    throw (ClientError)e;
                }
                throw new ClientError(Errors.COMMAND_FAILED, cmd, e.getMessage());
            }
            throw new ClientError(Errors.UNKNOWN_COMMAND, "command", "unknown: " + cmd);
        }
    }

    public static interface SecureEndpoint {
        public Binder execute(Binder var1, Session var2) throws Exception;
    }

    public static interface SimpleEndpoint {
        public Binder execute(Binder var1) throws Exception;
    }

    public static interface Endpoint {
        public void execute(Binder var1, Result var2) throws Exception;
    }

    class Result
    extends Binder {
        private int status = 200;

        Result() {
        }

        public void setStatus(int code) {
            this.status = code;
        }
    }

    private static interface Implementor {
        public Binder apply(Session var1) throws Exception;
    }
}

