/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.Node;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.Quantiser;
import com.icodici.universa.node2.network.BasicHttpClient;
import com.icodici.universa.node2.network.BasicHttpClientSession;
import com.icodici.universa.node2.network.ClientError;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sergeych.boss.Boss;
import net.sergeych.tools.AsyncEvent;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.tools.Reporter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Client {
    private final PrivateKey clientPrivateKey;
    private final PublicKey nodePublicKey;
    List<Client> clients;
    private String version;
    final BasicHttpClient httpClient;
    private List<NodeRecord> nodes = new ArrayList<NodeRecord>();
    private int positiveConsensus = -1;

    public final int size() {
        return this.nodes.size();
    }

    public boolean ping(int i) {
        try {
            return this.getClient(i).ping();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean ping() throws IOException {
        this.httpClient.command("sping", new Object[0]);
        return true;
    }

    Client getClient(int i) throws IOException {
        Client c = this.clients.get(i);
        if (c == null) {
            NodeRecord r = this.nodes.get(i);
            c = new Client(r.url, this.clientPrivateKey, r.key, null);
            this.clients.set(i, c);
        }
        return c;
    }

    public Client(String rootUrlString, PrivateKey clientPrivateKey, PublicKey nodePublicKey, BasicHttpClientSession session) throws IOException {
        this.httpClient = new BasicHttpClient(rootUrlString);
        this.clientPrivateKey = clientPrivateKey;
        this.nodePublicKey = nodePublicKey;
        this.httpClient.start(clientPrivateKey, nodePublicKey, session);
    }

    public Client(PrivateKey myPrivateKey, NodeInfo nodeInfo, BasicHttpClientSession session) throws IOException {
        this.httpClient = new BasicHttpClient(nodeInfo.publicUrlString());
        this.clientPrivateKey = myPrivateKey;
        this.nodePublicKey = nodeInfo.getPublicKey();
        this.httpClient.start(myPrivateKey, nodeInfo.getPublicKey(), session);
    }

    public Client(String someNodeUrl, PrivateKey clientPrivateKey, BasicHttpClientSession session) throws IOException {
        this(someNodeUrl, clientPrivateKey, session, false);
    }

    public Client(String someNodeUrl, PrivateKey clientPrivateKey, BasicHttpClientSession session, boolean delayedStart) throws IOException {
        this.clientPrivateKey = clientPrivateKey;
        this.loadNetworkFrom(someNodeUrl);
        this.clients = new ArrayList<Client>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.clients.add(null);
        }
        NodeRecord r = (NodeRecord)Do.sample(this.nodes);
        this.httpClient = new BasicHttpClient(r.url);
        this.nodePublicKey = r.key;
        if (!delayedStart) {
            this.httpClient.start(clientPrivateKey, r.key, session);
        }
    }

    public void start(BasicHttpClientSession session) throws IOException {
        this.httpClient.start(this.clientPrivateKey, this.nodePublicKey, session);
    }

    public String getUrl() {
        return this.httpClient.getUrl();
    }

    public BasicHttpClientSession getSession() throws IllegalStateException {
        return this.httpClient.getSession();
    }

    public BasicHttpClientSession getSession(int i) throws IllegalStateException, IOException {
        return this.getClient((int)i).httpClient.getSession();
    }

    public List<NodeRecord> getNodes() {
        return this.nodes;
    }

    public String getVersion() {
        return this.version;
    }

    private void loadNetworkFrom(String someNodeUrl) throws IOException {
        URL url = new URL(someNodeUrl + "/network");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "Universa JAVA API Client");
        connection.setRequestMethod("GET");
        if (connection.getResponseCode() != 200) {
            throw new IOException("failed to access " + url + ", reponseCode " + connection.getResponseCode());
        }
        Binder bres = Boss.unpack(Do.read(connection.getInputStream())).getBinderOrThrow("response");
        this.nodes.clear();
        this.version = bres.getStringOrThrow("version");
        for (Binder b : bres.getBinders("nodes")) {
            this.nodes.add(new NodeRecord(b));
        }
    }

    public ItemResult register(byte[] packed) throws ClientError {
        return this.register(packed, 0L);
    }

    public ItemResult register(byte[] packed, long millisToWait) throws ClientError {
        Object binderResult = this.protect(() -> this.httpClient.command("approve", "packedItem", packed).get("itemResult"));
        if (binderResult instanceof ItemResult) {
            ItemResult lastResult = (ItemResult)binderResult;
            if (millisToWait > 0L && lastResult.state.isPending()) {
                Instant end = Instant.now().plusMillis(millisToWait);
                try {
                    Contract c = Contract.fromPackedTransaction(packed);
                    while (Instant.now().isBefore(end) && lastResult.state.isPending()) {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        lastResult = this.getState(c.getId());
                        System.out.println("test: " + lastResult);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (Quantiser.QuantiserException e) {
                    throw new ClientError(e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return lastResult;
        }
        System.err.println("test: " + binderResult);
        return ItemResult.UNDEFINED;
    }

    public boolean registerParcel(byte[] packed) throws ClientError {
        return this.registerParcel(packed, 0L);
    }

    public boolean registerParcel(byte[] packed, long millisToWait) throws ClientError {
        Object result = this.protect(() -> this.httpClient.command("approveParcel", "packedItem", packed).get("result"));
        if (!(result instanceof String)) {
            if (millisToWait > 0L) {
                Instant end = Instant.now().plusMillis(millisToWait);
                try {
                    Parcel parcel = Parcel.unpack(packed);
                    Node.ParcelProcessingState pState = this.getParcelProcessingState(parcel.getId());
                    while (Instant.now().isBefore(end) && pState.isProcessing()) {
                        System.out.println("parcel state is: " + (Object)((Object)pState));
                        Thread.currentThread();
                        Thread.sleep(100L);
                        pState = this.getParcelProcessingState(parcel.getId());
                    }
                    System.out.println("parcel state is: " + (Object)((Object)pState));
                    ItemResult lastResult = this.getState(parcel.getPayloadContract().getId());
                    while (Instant.now().isBefore(end) && lastResult.state.isPending()) {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        lastResult = this.getState(parcel.getPayloadContract().getId());
                        System.out.println("test: " + lastResult);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (Quantiser.QuantiserException e) {
                    throw new ClientError(e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return (Boolean)result;
        }
        System.out.println(">> registerParcel " + result);
        return false;
    }

    public final ItemResult getState(@NonNull Approvable item) throws ClientError {
        return this.getState(item.getId());
    }

    public ItemResult getState(HashId itemId) throws ClientError {
        return this.protect(() -> {
            Binder result = this.httpClient.command("getState", "itemId", itemId);
            Object ir = result.getOrThrow("itemResult");
            if (ir instanceof ItemResult) {
                return (ItemResult)ir;
            }
            if (ir instanceof String) {
                System.out.println(">> " + ir);
            }
            return ItemResult.UNDEFINED;
        });
    }

    public Binder getStats() throws ClientError {
        return this.protect(() -> this.httpClient.command("getStats", new Object[0]));
    }

    public Node.ParcelProcessingState getParcelProcessingState(HashId parcelId) throws ClientError {
        return this.protect(() -> {
            Binder result = this.httpClient.command("getParcelProcessingState", "parcelId", parcelId);
            Object ps = result.getOrThrow("processingState");
            if (ps instanceof Node.ParcelProcessingState) {
                return (Node.ParcelProcessingState)((Object)((Object)ps));
            }
            return Node.ParcelProcessingState.valueOf(result.getBinder("processingState").getStringOrThrow("state"));
        });
    }

    public ItemResult getExtendedState(HashId itemId, int nodeNumber) throws ClientError {
        return this.protect(() -> (ItemResult)this.httpClient.command("getState", "itemId", itemId).getOrThrow("itemResult"));
    }

    public ItemResult getState(HashId itemId, Reporter reporter) throws ClientError {
        ExecutorService pool = Executors.newCachedThreadPool();
        ArrayList errors = new ArrayList();
        AsyncEvent consensusFound = new AsyncEvent();
        int checkConsensus = this.getNodes().size() / 3;
        AtomicInteger nodesLeft = new AtomicInteger(this.nodes.size());
        return this.protect(() -> {
            HashMap<ItemState, List> states = new HashMap<ItemState, List>();
            int i = 0;
            while (i < this.nodes.size()) {
                int nn = i++;
                pool.submit(() -> {
                    for (int retry = 0; retry < 5; ++retry) {
                        try {
                            Client c = this.getClient(nn);
                            ItemResult r = (ItemResult)c.command("getState", "itemId", itemId).getOrThrow("itemResult");
                            r.meta.put("url", c.getNodeNumber());
                            Map map = states;
                            synchronized (map) {
                                ArrayList<ItemResult> list = (ArrayList<ItemResult>)states.get((Object)r.state);
                                if (list == null) {
                                    list = new ArrayList<ItemResult>();
                                    states.put(r.state, list);
                                }
                                list.add(r);
                                if (r.errors.size() > 0) {
                                    reporter.warning("errors from " + c.getNodeNumber() + ": " + r.errors);
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    states.forEach((itemState, itemResults) -> {
                        if (itemResults.size() >= checkConsensus && itemResults.size() >= checkConsensus) {
                            consensusFound.fire();
                            return;
                        }
                    });
                    if (nodesLeft.decrementAndGet() < 1) {
                        consensusFound.fire();
                    }
                });
            }
            consensusFound.await(5000L);
            pool.shutdownNow();
            ItemResult[] consensus = new ItemResult[1];
            states.forEach((itemState, itemResults) -> {
                if (itemResults.size() >= checkConsensus) {
                    consensus[0] = (ItemResult)itemResults.get(0);
                }
            });
            if (consensus[0] != null) {
                reporter.message("State consensus found:" + consensus[0]);
            } else {
                reporter.warning("no consensus found " + states.size());
            }
            if (states.size() > 1) {
                states.entrySet().stream().sorted(Comparator.comparingInt(o -> ((List)o.getValue()).size())).forEach(kv -> {
                    List itemResults = (List)kv.getValue();
                    reporter.message("" + kv.getKey() + ": " + itemResults.size() + ": " + itemResults.stream().map(x -> x.meta.getStringOrThrow("url")).collect(Collectors.toSet()));
                });
            }
            return consensus[0];
        });
    }

    public int getNodeNumber() {
        return this.httpClient.getNodeNumber();
    }

    public Binder command(String name, Object ... params) throws IOException {
        return this.httpClient.command(name, params);
    }

    public BasicHttpClient.Answer request(String name, Object ... params) throws IOException {
        return this.httpClient.request(name, params);
    }

    protected final <T> T protect(Executor<T> e) throws ClientError {
        try {
            return e.execute();
        }
        catch (Exception ex) {
            throw new ClientError(ex);
        }
    }

    public int getPositiveConsensus() {
        if (this.positiveConsensus < 1) {
            this.positiveConsensus = (int)Math.floor((double)this.nodes.size() * 0.9);
        }
        return this.positiveConsensus;
    }

    static {
        Config.forceInit(ItemResult.class);
        Config.forceInit(ErrorRecord.class);
        Config.forceInit(HashId.class);
        Config.forceInit(Contract.class);
    }

    public class NodeRecord {
        public final String url;
        public final PublicKey key;

        private NodeRecord(Binder data) throws IOException {
            this.url = data.getStringOrThrow("url");
            try {
                this.key = new PublicKey(data.getBinaryOrThrow("key"));
            }
            catch (EncryptionError encryptionError) {
                throw new IOException("failed to construct node public key", encryptionError);
            }
        }

        public String toString() {
            return "Node(" + this.url + "," + this.key + ")";
        }
    }

    protected static interface Executor<T> {
        public T execute() throws Exception;
    }
}

