/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.PrivateKey;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node.ItemState;
import com.icodici.universa.node.network.BasicHTTPService;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.ItemCache;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.Node;
import com.icodici.universa.node2.ParcelCache;
import com.icodici.universa.node2.Quantiser;
import com.icodici.universa.node2.network.BasicHttpServer;
import com.icodici.universa.node2.network.CommandFailedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.sergeych.tools.Binder;
import net.sergeych.tools.BufferedLogger;
import net.sergeych.utils.Bytes;

public class ClientHTTPServer
extends BasicHttpServer {
    private static final String API_VERSION = "3.1.0";
    private final BufferedLogger log;
    private ItemCache cache;
    private ParcelCache parcelCache;
    private NetConfig netConfig;
    private Config config;
    private boolean localCors = false;
    private ExecutorService es = Executors.newFixedThreadPool(40);
    static AtomicInteger asyncStarts = new AtomicInteger();
    private static Binder networkData = null;
    private Node node;

    public ClientHTTPServer(PrivateKey privateKey, int port, BufferedLogger logger) throws IOException {
        super(privateKey, port, 32, logger);
        this.log = logger;
        this.addSecureEndpoint("status", (params, session) -> Binder.of("status", "initializing", new Object[]{"log", this.log.getLast(10)}));
        this.on("/contracts", (request, response) -> {
            String encodedString = request.getPath().substring(11);
            encodedString = encodedString.replace(' ', '+');
            byte[] data = null;
            if (encodedString.equals("cache_test")) {
                data = "the cache test data".getBytes();
            } else {
                Contract c;
                HashId id = HashId.withDigest(encodedString);
                if (this.cache != null && (c = (Contract)this.cache.get(id)) != null) {
                    data = c.getPackedTransaction();
                }
            }
            if (data != null) {
                Binder hh = response.getHeaders();
                hh.put("Expires", "Thu, 31 Dec 2037 23:55:55 GMT");
                hh.put("Cache-Control", "max-age=315360000");
                response.setBody(data);
            } else {
                response.setResponseCode(404);
            }
        });
        this.on("/parcels", (request, response) -> {
            String encodedString = request.getPath().substring(9);
            encodedString = encodedString.replace(' ', '+');
            byte[] data = null;
            if (encodedString.equals("cache_test")) {
                data = "the cache test data".getBytes();
            } else {
                Parcel p;
                HashId id = HashId.withDigest(encodedString);
                if (this.parcelCache != null && (p = this.parcelCache.get(id)) != null) {
                    data = p.pack();
                }
            }
            if (data != null) {
                Binder hh = response.getHeaders();
                hh.put("Expires", "Thu, 31 Dec 2037 23:55:55 GMT");
                hh.put("Cache-Control", "max-age=315360000");
                response.setBody(data);
            } else {
                response.setResponseCode(404);
            }
        });
        this.addEndpoint("/network", (Binder params, BasicHttpServer.Result result) -> {
            if (networkData == null) {
                ArrayList nodes = new ArrayList();
                result.putAll("version", "3.4.2-private-alpha", "nodes", nodes);
                if (this.netConfig != null) {
                    this.netConfig.forEachNode(node -> nodes.add(Binder.of("url", node.publicUrlString(), new Object[]{"key", node.getPublicKey().pack()})));
                }
            }
        });
        this.addSecureEndpoint("getStats", this::getStats);
        this.addSecureEndpoint("getState", this::getState);
        this.addSecureEndpoint("getParcelProcessingState", this::getParcelProcessingState);
        this.addSecureEndpoint("approve", this::approve);
        this.addSecureEndpoint("approveParcel", this::approveParcel);
        this.addSecureEndpoint("startApproval", this::startApproval);
        this.addSecureEndpoint("throw_error", this::throw_error);
    }

    @Override
    public void shutdown() {
        this.es.shutdown();
        this.node.shutdown();
        super.shutdown();
    }

    private Binder throw_error(Binder binder, BasicHttpServer.Session session) throws IOException {
        throw new IOException("just a test");
    }

    private ItemResult itemResultOfError(Errors error, String object, String message) {
        Binder binder = new Binder();
        binder.put("state", ItemState.UNDEFINED.name());
        binder.put("haveCopy", false);
        binder.put("createdAt", new Date());
        binder.put("expiresAt", new Date());
        ArrayList<ErrorRecord> errorRecords = new ArrayList<ErrorRecord>();
        errorRecords.add(new ErrorRecord(error, object, message));
        binder.put("errors", errorRecords);
        return new ItemResult(binder);
    }

    private Binder approve(Binder params, BasicHttpServer.Session session) throws IOException, Quantiser.QuantiserException {
        this.checkNode(session);
        if (!this.config.getKeysWhiteList().contains(session.getPublicKey()) && !this.config.allowFreeRegistrations()) {
            System.out.println("approve ERROR: no payment");
            return Binder.of("itemResult", this.itemResultOfError(Errors.BAD_CLIENT_KEY, "approve", "command needs client key from whitelist"), new Object[0]);
        }
        try {
            return Binder.of("itemResult", this.node.registerItem(Contract.fromPackedTransaction(params.getBinaryOrThrow("packedItem"))), new Object[0]);
        }
        catch (Exception e) {
            System.out.println("approve ERROR: " + e.getMessage());
            return Binder.of("itemResult", this.itemResultOfError(Errors.COMMAND_FAILED, "approve", e.getMessage()), new Object[0]);
        }
    }

    private Binder approveParcel(Binder params, BasicHttpServer.Session session) throws IOException, Quantiser.QuantiserException {
        this.checkNode(session);
        try {
            return Binder.of("result", (Object)this.node.registerParcel(Parcel.unpack(params.getBinaryOrThrow("packedItem"))), new Object[0]);
        }
        catch (Exception e) {
            System.out.println("approveParcel ERROR: " + e.getMessage());
            return Binder.of("itemResult", this.itemResultOfError(Errors.COMMAND_FAILED, "approveParcel", e.getMessage()), new Object[0]);
        }
    }

    private Binder startApproval(Binder params, BasicHttpServer.Session session) throws IOException, Quantiser.QuantiserException {
        if (this.config == null || !this.config.getKeysWhiteList().contains(session.getPublicKey())) {
            System.out.println("startApproval ERROR: session key shoild be in the white list");
            return Binder.of("itemResult", this.itemResultOfError(Errors.BAD_CLIENT_KEY, "startApproval", "command needs client key from whitelist"), new Object[0]);
        }
        int n = asyncStarts.incrementAndGet();
        AtomicInteger k = new AtomicInteger();
        params.getListOrThrow("packedItems").forEach(item -> this.es.execute(() -> {
            try {
                this.checkNode(session);
                System.out.println("Request to start registration #" + n + ":" + k.incrementAndGet());
                this.node.registerItem(Contract.fromPackedTransaction(((Bytes)item).toArray()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        return new Binder();
    }

    private Binder getState(Binder params, BasicHttpServer.Session session) throws CommandFailedException {
        this.checkNode(session);
        try {
            return Binder.of("itemResult", this.node.checkItem((HashId)params.get("itemId")), new Object[0]);
        }
        catch (Exception e) {
            System.out.println("getState ERROR: " + e.getMessage());
            return Binder.of("itemResult", this.itemResultOfError(Errors.COMMAND_FAILED, "approveParcel", e.getMessage()), new Object[0]);
        }
    }

    private Binder getStats(Binder params, BasicHttpServer.Session session) throws CommandFailedException {
        this.checkNode(session);
        if (this.config == null || !this.config.getNetworkAdminKey().equals(session.getPublicKey())) {
            System.out.println("command needs admin key");
            return Binder.of("itemResult", this.itemResultOfError(Errors.BAD_CLIENT_KEY, "getStats", "command needs admin key"), new Object[0]);
        }
        return this.node.provideStats();
    }

    private Binder getParcelProcessingState(Binder params, BasicHttpServer.Session session) throws CommandFailedException {
        this.checkNode(session);
        try {
            return Binder.of("processingState", (Object)this.node.checkParcelProcessingState((HashId)params.get("parcelId")), new Object[0]);
        }
        catch (Exception e) {
            System.out.println("getParcelProcessingState ERROR: " + e.getMessage());
            return Binder.of("processingState", "getParcelProcessingState ERROR: " + e.getMessage(), new Object[0]);
        }
    }

    private void checkNode(BasicHttpServer.Session session) throws CommandFailedException {
        if (this.node == null) {
            throw new CommandFailedException(Errors.NOT_READY, "", "please call again after a while");
        }
        if (this.node.isSanitating()) {
            if (this.netConfig.toList().stream().anyMatch(nodeInfo -> nodeInfo.getPublicKey().equals(session.getPublicKey()))) {
                return;
            }
            throw new CommandFailedException(Errors.NOT_READY, "", "please call again after a while");
        }
    }

    @Override
    public void on(String path, BasicHTTPService.Handler handler) {
        super.on(path, (request, response) -> {
            if (this.localCors) {
                Binder hh = response.getHeaders();
                hh.put("Access-Control-Allow-Origin", "*");
                hh.put("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
                hh.put("Access-Control-Allow-Headers", "DNT,X-CustomHeader,Keep-Alive,User-Age  nt,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Content-Range,Range");
                hh.put("Access-Control-Expose-Headers", "DNT,X-CustomHeader,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Content-Range,Range");
            }
            handler.handle(request, response);
        });
    }

    public ItemCache getCache() {
        return this.cache;
    }

    public void setCache(ItemCache cache) {
        this.cache = cache;
    }

    public ParcelCache getParcelCache() {
        return this.parcelCache;
    }

    public void setParcelCache(ParcelCache cache) {
        this.parcelCache = cache;
    }

    public void setNetConfig(NetConfig netConfig) {
        this.netConfig = netConfig;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public boolean isLocalCors() {
        return this.localCors;
    }

    public void setLocalCors(boolean localCors) {
        this.localCors = localCors;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

