/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.SymmetricKey;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class DatagramAdapter {
    BlockingQueue<byte[]> inputQueue = new LinkedBlockingQueue<byte[]>();
    public static final int MAX_PACKET_SIZE = 512;
    public static final int RETRANSMIT_MAX_ATTEMPTS = 50;
    public static final int RETRANSMIT_TIME = 250;
    protected NodeInfo myNodeInfo;
    protected NetConfig netConfig;
    protected Consumer<byte[]> receiver = null;
    protected final SymmetricKey sessionKey;
    protected final PrivateKey ownPrivateKey;
    protected int testMode = 0;
    protected int verboseLevel = 0;
    protected int lostPacketsPercent = 50;
    protected List<Function<String, String>> errorCallbacks = new ArrayList<Function<String, String>>();

    public DatagramAdapter(PrivateKey ownPrivateKey, SymmetricKey sessionKey, NodeInfo myNodeInfo, NetConfig netConfig) {
        this.myNodeInfo = myNodeInfo;
        this.netConfig = netConfig;
        this.sessionKey = sessionKey;
        this.ownPrivateKey = ownPrivateKey;
    }

    public abstract void send(NodeInfo var1, byte[] var2) throws EncryptionError, InterruptedException;

    public abstract void shutdown();

    public void addErrorsCallback(Function<String, String> fn) {
        this.errorCallbacks.add(fn);
    }

    public void receive(Consumer<byte[]> receiver) {
        byte[] payload;
        this.receiver = receiver;
        while ((payload = (byte[])this.inputQueue.poll()) != null) {
            receiver.accept(payload);
        }
    }

    public void setTestMode(int testMode) {
        this.testMode = testMode;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public void setLostPacketsPercentInTestMode(int percent) {
        this.lostPacketsPercent = percent;
    }

    public class VerboseLevel {
        public static final int NOTHING = 0;
        public static final int BASE = 1;
        public static final int DETAILED = 2;
    }

    public class TestModes {
        public static final int NONE = 0;
        public static final int LOST_PACKETS = 1;
        public static final int SHUFFLE_PACKETS = 2;
        public static final int LOST_AND_SHUFFLE_PACKETS = 3;
    }
}

