/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.Notification;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;

public abstract class Network {
    protected NetConfig netConfig;

    public Network(NetConfig netConfig) {
        this.netConfig = netConfig;
    }

    public NodeInfo getInfo(int number) {
        return this.netConfig.getInfo(number);
    }

    public abstract void deliver(NodeInfo var1, Notification var2);

    public abstract void subscribe(NodeInfo var1, Consumer<Notification> var2);

    public abstract Approvable getItem(HashId var1, NodeInfo var2, Duration var3) throws InterruptedException;

    public abstract Parcel getParcel(HashId var1, NodeInfo var2, Duration var3) throws InterruptedException;

    public void broadcast(NodeInfo exceptNode, Notification notification) {
        this.netConfig.forEachNode(node -> {
            if (exceptNode != null && !exceptNode.equals(node)) {
                this.deliver((NodeInfo)node, notification);
            }
        });
    }

    public void eachNode(Consumer<NodeInfo> consumer) {
        this.netConfig.forEachNode(n -> consumer.accept((NodeInfo)n));
    }

    public int getNodesCount() {
        return this.netConfig.size();
    }

    public List<NodeInfo> allNodes() {
        return this.netConfig.toList();
    }

    public void shutdown() {
    }

    public ItemResult getItemState(NodeInfo nodeInfo, HashId id) throws IOException {
        return null;
    }

    public void addNode(NodeInfo nodeInfo) {
        this.netConfig.addNode(nodeInfo);
    }

    public void removeNode(NodeInfo nodeInfo) {
        this.netConfig.removeNode(nodeInfo);
    }
}

