/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.node2.network;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.SymmetricKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.contract.TransactionPack;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.NetConfig;
import com.icodici.universa.node2.NodeInfo;
import com.icodici.universa.node2.Notification;
import com.icodici.universa.node2.network.Client;
import com.icodici.universa.node2.network.Network;
import com.icodici.universa.node2.network.UDPAdapter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Do;
import net.sergeych.utils.LogPrinter;

public class NetworkV2
extends Network {
    private final NodeInfo myInfo;
    private final PrivateKey myKey;
    private UDPAdapter adapter;
    private static LogPrinter log = new LogPrinter("TLN");
    protected int verboseLevel = 0;
    private Consumer<Notification> consumer;
    private final Map<NodeInfo, Client> cachedClients = new HashMap<NodeInfo, Client>();

    public NetworkV2(NetConfig netConfig, NodeInfo myInfo, PrivateKey myKey) throws IOException {
        super(netConfig);
        this.myInfo = myInfo;
        this.myKey = myKey;
        this.adapter = new UDPAdapter(myKey, new SymmetricKey(), myInfo, netConfig);
        this.adapter.receive(this::onReceived);
        this.adapter.addErrorsCallback(this::exceptionCallback);
    }

    private final void onReceived(byte[] packedNotifications) {
        try {
            if (this.consumer != null) {
                List<Notification> nn = this.unpack(packedNotifications);
                for (Notification n : nn) {
                    if (n == null) {
                        this.report(this.getLabel(), "bad notification skipped", 1);
                        continue;
                    }
                    this.consumer.accept(n);
                }
            }
        }
        catch (IOException e) {
            this.report(this.getLabel(), "ignoring notification, " + e, 1);
        }
    }

    private List<Notification> unpack(byte[] packedNotifications) throws IOException {
        ArrayList<Notification> nn = new ArrayList<Notification>();
        try {
            Boss.Reader r = new Boss.Reader(packedNotifications);
            if (r.readInt() != 1) {
                throw new IOException("invalid packed notification type code");
            }
            int number = r.readInt();
            NodeInfo from = this.getInfo(number);
            if (from == null) {
                throw new IOException(this.myInfo.getNumber() + ": unknown node number: " + number);
            }
            int count = r.readInt();
            if (count < 0 || count > 1000) {
                throw new IOException("unvalid packed notifications count: " + count);
            }
            for (int i = 0; i < count; ++i) {
                nn.add(Notification.read(from, r));
            }
            return nn;
        }
        catch (Exception e) {
            this.report(this.getLabel(), "failed to unpack notification: " + e, 1);
            throw new IOException("failed to unpack notifications", e);
        }
    }

    private final byte[] packNotifications(NodeInfo from, Collection<Notification> notifications) {
        Boss.Writer w = new Boss.Writer();
        try {
            w.write(1).write(from.getNumber()).write(notifications.size());
            notifications.forEach(n -> {
                try {
                    Notification.write(w, n);
                }
                catch (IOException e) {
                    throw new RuntimeException("notificaiton pack failure", e);
                }
            });
            return w.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("notificaiton pack failure", e);
        }
    }

    @Override
    public void deliver(NodeInfo toNode, Notification notification) {
        try {
            byte[] data = this.packNotifications(this.myInfo, Do.listOf(notification));
            if (this.adapter != null) {
                this.adapter.send(toNode, data);
            } else {
                this.report(this.getLabel(), "UDPAdapter is null");
            }
        }
        catch (InterruptedException e) {
            this.report(this.getLabel(), "Expected interrupted exception");
        }
        catch (Exception e) {
            this.report(this.getLabel(), "deliver exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void subscribe(NodeInfo _info, Consumer<Notification> notificationConsumer) {
        this.consumer = notificationConsumer;
    }

    @Override
    public Approvable getItem(HashId itemId, NodeInfo nodeInfo, Duration maxTimeout) throws InterruptedException {
        try {
            URL url = new URL(nodeInfo.publicUrlString() + "/contracts/" + itemId.toBase64String());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Universa JAVA API Client");
            connection.setRequestProperty("Connection", "close");
            connection.setRequestMethod("GET");
            if (200 != connection.getResponseCode()) {
                return null;
            }
            byte[] data = Do.read(connection.getInputStream());
            TransactionPack tp = TransactionPack.unpack(data, true);
            return tp.getContract();
        }
        catch (Exception e) {
            this.report(this.getLabel(), "download failure. from: " + nodeInfo.getNumber() + " by: " + this.myInfo.getNumber() + " reason: " + e, 1);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Parcel getParcel(HashId itemId, NodeInfo nodeInfo, Duration maxTimeout) throws InterruptedException {
        try {
            URL url = new URL(nodeInfo.publicUrlString() + "/parcels/" + itemId.toBase64String());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Universa JAVA API Client");
            connection.setRequestProperty("Connection", "close");
            connection.setRequestMethod("GET");
            if (200 != connection.getResponseCode()) {
                return null;
            }
            byte[] data = Do.read(connection.getInputStream());
            Parcel parcel = Parcel.unpack(data);
            return parcel;
        }
        catch (Exception e) {
            this.report(this.getLabel(), "download failure. from: " + nodeInfo.getNumber() + " by: " + this.myInfo.getNumber() + " reason: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemResult getItemState(NodeInfo nodeInfo, HashId id) throws IOException {
        Client client;
        Map<NodeInfo, Client> map = this.cachedClients;
        synchronized (map) {
            client = this.cachedClients.get(nodeInfo);
            if (client == null) {
                client = new Client(this.myKey, nodeInfo, null);
                this.cachedClients.put(nodeInfo, client);
            }
        }
        return client.getState(id);
    }

    private String exceptionCallback(String message) {
        this.report(this.getLabel(), "UDP adapter error: " + message, 1);
        return message;
    }

    @Override
    public void shutdown() {
        if (this.adapter != null) {
            this.adapter.shutdown();
        }
    }

    public void restartUDPAdapter() throws IOException {
        if (this.adapter != null) {
            this.adapter.shutdown();
        }
        this.adapter = new UDPAdapter(this.myKey, new SymmetricKey(), this.myInfo, this.netConfig);
        this.adapter.receive(this::onReceived);
        this.adapter.addErrorsCallback(this::exceptionCallback);
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public int getUDPVerboseLevel() {
        if (this.adapter != null) {
            return this.adapter.getVerboseLevel();
        }
        return 0;
    }

    public void setUDPVerboseLevel(int level) {
        if (this.adapter != null) {
            this.adapter.setVerboseLevel(level);
        }
    }

    public UDPAdapter getUDPAdapter() {
        return this.adapter;
    }

    public String getLabel() {
        return "Network Node " + this.myInfo.getNumber() + ": ";
    }

    public void report(String label, String message, int level) {
        if (level <= this.verboseLevel) {
            System.out.println(label + message);
        }
    }

    public void report(String label, String message) {
        this.report(label, message, 2);
    }
}

