/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.wallet;

import com.icodici.universa.Decimal;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.permissions.SplitJoinPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Wallet {
    public static final int MAX_SELECTIONS_OF_CONTRACTS = 7;
    private List<Contract> contracts = new ArrayList<Contract>();

    public synchronized Contract buildContractWithValue(String fieldName, @NonNull Decimal value) throws Exception {
        if (value == null || Decimal.ZERO.equals(value) || this.contracts.size() == 0) {
            return null;
        }
        Contract result = null;
        this.contracts.sort(Comparator.comparing(c -> this.getValue((Contract)c, fieldName)));
        ArrayList<Contract> selectedContracts = new ArrayList<Contract>();
        int contractsSize = this.contracts.size();
        Decimal sum = Decimal.ZERO;
        for (int i = 0; i < contractsSize; ++i) {
            Contract contract = this.contracts.get(i);
            Decimal cValue = this.getValue(contract, fieldName);
            sum = sum.add(cValue);
            if (selectedContracts.size() >= 7 && selectedContracts.get(i % 7) != null) {
                sum.subtract(this.getValue((Contract)selectedContracts.get(i % 7), fieldName));
                selectedContracts.set(i % 7, contract);
            } else {
                selectedContracts.add(i % 7, contract);
            }
            int compared = sum.compareTo(value);
            if (compared == 0) {
                result = this.joinAndRemoveFromContracts(selectedContracts);
                result.getStateData().set(fieldName, sum);
                break;
            }
            if (compared != 1) continue;
            result = this.joinAndRemoveFromContracts(selectedContracts);
            result.getStateData().set(fieldName, sum);
            Contract newContract = result.splitValue(fieldName, sum.subtract(value));
            this.contracts.add(newContract);
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("The amount of contracts from the walled does not match the expected value.");
        }
        return result;
    }

    private Contract joinAndRemoveFromContracts(List<Contract> selectedContracts) throws Exception {
        Contract result = selectedContracts.get(0).copy();
        result.getRevokingItems().addAll(selectedContracts);
        this.contracts.removeAll(selectedContracts);
        result.setKeysToSignWith(selectedContracts.get(0).getKeysToSignWith());
        return result;
    }

    private Decimal getValue(Contract c, String fieldName) {
        return new Decimal(c.getStateData().getStringOrThrow(fieldName));
    }

    public static List<Wallet> determineWallets(List<Contract> contracts) {
        HashMap wallets = new HashMap();
        for (Contract contract : contracts) {
            Object split_join;
            Collection<Permission> splitJoinCollection;
            if (contract.getPermissions() == null || (splitJoinCollection = contract.getPermissions().get("split_join")) == null || splitJoinCollection.size() == 0 || !((split_join = splitJoinCollection.toArray()[0]) instanceof SplitJoinPermission)) continue;
            Object join_match_fields = ((SplitJoinPermission)split_join).getParams().get("join_match_fields");
            Object field2 = join_match_fields instanceof List ? ((List)join_match_fields).get(0) : join_match_fields;
            Wallet wallet = (Wallet)wallets.get(field2);
            if (wallet == null) {
                wallet = new Wallet();
            }
            wallet.addContract(contract);
            wallets.put(field2, wallet);
        }
        return new ArrayList<Wallet>(wallets.values());
    }

    public Wallet addContract(Contract contract) {
        this.contracts.add(contract);
        return this;
    }

    public List<Contract> getContracts() {
        return this.contracts;
    }

    public Wallet setContracts(List<Contract> contracts) {
        this.contracts = contracts;
        return this;
    }
}

