/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Fields {
    public static Field locate(Class definedIn, Class fieldType, boolean isStatic) {
        AccessibleObject field2 = null;
        try {
            Field[] fields = definedIn.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers()) != isStatic || !fieldType.isAssignableFrom(fields[i].getType())) continue;
                field2 = fields[i];
            }
            if (field2 != null && !field2.isAccessible()) {
                ((Field)field2).setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return field2;
    }

    public static Field find(Class type, String name) {
        try {
            Field result = type.getDeclaredField(name);
            if (!result.isAccessible()) {
                result.setAccessible(true);
            }
            return result;
        }
        catch (SecurityException e) {
            throw Fields.wrap("Cannot access field", type, name, e);
        }
        catch (NoSuchFieldException e) {
            throw Fields.wrap("Cannot access field", type, name, e);
        }
        catch (NoClassDefFoundError e) {
            throw Fields.wrap("Cannot access field", type, name, e);
        }
    }

    public static void write(Field field2, Object instance, Object value) {
        try {
            field2.set(instance, value);
        }
        catch (SecurityException e) {
            throw Fields.wrap("Cannot write field", field2.getType(), field2.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw Fields.wrap("Cannot write field", field2.getType(), field2.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw Fields.wrap("Cannot write field", field2.getType(), field2.getName(), e);
        }
        catch (NoClassDefFoundError e) {
            throw Fields.wrap("Cannot write field", field2.getType(), field2.getName(), e);
        }
    }

    public static Object read(Field field2, Object instance) {
        try {
            return field2.get(instance);
        }
        catch (SecurityException e) {
            throw Fields.wrap("Cannot read field", field2.getType(), field2.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw Fields.wrap("Cannot read field", field2.getType(), field2.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw Fields.wrap("Cannot read field", field2.getType(), field2.getName(), e);
        }
        catch (NoClassDefFoundError e) {
            throw Fields.wrap("Cannot read field", field2.getType(), field2.getName(), e);
        }
    }

    private static ObjectAccessException wrap(String message, Class type, String name, Throwable ex) {
        ObjectAccessException exception = new ObjectAccessException(message, ex);
        exception.add("field", type.getName() + "." + name);
        return exception;
    }
}

