/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.biserializer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiMapper;
import net.sergeych.biserializer.DefaultBiMapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BiDeserializer {
    private BiMapper mapper;
    private Stack stack;
    private Object context = null;

    public BiDeserializer(BiMapper mapper) {
        this.mapper = mapper;
    }

    public BiDeserializer() {
        this.mapper = DefaultBiMapper.getInstance();
    }

    public <T, U> T deserialize(U object) {
        return this.mapper.deserializeObject(object, this);
    }

    public <T> List<T> deserializeCollection(Collection<?> collection) {
        return collection.stream().map(x -> this.mapper.deserializeObject(x, this)).collect(Collectors.toList());
    }

    public void deserializeInPlace(Map map) {
        this.mapper.deserializeInPlace(map, this);
    }

    public final <T> T getContext() {
        return (T)this.context;
    }

    public final <T> @NonNull T getContextOrThrow() {
        if (this.context == null) {
            throw new IllegalArgumentException("context not set");
        }
        return (T)this.context;
    }

    public <T, E extends Throwable> void withContext(@NonNull T contextValue, ContextBlock<E> block) throws E {
        try {
            if (this.context != null) {
                if (this.stack == null) {
                    this.stack = new Stack();
                }
                this.stack.push(this.context);
            }
            this.context = contextValue;
            block.perform();
        }
        finally {
            this.context = this.stack != null && !this.stack.isEmpty() ? this.stack.pop() : null;
        }
    }

    @FunctionalInterface
    public static interface ContextBlock<E extends Throwable> {
        public void perform() throws E;
    }
}

