/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.biserializer;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializableAdapter;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BossBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BiMapper {
    private HashMap<String, BiAdapter> adapters = new HashMap();
    private int revision = 0;

    public BiMapper() {
    }

    public BiMapper(BiMapper parent) {
        this.adapters.putAll(parent.adapters);
    }

    public void deserializeInPlace(Map map, BiDeserializer deserializer) {
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                String typeName = (String)((Map)value).get("__type");
                if (typeName == null) {
                    typeName = (String)((Map)value).get("__t");
                }
                if (typeName == null) {
                    this.deserializeInPlace((Map)value, deserializer);
                } else {
                    BiAdapter adapter = this.adapters.get(typeName);
                    if (adapter != null) {
                        map.put(key, adapter.deserialize(Binder.from(value), deserializer));
                    }
                }
            } else if (value instanceof Collection) {
                map.put(key, ((Collection)value).stream().map(x -> deserializer.deserialize(x)).collect(Collectors.toList()));
            }
        });
    }

    public <T> T deserialize(Map map, BiDeserializer deserializer) {
        BiAdapter adapter;
        String typeName = (String)map.get("__type");
        if (typeName == null) {
            typeName = (String)map.get("__t");
        }
        if (typeName != null && (adapter = this.adapters.get(typeName)) != null) {
            return adapter.deserialize(Binder.from(map), deserializer);
        }
        this.deserializeInPlace(map, deserializer);
        return (T)map;
    }

    public <T> T deserialize(Map map) {
        return this.deserialize(map, new BiDeserializer(this));
    }

    public <T> T deserializeObject(Object x) {
        return x == null ? null : (T)this.deserializeObject(x, new BiDeserializer(this));
    }

    public <T> T deserializeObject(Object obj, BiDeserializer deserializer) {
        if (obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof ZonedDateTime || obj instanceof Bytes || obj == null) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            return this.deserialize((Map)obj, deserializer);
        }
        if (obj instanceof Collection) {
            return (T)((Collection)obj).stream().map(x -> this.deserializeObject(x)).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("don't know how to deserealize " + obj.getClass().getCanonicalName());
    }

    public <T> @NonNull T serialize(Object x, BiSerializer serializer) {
        if (x instanceof String || x instanceof Number || x instanceof Boolean || x == null) {
            return (T)x;
        }
        Class<?> klass = x.getClass();
        if (klass.isArray() && klass.getComponentType() != Byte.TYPE) {
            x = Arrays.asList((Object[])x);
        }
        if (x instanceof Collection) {
            return (T)((Collection)x).stream().map(i -> this.serialize(i, serializer)).collect(Collectors.toList());
        }
        String canonicalName = klass.getCanonicalName();
        BiAdapter adapter = this.adapters.get(canonicalName);
        if (adapter == null) {
            if (x instanceof Map) {
                ((Map)((Object)x)).replaceAll((k, v) -> this.serialize(v, serializer));
                return (T)x;
            }
            return (T)x;
        }
        Binder result = adapter.serialize(x, serializer);
        String tn = adapter.typeName();
        result.put("__type", tn != null ? tn : canonicalName);
        return (T)result;
    }

    public <T> @NonNull T serialize(Object x) {
        return this.serialize(x, new BiSerializer(this));
    }

    public <T> void registerAdapter(Class<T> klass, BiAdapter adapter) {
        this.adapters.put(klass.getCanonicalName(), adapter);
        String typeName = adapter.typeName();
        if (typeName != null) {
            this.adapters.put(typeName, adapter);
        }
        ++this.revision;
        BossBiMapper.recalculateMapper();
    }

    int getRevision() {
        return this.revision;
    }

    public boolean unregister(Class klass) {
        String key = klass.getCanonicalName();
        BiAdapter a = this.adapters.get(key);
        if (a == null) {
            return false;
        }
        this.adapters.remove(key);
        key = a.typeName();
        if (key != null) {
            this.adapters.remove(key);
        }
        ++this.revision;
        return true;
    }

    public void registerClass(Class<? extends BiSerializable> klass) {
        this.registerAdapter(klass, new BiSerializableAdapter(klass));
    }

    public BiSerializer newSerializer() {
        return new BiSerializer(this);
    }

    public BiDeserializer newDeserializer() {
        return new BiDeserializer(this);
    }
}

