/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.biserializer;

import java.lang.reflect.Constructor;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializationException;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.tools.Binder;

class BiSerializableAdapter
implements BiAdapter {
    private Class<? extends BiSerializable> objectClass;
    private String typeAlias = null;

    public BiSerializableAdapter(Class<? extends BiSerializable> objectClass) {
        this.objectClass = objectClass;
        BiType tn = objectClass.getAnnotation(BiType.class);
        if (tn != null) {
            this.typeAlias = tn.name();
        }
    }

    @Override
    public String typeName() {
        return this.typeAlias == null ? this.objectClass.getCanonicalName() : this.typeAlias;
    }

    public Binder serialize(Object object, BiSerializer s) {
        return ((BiSerializable)object).serialize(s);
    }

    public Object deserialize(Binder binder, BiDeserializer deserializer) {
        try {
            Constructor<? extends BiSerializable> c = this.objectClass.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            BiSerializable bs = c.newInstance(new Object[0]);
            bs.deserialize(binder, deserializer);
            return bs;
        }
        catch (Exception e) {
            throw new BiSerializationException("failed to deserialize " + this.typeName() + ": " + this.objectClass.getCanonicalName(), e);
        }
    }
}

