/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.biserializer;

import java.time.ZonedDateTime;
import java.util.Map;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiMapper;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BossBiMapper {
    private static BiMapper mapper = null;
    private static int lastRevision = 0;

    public static void deserializeInPlace(Map map) {
        new BiDeserializer(BossBiMapper.getInstance()).deserializeInPlace(map);
    }

    public static BiMapper getInstance() {
        return mapper;
    }

    public static void recalculateMapper() {
        BiMapper full = DefaultBiMapper.getInstance();
        if (mapper == null || lastRevision < full.getRevision()) {
            BiMapper m = new BiMapper(full);
            lastRevision = full.getRevision();
            m.unregister(ZonedDateTime.class);
            m.unregister(new byte[0].getClass());
            m.unregister(Bytes.class);
            mapper = m;
        }
    }

    public static <T> T deserialize(Map map) {
        return new BiDeserializer(BossBiMapper.getInstance()).deserialize(Binder.from(map));
    }

    public static <T> @NonNull T serialize(Object x) {
        return BossBiMapper.newSerializer().serialize(x);
    }

    public static void registerAdapter(Class<?> klass, BiAdapter adapter) {
        BossBiMapper.getInstance().registerAdapter(klass, adapter);
    }

    public static void registerClass(Class<? extends BiSerializable> klass) {
        BossBiMapper.getInstance().registerClass(klass);
    }

    public static BiDeserializer newDeserializer() {
        return new BiDeserializer(BossBiMapper.getInstance());
    }

    public static BiSerializer newSerializer() {
        return new BiSerializer(BossBiMapper.getInstance());
    }

    static {
        BossBiMapper.recalculateMapper();
    }
}

