/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.biserializer;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiMapper;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Base64;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultBiMapper {
    static final BiMapper defaultInstance = new BiMapper();

    public static final BiMapper getInstance() {
        return defaultInstance;
    }

    public static void deserializeInPlace(Map map) {
        new BiDeserializer().deserializeInPlace(map);
    }

    public static <T> T deserialize(Map map) {
        return new BiDeserializer().deserialize(Binder.from(map));
    }

    public static <T> @NonNull T serialize(Object x) {
        return new BiSerializer().serialize(x);
    }

    public static <T> void registerAdapter(Class<T> klass, BiAdapter adapter) {
        defaultInstance.registerAdapter(klass, adapter);
    }

    public static void registerClass(Class<? extends BiSerializable> klass) {
        defaultInstance.registerClass(klass);
    }

    static {
        DefaultBiMapper.registerAdapter(ZonedDateTime.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.fromKeysValues("seconds", ((ZonedDateTime)object).toEpochSecond());
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(binder.getLongOrThrow("seconds")), ZoneOffset.systemDefault());
            }

            @Override
            public String typeName() {
                return "unixtime";
            }
        });
        byte[] dummy = new byte[]{};
        DefaultBiMapper.registerAdapter(dummy.getClass(), new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.of("base64", Base64.encodeLines((byte[])object), new Object[0]);
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                return Base64.decodeLines(binder.getStringOrThrow("base64"));
            }

            @Override
            public String typeName() {
                return "binary";
            }
        });
        DefaultBiMapper.registerAdapter(Bytes.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.of("base64", Base64.encodeLines(((Bytes)object).getData()), new Object[0]);
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                return new Bytes(new byte[][]{Base64.decodeLines(binder.getStringOrThrow("base64"))});
            }

            @Override
            public String typeName() {
                return "binary";
            }
        });
    }
}

