/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.boss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BossBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Bytes;

public class Boss {
    private static boolean useOldDates = false;
    private static final int TYPE_INT = 0;
    private static final int TYPE_EXTRA = 1;
    private static final int TYPE_NINT = 2;
    private static final int TYPE_TEXT = 3;
    private static final int TYPE_BIN = 4;
    private static final int TYPE_CREF = 5;
    private static final int TYPE_LIST = 6;
    private static final int TYPE_DICT = 7;
    private static final int XT_DZERO = 1;
    private static final int XT_DONE = 2;
    private static final int XT_DMINUSONE = 4;
    private static final int XT_DOUBLE = 7;
    private static final int XT_TTRUE = 12;
    private static final int XT_FALSE = 13;
    private static final int XT_TIME = 15;
    private static final int XT_STREAM_MODE = 16;

    public static boolean isUseOldDates() {
        return useOldDates;
    }

    public static void setUseOldDates(boolean useOldDates) {
        Boss.useOldDates = useOldDates;
    }

    public static Bytes dump(Object first, Object ... objects) {
        return new Bytes(new byte[][]{Boss.dumpToArray(first, objects)});
    }

    public static byte[] pack(Object object) {
        return Boss.dumpToArray(object, new Object[0]);
    }

    public static byte[] dumpToArray(Object first, Object ... objects) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Writer w = new Writer(bos);
            w.writeObject(first);
            for (Object o : objects) {
                w.writeObject(o);
            }
            w.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Boss can't dump this object", ex);
        }
    }

    public static <K, V> Map<K, V> loadMap(Bytes bytes) {
        return (Map)Boss.load(bytes);
    }

    public static <T> T load(Bytes bytes) {
        return Boss.load(bytes.toArray());
    }

    public static <T> T load(byte[] data) {
        try {
            return new Reader(new ByteArrayInputStream(data)).read();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Boss: can't parse data", e);
        }
    }

    public static <T> T load(byte[] data, BiDeserializer mapper) {
        try {
            return new Reader(new ByteArrayInputStream(data), mapper).read();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Boss: can't parse data", e);
        }
    }

    public static Binder unpack(byte[] data) {
        return (Binder)Boss.load(data);
    }

    public static void trace(byte[] packed) {
        Object obj = Boss.load(packed);
        System.out.println(Boss.traceObject("", obj));
    }

    public static void trace(Object object) {
        System.out.println(Boss.traceObject("", object));
    }

    private static String traceObject(String prefix, Object obj) {
        if (obj instanceof Bytes || obj instanceof byte[]) {
            Bytes bb;
            Bytes bytes = bb = obj instanceof Bytes ? (Bytes)obj : new Bytes(new byte[][]{(byte[])obj});
            if (bb.size() > 30) {
                return prefix + bb.part(0, 30).toHex() + String.format(" ...(%d bytes)\n", bb.size());
            }
            return prefix + bb.toHex() + "\n";
        }
        if (obj instanceof Object[] || obj instanceof List) {
            return Boss.traceArray(prefix, Do.collection(obj));
        }
        if (obj instanceof Binder) {
            Binder i = (Binder)obj;
            StringBuilder b = new StringBuilder();
            for (Map.Entry e : i.entrySet()) {
                b.append(prefix + (String)e.getKey() + ":\n");
                b.append(Boss.traceObject(prefix + "  ", e.getValue()));
            }
            return b.toString();
        }
        return prefix + (obj == null ? "null" : "\"" + obj.toString() + "\"") + "\n";
    }

    private static String traceArray(String prefix, Collection<?> objects) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (Object x : objects) {
            String p1 = prefix + i++ + ": ";
            b.append(Boss.traceObject(p1, x));
        }
        return b.toString();
    }

    public static class Reader {
        protected InputStream in;
        protected boolean treeMode;
        protected boolean showTrace = false;
        private ArrayList<Object> cache;
        private int maxCacheEntries;
        private int maxStringSize;
        private final BiDeserializer deserializer;

        public Reader(byte[] bytes) {
            this(new ByteArrayInputStream(bytes));
        }

        public Reader(InputStream stream, BiDeserializer deserializer) {
            this.in = stream;
            this.cache = new ArrayList();
            this.treeMode = true;
            this.deserializer = deserializer;
        }

        public Reader(InputStream stream) {
            this(stream, BossBiMapper.newDeserializer());
        }

        public void traceObject() throws IOException {
            Header h = this.readHeader();
            System.out.println(h);
        }

        private Header readHeader() throws IOException {
            int b = this.readByte();
            int code = b & 7;
            int value = b >>> 3;
            if (value >= 31) {
                int length = (int)this.readEncodedLong();
                return new Header(code, this.readBig(length));
            }
            if (value > 22) {
                return new Header(code, this.readLong(value - 22));
            }
            return new Header(code, value);
        }

        private final int readByte() throws IOException {
            int i = this.in.read();
            if (i < 0) {
                throw new EOFException();
            }
            return i;
        }

        private long readEncodedLong() throws IOException {
            long value = 0L;
            int shift = 0;
            while (true) {
                int n = this.readByte();
                value |= ((long)n & 0x7FL) << shift;
                if ((n & 0x80) != 0) {
                    return value;
                }
                shift += 7;
            }
        }

        private BigInteger readBig(int length) throws IOException {
            Bytes bb = new Bytes(this.in, length);
            bb.flipSelf();
            return bb.toBigInteger();
        }

        private long readLong(int length) throws IOException {
            if (length <= 8) {
                long res = 0L;
                int n = 0;
                while (length-- > 0) {
                    res |= (long)this.readByte() << n;
                    n += 8;
                }
                return res;
            }
            throw new IllegalArgumentException("readlLong needs up to 8 bytes as length");
        }

        public void setTrace(boolean on) {
            this.showTrace = on;
        }

        protected void trace(String s) {
            if (this.showTrace) {
                System.out.println(s);
            }
        }

        private void traceCache() {
            this.trace("Cache: " + this.cache.toString());
        }

        public <T> T read() throws IOException {
            T x = this.get();
            if (this.deserializer == null || !(x instanceof Binder) && !(x instanceof Collection)) {
                return x;
            }
            return this.deserializer.deserialize(x);
        }

        private <T> T get() throws IOException {
            Header h = this.readHeader();
            switch (h.code) {
                case 0: {
                    return (T)h.smallestNumber(false);
                }
                case 2: {
                    return (T)h.smallestNumber(true);
                }
                case 3: 
                case 4: {
                    Bytes bb;
                    Bytes bytes = bb = h.value > 0L ? new Bytes(this.in, (int)h.value) : new Bytes(new byte[0][]);
                    if (h.code == 3) {
                        String s = bb.toString();
                        this.cacheObject(s);
                        return (T)s;
                    }
                    this.cacheObject(bb);
                    return (T)bb;
                }
                case 6: {
                    ArrayList<T> data = new ArrayList<T>((int)(h.value < 65536L ? h.value : 4096L));
                    this.cacheObject(data);
                    int i = 0;
                    while ((long)i < h.value) {
                        data.add(this.get());
                        ++i;
                    }
                    return (T)data;
                }
                case 7: {
                    return this.readObject(h);
                }
                case 5: {
                    int i = (int)h.value;
                    return (T)(i == 0 ? null : this.cache.get(i - 1));
                }
                case 1: {
                    return (T)this.parseExtra((int)h.value);
                }
            }
            throw new IOException("Bad BOSS header");
        }

        private <T> T readObject(Header h) throws IOException {
            Dictionary hash = new Dictionary();
            this.cacheObject(hash);
            int i = 0;
            while ((long)i < h.value) {
                hash.put(this.get(), this.get());
                ++i;
            }
            return (T)hash;
        }

        public int readInt() throws IOException {
            Number n = (Number)this.get();
            return n.intValue();
        }

        List<Object> getCache() {
            return this.cache;
        }

        private void cacheObject(Object obj) {
            if (this.treeMode) {
                this.cache.add(obj);
            } else {
                long len;
                if (obj instanceof String) {
                    len = ((String)obj).length();
                } else if (obj instanceof Bytes) {
                    len = ((Bytes)obj).size();
                } else if (obj instanceof byte[]) {
                    len = ((byte[])obj).length;
                } else {
                    return;
                }
                if (len <= (long)this.maxStringSize) {
                    this.cache.add(obj);
                    if (this.cache.size() > this.maxCacheEntries) {
                        this.cache.remove(0);
                    }
                }
            }
        }

        private Object parseExtra(int code) throws IOException {
            switch (code) {
                case 1: {
                    return 0.0;
                }
                case 2: {
                    return 1.0;
                }
                case 4: {
                    return -1.0;
                }
                case 12: {
                    return true;
                }
                case 13: {
                    return false;
                }
                case 15: {
                    long seconds = this.readEncodedLong();
                    return useOldDates ? new Date(seconds * 1000L) : Instant.ofEpochSecond(seconds).atZone(ZoneId.systemDefault());
                }
                case 16: {
                    this.setStreamMode();
                    return this.get();
                }
                case 7: {
                    return new Bytes(this.in, 8).toDouble();
                }
            }
            throw new IllegalArgumentException(String.format("Unknown extra code: %d", code));
        }

        private void setStreamMode() throws IOException {
            if (this.cache.size() > 0) {
                this.cache = new ArrayList();
            }
            this.treeMode = false;
        }

        public Bytes readBytes() throws IOException {
            return (Bytes)this.get();
        }

        public byte[] readBinary() throws IOException {
            Object x = this.get();
            if (x == null) {
                return null;
            }
            if (x.getClass().isArray()) {
                return (byte[])x;
            }
            return ((Bytes)x).toArray();
        }

        public Object[] readArray() throws IOException {
            return (Object[])this.get();
        }

        public BigInteger readBigInteger() throws IOException {
            return (BigInteger)this.get();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Map<String, Object> readMap() throws IOException {
            return (Map)this.get();
        }

        public long readLong() throws IOException {
            Number n = (Number)this.get();
            return n.longValue();
        }
    }

    public static class Writer {
        private OutputStream out;
        private HashMap<Object, Integer> cache;
        private boolean treeMode;
        private final BiSerializer biSerializer;

        public Writer(OutputStream outputStream, BiSerializer biSerializer) {
            this.out = outputStream;
            this.cache = new HashMap();
            this.cache.put(null, 0);
            this.treeMode = true;
            this.biSerializer = biSerializer;
        }

        public Writer(OutputStream outputStream) {
            this(outputStream, BossBiMapper.newSerializer());
        }

        public Writer() {
            this(new ByteArrayOutputStream());
        }

        private static int sizeInBytes(long value) {
            int cnt = 1;
            while (value > 255L) {
                ++cnt;
                value >>>= 8;
            }
            return cnt;
        }

        public void setStreamMode() throws IOException {
            this.cache = new HashMap();
            this.cache.put(null, 0);
            this.treeMode = false;
            this.writeHeader(1, 16L);
        }

        public Writer write(Object ... objects) throws IOException {
            for (Object x : objects) {
                this.put(x);
            }
            return this;
        }

        public Writer writeObject(Object obj) throws IOException {
            if (!(this.biSerializer == null || obj instanceof Number || obj instanceof String || obj instanceof ZonedDateTime || obj instanceof Boolean)) {
                this.put(this.biSerializer.serialize(obj));
            } else {
                this.put(obj);
            }
            return this;
        }

        private Writer put(Object obj) throws IOException {
            if (obj instanceof Number) {
                Number n = (Number)obj;
                if (obj instanceof Integer || obj instanceof Long) {
                    long value = n.longValue();
                    if (value >= 0L) {
                        this.writeHeader(0, value);
                    } else {
                        this.writeHeader(2, -value);
                    }
                    return this;
                }
                if (obj instanceof BigInteger) {
                    BigInteger bi = (BigInteger)obj;
                    if (bi.signum() >= 0) {
                        this.writeHeader(0, bi);
                    } else {
                        this.writeHeader(2, bi.negate());
                    }
                    return this;
                }
                double d = n.doubleValue();
                if (d == 0.0) {
                    this.writeHeader(1, 1L);
                    return this;
                }
                if (d == -1.0) {
                    this.writeHeader(1, 4L);
                    return this;
                }
                if (d == 1.0) {
                    this.writeHeader(1, 2L);
                    return this;
                }
                this.writeHeader(1, 7L);
                Bytes.fromDouble(n.doubleValue()).write(this.out);
                return this;
            }
            if (obj instanceof CharSequence) {
                String s = obj.toString();
                if (!this.tryWriteReference(s)) {
                    Bytes bb = new Bytes(s);
                    this.writeHeader(3, bb.size());
                    this.out.write(bb.toArray());
                }
                return this;
            }
            if (obj instanceof Bytes) {
                obj = ((Bytes)obj).toArray();
            } else if (obj instanceof ByteBuffer) {
                obj = ((ByteBuffer)obj).array();
            }
            if (obj instanceof byte[]) {
                byte[] bb = (byte[])obj;
                if (!this.tryWriteReference(bb)) {
                    this.writeHeader(4, bb.length);
                    this.out.write(bb);
                }
                return this;
            }
            if (obj instanceof Object[]) {
                this.writeArray((Object[])obj);
                return this;
            }
            if (obj instanceof Boolean) {
                this.writeHeader(1, (Boolean)obj != false ? 12L : 13L);
                return this;
            }
            if (obj instanceof Date) {
                this.writeHeader(1, 15L);
                this.writeEncoded(((Date)obj).getTime() / 1000L);
                return this;
            }
            if (obj instanceof ZonedDateTime) {
                this.writeHeader(1, 15L);
                this.writeEncoded(((ZonedDateTime)obj).toEpochSecond());
                return this;
            }
            if (obj instanceof Map) {
                this.writeMap(obj);
                return this;
            }
            if (obj instanceof Collection) {
                this.writeArray((Collection)obj);
                return this;
            }
            if (obj == null) {
                this.writeHeader(5, 0L);
                return this;
            }
            throw new IllegalArgumentException("unknown type: " + obj.getClass());
        }

        private void writeMap(Object obj) throws IOException {
            if (!this.tryWriteReference(obj)) {
                Map map = (Map)obj;
                this.writeHeader(7, map.size());
                for (Map.Entry e : map.entrySet()) {
                    this.put(e.getKey());
                    this.put(e.getValue());
                }
            }
        }

        private void writeArray(Object[] array) throws IOException {
            if (!this.tryWriteReference(array)) {
                this.writeHeader(6, array.length);
                for (Object x : array) {
                    this.put(x);
                }
            }
        }

        private void writeArray(Collection<?> collection) throws IOException {
            if (!this.tryWriteReference(collection)) {
                this.writeHeader(6, collection.size());
                for (Object x : collection) {
                    this.put(x);
                }
            }
        }

        private boolean tryWriteReference(Object obj) throws IOException {
            Integer index = this.cache.get(obj);
            if (index != null) {
                this.writeHeader(5, index.intValue());
                return true;
            }
            if (this.treeMode) {
                this.cache.put(obj, this.cache.size());
            }
            return false;
        }

        private void writeHeader(int code, BigInteger value) throws IOException {
            this.out.write(code | 0xF8);
            Bytes bb = Bytes.fromBigInt(value).flipSelf();
            this.writeEncoded(bb.size());
            bb.write(this.out);
        }

        private void writeHeader(int code, long value) throws IOException {
            assert (code >= 0 && code <= 7);
            assert (value >= 0L);
            if (value < 23L) {
                this.out.write(code | (int)value << 3);
            } else {
                int n = Writer.sizeInBytes(value);
                if (n < 9) {
                    this.out.write(code | n + 22 << 3);
                } else {
                    this.out.write(code | 0xF8);
                    this.writeEncoded(n);
                }
                while (n-- > 0) {
                    this.out.write((int)value & 0xFF);
                    value >>>= 8;
                }
            }
        }

        private void writeEncoded(long value) throws IOException {
            while (value > 127L) {
                this.out.write((int)value & 0x7F);
                value >>= 7;
            }
            this.out.write((int)value | 0x80);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }

        public OutputStream getOut() {
            return this.out;
        }

        public byte[] toByteArray() {
            if (this.out instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.out).toByteArray();
            }
            throw new IllegalStateException("underlying OutputStream is not a ByteArrayOutputStream");
        }
    }

    public static class Dictionary
    extends Binder {
    }

    protected static class Header {
        public int code;
        public long value;
        public BigInteger bigValue;

        public Header(int _code, long _value) {
            this.code = _code;
            this.value = _value;
        }

        public Header(int _code, BigInteger big) {
            this.bigValue = big;
            this.code = _code;
        }

        public Object smallestNumber(boolean negative) {
            if (this.bigValue != null) {
                return negative ? this.bigValue.negate() : this.bigValue;
            }
            if (Math.abs(this.value) <= Integer.MAX_VALUE) {
                return negative ? (int)(-this.value) : (int)this.value;
            }
            return negative ? -this.value : this.value;
        }

        public String toString() {
            return String.format("BH: code=%d value=%d bigValue=%s", this.code, this.value, this.bigValue);
        }
    }
}

