/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Multimap<K, V> {
    private final Class<? extends Collection<V>> collectionClass;
    protected Map<K, Collection<V>> map;
    int size = 0;

    public static <T, U> Multimap newInstance() {
        return new Multimap(HashMap.class, ArrayList.class);
    }

    public Multimap() {
        this.collectionClass = ArrayList.class;
        this.map = new HashMap<K, Collection<V>>();
    }

    public Multimap(Class<? extends Map> mapClass, Class<? extends Collection<V>> collectionClass) {
        try {
            this.collectionClass = collectionClass;
            this.map = mapClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate Multimap's map", e);
        }
    }

    public int size() {
        return this.size;
    }

    public @Nullable Collection<V> get(K key) {
        Collection<V> collection = this.map.get(key);
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    public @Nullable V getFirst(K key) {
        Collection<V> collection = this.map.get(key);
        return collection == null ? null : (V)collection.iterator().next();
    }

    public @NonNull List<V> getList(K key) {
        Collection<V> collection = this.map.get(key);
        ArrayList<V> list = new ArrayList<V>();
        if (collection != null && !collection.isEmpty()) {
            list.addAll(collection);
        }
        return list;
    }

    public void forEach(BiConsumer<? super K, ? super Collection<V>> action) {
        this.map.forEach(action);
    }

    public void put(@NonNull K key, @NonNull V value) {
        boolean added;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            try {
                collection = this.collectionClass.newInstance();
                this.map.put(key, collection);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to instantiate collection", e);
            }
        }
        if (added = collection.add(value)) {
            ++this.size;
        }
    }

    public <C extends Collection<V>> C remove(@NonNull K key) {
        Collection<V> collection = this.map.remove(key);
        if (collection != null) {
            this.size -= collection.size();
            return (C)collection;
        }
        return null;
    }

    public boolean removeValue(@NonNull K key, @NonNull V value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean removed = collection.remove(value);
        if (removed) {
            --this.size;
        }
        if (collection.isEmpty()) {
            this.map.remove(key);
        }
        return removed;
    }

    public boolean containsKey(@NonNull K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(key);
    }

    public @NonNull Set<K> keySet() {
        return this.map.keySet();
    }

    public @NonNull List<V> values() {
        ArrayList<V> all = new ArrayList<V>(this.size);
        for (Collection<V> collection : this.map.values()) {
            all.addAll(collection);
        }
        return all;
    }
}

