/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.diff;

import java.util.HashMap;
import java.util.Map;
import net.sergeych.diff.CreatedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.RemovedItem;

public class ArrayDelta<T, U>
extends Delta {
    private final Map<Integer, Delta> changes = new HashMap<Integer, Delta>();

    public Map<Integer, Delta> getChanges() {
        return this.changes;
    }

    ArrayDelta(Delta parent, T[] tt, U[] uu) {
        super(parent, tt, uu);
        int i;
        for (i = 0; i < tt.length; ++i) {
            if (i < uu.length) {
                Object d = Delta.between(this, tt[i], uu[i]);
                if (d == null) continue;
                this.changes.put(i, (Delta)d);
                continue;
            }
            this.changes.put(i, new RemovedItem(this, tt[i]));
        }
        for (i = tt.length; i < uu.length; ++i) {
            this.changes.put(i, new CreatedItem<U>(parent, uu[i]));
        }
        this.registerInParent();
    }

    public static <T, U> Delta compare(Delta parent, T[] tt, U[] uu) {
        ArrayDelta<T, U> d = new ArrayDelta<T, U>(parent, tt, uu);
        return d.isEmpty() ? null : d;
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public Delta getChange(int index) {
        return this.changes.get(index);
    }
}

