/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sergeych.diff.ArrayDelta;
import net.sergeych.diff.ByteArrayDelta;
import net.sergeych.diff.ChangedItem;
import net.sergeych.diff.ListDelta;
import net.sergeych.diff.MapDelta;

public abstract class Delta<T, U> {
    private final Delta parent;
    private final T oldValue;
    private final U newValue;
    private final List<Delta> children = new ArrayList<Delta>();

    public Delta(Delta parent, T oldValue, U newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parent = parent;
    }

    protected void registerInParent() {
        if (this.parent != null && !this.isEmpty()) {
            this.parent.children.add(this);
        }
    }

    public Delta getParent() {
        return this.parent;
    }

    static <T, U, D extends Delta> D between(Delta parent, T oldValue, U newValue) {
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            return (D)new ChangedItem<T, U>(parent, oldValue, newValue);
        }
        if (oldValue instanceof Map && newValue instanceof Map) {
            return (D)MapDelta.compare(parent, (Map)oldValue, (Map)newValue);
        }
        if (oldValue instanceof List && newValue instanceof List) {
            return (D)ListDelta.compare(parent, (List)oldValue, (List)newValue);
        }
        Class<?> oldValueClass = oldValue.getClass();
        if (oldValueClass.isArray() && newValue.getClass().isArray()) {
            if (oldValueClass.getComponentType() == Byte.TYPE) {
                return (D)ByteArrayDelta.compare(parent, (byte[])oldValue, (byte[])newValue);
            }
            return (D)ArrayDelta.compare(parent, (Object[])oldValue, (Object[])newValue);
        }
        return (D)(oldValue.equals(newValue) ? null : new ChangedItem<T, U>(parent, oldValue, newValue));
    }

    public static <T, U, D extends Delta> D between(T oldValue, U newValue) {
        return Delta.between(null, oldValue, newValue);
    }

    public T oldValue() {
        return this.oldValue;
    }

    public U newValue() {
        return this.newValue;
    }

    public abstract boolean isEmpty();

    public List<Delta> getNestedDelta() {
        return this.children;
    }
}

