/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.diff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sergeych.diff.CreatedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.RemovedItem;

public class ListDelta<T, U>
extends Delta {
    private final Map<Integer, Delta> changes = new HashMap<Integer, Delta>();

    public Map<Integer, Delta> getChanges() {
        return this.changes;
    }

    ListDelta(Delta parent, List<T> tt, List<U> uu) {
        super(parent, tt, uu);
        int i;
        for (i = 0; i < tt.size(); ++i) {
            if (i < uu.size()) {
                Object d = Delta.between(this, tt.get(i), uu.get(i));
                if (d == null) continue;
                this.changes.put(i, (Delta)d);
                continue;
            }
            this.changes.put(i, new RemovedItem(this, tt.get(i)));
        }
        for (i = tt.size(); i < uu.size(); ++i) {
            this.changes.put(i, new CreatedItem<U>(parent, uu.get(i)));
        }
        this.registerInParent();
    }

    public static <T, U> Delta compare(Delta parent, List<T> tt, List<U> uu) {
        ListDelta<T, U> d = new ListDelta<T, U>(parent, tt, uu);
        return d.isEmpty() ? null : d;
    }

    public void addChange(int atIndex, Delta change) {
        this.changes.put(atIndex, change);
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public Delta getChange(int index) {
        return this.changes.get(index);
    }
}

