/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.diff;

import java.util.HashMap;
import java.util.Map;
import net.sergeych.diff.CreatedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.RemovedItem;

public class MapDelta<T, V, U>
extends Delta {
    private final Map<T, Delta> changes = new HashMap<T, Delta>();

    MapDelta(Delta parent, Map<T, U> oldMap, Map<T, U> newMap) {
        super(parent, oldMap, newMap);
        oldMap.forEach((key, oldValue) -> {
            if (newMap.containsKey(key)) {
                Object newValue = newMap.get(key);
                Object d = Delta.between(this, oldValue, newValue);
                if (d != null) {
                    this.changes.put((T)key, (Delta)d);
                }
            } else {
                this.changes.put(key, new RemovedItem(this, oldValue));
            }
        });
        newMap.forEach((key, value) -> {
            if (!oldMap.containsKey(key)) {
                this.changes.put(key, new CreatedItem<Object>(this, value));
            }
        });
        this.registerInParent();
    }

    public Map<T, Delta> getChanges() {
        return this.changes;
    }

    public static MapDelta compare(Delta parent, Map oldMap, Map newMap) {
        MapDelta delta = new MapDelta(parent, oldMap, newMap);
        return delta.isEmpty() ? null : delta;
    }

    public static MapDelta compare(Map oldMap, Map newMap) {
        return new MapDelta(null, oldMap, newMap);
    }

    @Override
    public boolean isEmpty() {
        for (Delta d : this.changes.values()) {
            if (d.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Delta getChange(T key) {
        return this.changes.get(key);
    }

    public void remove(T field2) {
        this.changes.remove(field2);
    }
}

