/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.farcall;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Map;
import net.sergeych.boss.Boss;
import net.sergeych.farcall.BasicConnector;
import net.sergeych.farcall.Connector;

public class BossConnector
extends BasicConnector
implements Connector {
    private final Boss.Reader bossIn;
    private final Boss.Writer bossOut;

    public BossConnector(InputStream in, OutputStream out) throws IOException {
        super(in, out);
        this.bossIn = new Boss.Reader(in);
        this.bossOut = new Boss.Writer(out);
        this.bossOut.setStreamMode();
    }

    @Override
    public void send(Map<String, Object> data) throws IOException {
        if (this.closed.get()) {
            throw new IOException("connection closed");
        }
        this.bossOut.write(data);
    }

    @Override
    public Map<String, Object> receive() throws IOException {
        try {
            return this.bossIn.readMap();
        }
        catch (EOFException | SocketException ignored) {
            return null;
        }
    }
}

