/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.farcall;

import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Command {
    private final String name;
    private ArrayList<Object> params;
    private Map<String, Object> keyParams;

    Command(Map<String, Object> input) throws ProtocolException {
        try {
            this.name = (String)input.get("cmd");
            if (this.name == null || this.name.isEmpty()) {
                throw new ProtocolException("command name can't be empty");
            }
            Object rawArgs = input.get("args");
            if (rawArgs instanceof Object[]) {
                this.params = new ArrayList();
                for (Object x : (Object[])rawArgs) {
                    this.params.add(x);
                }
            } else {
                this.params = (ArrayList)rawArgs;
            }
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.keyParams = (Map)input.get("kwargs");
            if (this.keyParams == null) {
                this.keyParams = new HashMap<String, Object>();
            }
        }
        catch (ClassCastException e) {
            throw new ProtocolException("bad command record");
        }
    }

    public ArrayList<Object> getParams() {
        return this.params;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getKeyParams() {
        return this.keyParams;
    }

    public <T> T getParam(String keyName) {
        return (T)this.keyParams.get(keyName);
    }

    public <T> T getParam(String keyName, T defaultValue) {
        Object result = this.keyParams.get(keyName);
        return (T)(result == null ? defaultValue : result);
    }

    public <T> T getParam(int n) {
        return (T)this.params.get(n);
    }

    public <T> T getParam(int n, T defaultValue) {
        Object result = this.params.get(n);
        return (T)(result == null ? defaultValue : result);
    }

    public int paramsSize() {
        return this.params.size();
    }

    public boolean is(String someName) {
        return this.name.equals(someName);
    }
}

