/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.farcall;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sergeych.farcall.Command;
import net.sergeych.farcall.Connector;
import net.sergeych.tools.DeferredResult;
import net.sergeych.utils.LogPrinter;
import net.sergeych.utils.Ut;

public class Farcall {
    private static LogPrinter log = new LogPrinter("FCAL");
    private final Connector connector;
    private Target target;
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private ExecutorService executor;
    private Thread worker;
    private final Object access = new Object();
    private int inSerial = 0;
    private int outSerial = 0;
    private boolean requestStop = false;
    private final Map<Integer, CommandResult> resultQueue = new ConcurrentHashMap<Integer, CommandResult>();

    public Farcall(Connector connector) {
        this.connector = connector;
    }

    public void asyncCommands(ExecutorService service) {
        this.executor = service;
    }

    public void asyncCommands() {
        this.executor = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Target target) {
        Object object = this.access;
        synchronized (object) {
            if (this.worker != null) {
                throw new IllegalStateException("farcall instance is already started");
            }
            this.requestStop = false;
            this.target = target;
            this.worker = new Thread(new Runnable(){

                @Override
                public void run() {
                    Farcall.this.receiveCommands();
                }
            });
            this.worker.setName("farcall receiver for " + this);
        }
        this.worker.start();
    }

    public void start() {
        this.start(new Target(){

            @Override
            public Object onCommand(Command command) throws Exception {
                throw new RemoteException("unknown_command", "command is not known");
            }
        });
    }

    private void receiveCommands() {
        while (!this.requestStop) {
            try {
                Map<String, Object> input = this.connector.receive();
                if (input == null) break;
                int serial = ((Number)input.get("serial")).intValue();
                if (this.inSerial++ != serial) {
                    throw new ProtocolException("farcall sync lost");
                }
                Number ref = (Number)input.get("ref");
                if (ref != null) {
                    this.processReply(input, ref.intValue());
                    continue;
                }
                this.processCommand(input, serial);
            }
            catch (EOFException e) {
                log.i("closing farcall instance on eof encountered", new Object[0]);
                this.close();
            }
            catch (IOException e) {
                log.wtf("internal error", e);
                break;
            }
        }
        this.close();
    }

    private void processCommand(Map<String, Object> input, int serial) throws IOException {
        if (this.executor != null) {
            this.executor.submit(() -> this.doCall(input, serial));
        } else {
            this.doCall(input, serial);
        }
    }

    private void doCall(Map<String, Object> input, int serial) {
        try {
            Object result = this.target.onCommand(new Command(input));
            this.sendToRemote("ref", serial, "result", result);
        }
        catch (RemoteException e) {
            this.sendErrorNoExceptions(serial, e.getRemoteErrorClass(), e.getRemoteErrorText());
        }
        catch (Exception e) {
            this.sendErrorNoExceptions(serial, e.getClass().getSimpleName(), e.getMessage());
        }
    }

    private void sendError(int serial, String remoteErrorClass, String remoteErrorText) throws IOException {
        this.sendToRemote("ref", serial, "error", Ut.mapFromArray("class", remoteErrorClass, "text", remoteErrorText));
    }

    private void sendErrorNoExceptions(int serial, String remoteErrorClass, String remoteErrorText) {
        try {
            this.sendError(serial, remoteErrorClass, remoteErrorText);
        }
        catch (IOException e) {
            log.wtf("failed to send asynchronous answer: " + remoteErrorText, e);
        }
    }

    private void processReply(Map<String, Object> input, Integer ref) {
        CommandResult dr = this.resultQueue.remove(ref);
        if (dr != null) {
            Object error = input.get("error");
            if (error != null) {
                dr.sendFailure(RemoteException.makeException(error));
            } else {
                Object result = input.get("result");
                dr.sendSuccess(result);
            }
        }
    }

    public boolean isClosed() {
        return this.worker == null;
    }

    public CommandResult send(String name) {
        return this.send(name, null, null);
    }

    public CommandResult send(String name, ArrayList<Object> params, HashMap<String, Object> keyParams) {
        if (this.worker == null) {
            throw new IllegalStateException("farcall instance must be started");
        }
        return this.sendToRemote("cmd", name, "args", params, "kwargs", keyParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult sendToRemote(Object ... keysValues) {
        HashMap<String, Object> packet = Ut.mapFromArray(keysValues);
        Object object = this.access;
        synchronized (object) {
            if (this.isClosed()) {
                CommandResult closedResult = new CommandResult(0);
                closedResult.sendFailure(new EOFException("farcall is closed"));
                return closedResult;
            }
            packet.put("serial", this.outSerial);
            CommandResult result = new CommandResult(this.outSerial);
            this.resultQueue.put(this.outSerial, result);
            try {
                this.connector.send(packet);
            }
            catch (IOException e) {
                this.resultQueue.remove(this.outSerial);
                result.sendFailure(e);
                this.close();
                return result;
            }
            ++this.outSerial;
            return result;
        }
    }

    public CommandResult sendParams(String name, Object ... params) {
        return this.send(name, Ut.arrayToList(params), null);
    }

    public CommandResult sendKeyParams(String name, Object ... keysAndValues) {
        return this.send(name, null, Ut.mapFromArray(keysAndValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Thread t = null;
        Object object = this.access;
        synchronized (object) {
            if (this.worker != null) {
                t = this.worker;
                this.worker = null;
            }
        }
        if (t != null) {
            this.requestStop = true;
            t.interrupt();
            EOFException eof = new EOFException();
            for (CommandResult dr : this.resultQueue.values()) {
                dr.sendFailure(eof);
            }
            this.resultQueue.clear();
            this.connector.close();
        }
    }

    public class CommandResult
    extends DeferredResult {
        private int commandSerial;

        CommandResult(int outSerial) {
            this.commandSerial = outSerial;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CommandResult) {
                return ((CommandResult)obj).commandSerial == this.commandSerial;
            }
            return false;
        }

        public int hashCode() {
            return this.commandSerial;
        }
    }

    public static class RemoteException
    extends Exception {
        private String remoteErrorClass;
        private String remoteErrorText;
        private Map<String, Object> data;

        public RemoteException(String remoteErrorClass, String remoteErrorText) {
            this.remoteErrorClass = remoteErrorClass;
            this.remoteErrorText = remoteErrorText;
        }

        static Exception makeException(Object error) {
            if (error instanceof Map) {
                return new RemoteException((Map)error);
            }
            return new ProtocolException("bad remote exception record: " + error);
        }

        RemoteException(Map<String, Object> data) {
            this.data = data;
            this.remoteErrorClass = (String)data.get("class");
            this.remoteErrorText = data.get("text").toString();
        }

        public String getRemoteErrorClass() {
            return this.remoteErrorClass;
        }

        public String getRemoteErrorText() {
            return this.remoteErrorText;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "Farcall.RemoteException " + (this.data == null ? "null" : Ut.mapToString(this.data));
        }
    }

    public static interface Target {
        public Object onCommand(Command var1) throws Exception;
    }
}

