/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.farcall;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.sergeych.farcall.Connector;
import net.sergeych.utils.Ut;

public class Interconnection {
    private final QueueConnector connectorA;
    private final QueueConnector connectorB;
    private final ArrayBlockingQueue<Object> qa;
    private final ArrayBlockingQueue<Object> qb;
    private boolean bIsClosed = false;
    private boolean aIsClosed = false;

    public QueueConnector getConnectorA() {
        return this.connectorA;
    }

    public Connector getConnectorB() {
        return this.connectorB;
    }

    public Interconnection(int capacity) {
        this.qa = new ArrayBlockingQueue(capacity);
        this.qb = new ArrayBlockingQueue(capacity);
        this.connectorA = new QueueConnector(this.qa, this.qb);
        this.connectorB = new QueueConnector(this.qb, this.qa);
    }

    public void close() {
        this.connectorA.close();
        this.connectorB.close();
    }

    public class QueueConnector
    implements Connector {
        private final BlockingQueue<Object> input;
        private final BlockingQueue<Object> output;
        private boolean closed = false;
        private boolean _trace = false;
        private long pause = 0L;

        public QueueConnector(BlockingQueue<Object> input, BlockingQueue<Object> output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public void send(Map<String, Object> data) throws IOException {
            try {
                if (this._trace) {
                    System.out.println(">>> " + Ut.mapToString(data));
                }
                this.output.put(data);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public Map<String, Object> receive() throws IOException {
            try {
                if (this.closed) {
                    return null;
                }
                Map take = (Map)this.input.take();
                if (this.pause > 0L) {
                    Thread.sleep(this.pause);
                }
                if (this._trace) {
                    System.out.println("<<< " + Ut.mapToString(take));
                }
                return take;
            }
            catch (ClassCastException ignored) {
                throw new ProtocolException("bad data in channel");
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.input.offer(null);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public QueueConnector trace(boolean on) {
            this._trace = on;
            return this;
        }

        public QueueConnector pause(long millis) {
            this.pause = millis;
            return this;
        }
    }
}

