/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.farcall;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.sergeych.farcall.BasicConnector;
import net.sergeych.farcall.Connector;

public class JsonConnector
extends BasicConnector
implements Connector {
    public JsonConnector(InputStream in, OutputStream out) {
        super(in, out);
    }

    @Override
    public void send(Map<String, Object> data) throws IOException {
        if (this.closed.get()) {
            throw new IOException("connection closed");
        }
        this.out.write((JsonConnector.toJsonString(data) + "\n").getBytes());
    }

    @Override
    public Map<String, Object> receive() throws IOException {
        StringBuilder str = new StringBuilder();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (true) {
            int code;
            if ((code = this.in.read()) < 0) {
                return null;
            }
            if (code == 10) break;
            bos.write(code);
        }
        return (Map)JsonConnector.fromJson(new String(bos.toByteArray()));
    }
}

